/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.SAXDocumentBuilder;
import uk.ac.starlink.votable.VOSAXDocumentBuilder;

class CustomDOMBuilder
implements ContentHandler {
    private final SAXDocumentBuilder builder;
    private final Namespacing namespacing;
    private ContentHandler customHandler = new DefaultContentHandler();
    private Locator locator;

    public CustomDOMBuilder(boolean strict) {
        this.builder = new VOSAXDocumentBuilder(strict);
        this.namespacing = Namespacing.getInstance();
    }

    public void setCustomHandler(ContentHandler handler) {
        this.customHandler = handler;
    }

    public ContentHandler getCustomHandler() {
        return this.customHandler;
    }

    public Node getNewestNode() {
        return this.builder.getNewestNode();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public Document getDocument() {
        return this.builder.getDocument();
    }

    protected String getVOTagName(String namespaceURI, String localName, String qName) {
        return this.namespacing.getVOTagName(namespaceURI, localName, qName);
    }

    protected String getVOTagName(Element el) {
        return this.namespacing.getVOTagName(el);
    }

    protected String getAttribute(Attributes atts, String name) {
        String val = atts.getValue(name);
        return val != null ? val : atts.getValue("", name);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.customHandler.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.customHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.customHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.customHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.customHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.customHandler.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.customHandler.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.customHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.customHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.customHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.customHandler.skippedEntity(name);
    }

    public class NullContentHandler
    implements ContentHandler {
        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    public class DefaultContentHandler
    implements ContentHandler {
        @Override
        public void setDocumentLocator(Locator locator) {
            CustomDOMBuilder.this.builder.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            CustomDOMBuilder.this.builder.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            CustomDOMBuilder.this.builder.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            CustomDOMBuilder.this.builder.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            CustomDOMBuilder.this.builder.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CustomDOMBuilder.this.builder.startElement(namespaceURI, localName, qName, atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            CustomDOMBuilder.this.builder.endElement(namespaceURI, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            CustomDOMBuilder.this.builder.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            CustomDOMBuilder.this.builder.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            CustomDOMBuilder.this.builder.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            CustomDOMBuilder.this.builder.skippedEntity(name);
        }
    }
}

