/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.util.Arrays;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.IOConsumer;

public abstract class StringElementSizer {
    public static final StringElementSizer NOCALC = StringElementSizer.createNocalcSizer();
    public static final StringElementSizer READ = StringElementSizer.createSampleReadSizer(-1);
    public static final StringElementSizer SAMPLE = StringElementSizer.createSampleReadSizer(1000);
    public static final StringElementSizer FIXED2 = StringElementSizer.createFixedSizer(2);
    public static final StringElementSizer ERROR_IF_USED = StringElementSizer.createNoUseSizer("errorIfUsed", msg -> {
        throw new IOException((String)msg);
    });
    public static final StringElementSizer ASSERT_UNUSED = StringElementSizer.createNoUseSizer("assertUnused", msg -> {
        assert (false) : msg;
    });

    public abstract int[] calculateStringArrayElementSizes(StarTable var1, int[] var2) throws IOException;

    private static StringElementSizer createNocalcSizer() {
        return new StringElementSizer(){

            @Override
            public int[] calculateStringArrayElementSizes(StarTable table, int[] icols) {
                int[] elSizes = new int[icols.length];
                for (int i = 0; i < icols.length; ++i) {
                    elSizes[i] = table.getColumnInfo(icols[i]).getElementSize();
                }
                return elSizes;
            }

            public String toString() {
                return "noCalc";
            }
        };
    }

    public static StringElementSizer createFixedSizer(final int elSize) {
        return new StringElementSizer(){

            @Override
            public int[] calculateStringArrayElementSizes(StarTable table, int[] icols) {
                int[] elSizes = new int[icols.length];
                Arrays.fill(elSizes, elSize);
                return elSizes;
            }

            public String toString() {
                return "fixed" + elSize;
            }
        };
    }

    private static StringElementSizer createNoUseSizer(final String name, final IOConsumer<String> usedReport) {
        return new StringElementSizer(){

            @Override
            public int[] calculateStringArrayElementSizes(StarTable table, int[] icols) throws IOException {
                if (icols.length > 0) {
                    usedReport.accept("Unsized String array columns detected");
                }
                return new int[icols.length];
            }

            public String toString() {
                return name;
            }
        };
    }

    public static StringElementSizer createSampleReadSizer(int maxRow) {
        String name;
        long laxRow;
        if (maxRow > 0) {
            laxRow = maxRow;
            name = "limitedRead" + maxRow;
        } else {
            laxRow = Long.MAX_VALUE;
            name = "read";
        }
        return new StringElementSizer(){

            @Override
            public int[] calculateStringArrayElementSizes(StarTable table, int[] icols) throws IOException {
                int nc = icols.length;
                int[] elSizes = new int[nc];
                try (RowSequence rseq = table.getRowSequence();){
                    int irow = 0;
                    while (rseq.next() && (long)irow < laxRow) {
                        for (int i = 0; i < nc; ++i) {
                            int icol = icols[i];
                            Object value = rseq.getCell(icol);
                            int siz = 0;
                            if (value instanceof String[]) {
                                for (String s : (String[])value) {
                                    if (s == null) continue;
                                    siz = Math.max(siz, s.length());
                                }
                            }
                            if (siz <= elSizes[i]) continue;
                            elSizes[i] = siz;
                        }
                        ++irow;
                    }
                }
                return elSizes;
            }

            public String toString() {
                return name;
            }
        };
    }
}

