/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.BinaryRowSequence;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.TabularData;
import uk.ac.starlink.votable.VOElement;

class TableBodies {
    TableBodies() {
    }

    static Class<?>[] getClasses(Decoder[] decoders) {
        int ncol = decoders.length;
        Class[] classes = new Class[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            classes[icol] = decoders[icol].getContentClass();
        }
        return classes;
    }

    private static String getVOTagName(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof VOElement) {
            return ((VOElement)element).getVOTagName();
        }
        return element.getTagName();
    }

    static class TabledataTabularData
    extends SequentialTabularData {
        final Decoder[] decoders;
        final Element tabledataEl;
        final int ncol;
        Element[] rows;

        TabledataTabularData(Decoder[] decoders, Element tabledataEl) {
            super(TableBodies.getClasses(decoders));
            this.decoders = decoders;
            this.tabledataEl = tabledataEl;
            this.ncol = decoders.length;
        }

        @Override
        public long getRowCount() {
            if (this.rows == null) {
                long nrow = 0L;
                for (Node node = this.tabledataEl.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !TableBodies.getVOTagName((Element)node).equals("TR")) continue;
                    ++nrow;
                }
                return nrow;
            }
            return this.rows.length;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        private Element[] getRows() {
            ArrayList<Element> rowList = new ArrayList<Element>();
            if (this.rows == null) {
                Element trEl = TabledataTabularData.firstSibling("TR", this.tabledataEl.getFirstChild());
                while (trEl != null) {
                    rowList.add(trEl);
                    trEl = TabledataTabularData.firstSibling("TR", trEl.getNextSibling());
                }
                this.rows = rowList.toArray(new Element[0]);
            }
            return this.rows;
        }

        @Override
        public Object[] getRow(long irow) {
            return this.getRowFromTr(this.getRows()[(int)irow]);
        }

        @Override
        public Object getCell(long irow, int icol) {
            Element trEl = this.getRows()[(int)irow];
            int jcol = 0;
            Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
            while (tdEl != null && icol < this.ncol) {
                if (jcol == icol) {
                    String txt = DOMUtils.getTextContent(tdEl);
                    if (txt != null && txt.length() > 0) {
                        return this.decoders[icol].decodeString(txt);
                    }
                    return null;
                }
                ++jcol;
                tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
            }
            return null;
        }

        @Override
        public RowSequence getRowSequence() {
            return new RowSequence(){
                Element trEl;
                boolean done;

                @Override
                public boolean next() {
                    if (this.done) {
                        return false;
                    }
                    Node prev = this.trEl == null ? tabledataEl.getFirstChild() : this.trEl.getNextSibling();
                    this.trEl = TabledataTabularData.firstSibling("TR", prev);
                    if (this.trEl == null) {
                        this.done = true;
                    }
                    return !this.done;
                }

                @Override
                public Object[] getRow() {
                    if (this.trEl == null || this.done) {
                        throw new IllegalStateException();
                    }
                    return this.getRowFromTr(this.trEl);
                }

                @Override
                public Object getCell(int icol) {
                    if (this.trEl == null || this.done) {
                        throw new IllegalStateException();
                    }
                    Element tdEl = TabledataTabularData.firstSibling("TD", this.trEl.getFirstChild());
                    while (icol-- > 0) {
                        tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
                    }
                    if (tdEl == null) {
                        return null;
                    }
                    String txt = DOMUtils.getTextContent(tdEl);
                    return txt == null || txt.length() == 0 ? null : decoders[icol].decodeString(txt);
                }

                @Override
                public void close() {
                    this.trEl = null;
                }
            };
        }

        @Override
        public RowAccess getRowAccess() {
            return new RowAccess(){
                long irow_ = -1L;
                Element trEl_;

                @Override
                public void setRowIndex(long irow) {
                    if (irow != this.irow_) {
                        this.irow_ = irow;
                        this.trEl_ = null;
                    }
                }

                @Override
                public Object getCell(int icol) {
                    Element trEl = this.getRowElement();
                    int jcol = 0;
                    Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
                    while (tdEl != null && icol < ncol) {
                        if (jcol == icol) {
                            String txt = DOMUtils.getTextContent(tdEl);
                            if (txt != null && txt.length() > 0) {
                                return decoders[icol].decodeString(txt);
                            }
                            return null;
                        }
                        ++jcol;
                        tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
                    }
                    return null;
                }

                @Override
                public Object[] getRow() {
                    return this.getRowFromTr(this.getRowElement());
                }

                @Override
                public void close() {
                }

                private Element getRowElement() {
                    if (this.trEl_ == null) {
                        this.trEl_ = this.getRows()[(int)this.irow_];
                    }
                    return this.trEl_;
                }
            };
        }

        @Override
        public void close() {
        }

        private Object[] getRowFromTr(Element trEl) {
            Object[] row = new Object[this.ncol];
            Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
            for (int icol = 0; tdEl != null && icol < this.ncol; ++icol) {
                String txt = DOMUtils.getTextContent(tdEl);
                if (txt != null && txt.length() > 0) {
                    row[icol] = this.decoders[icol].decodeString(txt);
                }
                tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
            }
            return row;
        }

        private static Element firstSibling(String tag, Node node) {
            if (node == null) {
                return null;
            }
            if (node instanceof Element && TableBodies.getVOTagName((Element)node).equals(tag)) {
                return (Element)node;
            }
            return TabledataTabularData.firstSibling(tag, node.getNextSibling());
        }
    }

    static class HrefBinaryTabularData
    extends SequentialTabularData {
        private final Decoder[] decoders;
        private final URL url;
        private final String encoding;
        private final boolean isBinary2;
        private final ContentCoding coding;

        public HrefBinaryTabularData(Decoder[] decoders, URL url, String encoding, boolean isBinary2) {
            super(TableBodies.getClasses(decoders));
            this.decoders = decoders;
            this.url = url;
            this.encoding = encoding;
            this.isBinary2 = isBinary2;
            this.coding = ContentCoding.GZIP;
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            BufferedInputStream istrm = new BufferedInputStream(this.coding.openStreamAuth(this.url, AuthManager.getInstance()));
            return new BinaryRowSequence(this.decoders, istrm, this.encoding, this.isBinary2);
        }

        @Override
        public void close() {
        }
    }

    static class StarTableTabularData
    implements TabularData {
        private final StarTable startab;

        public StarTableTabularData(StarTable startab) {
            this.startab = startab;
        }

        @Override
        public int getColumnCount() {
            return this.startab.getColumnCount();
        }

        @Override
        public long getRowCount() {
            return this.startab.getRowCount();
        }

        @Override
        public Class<?> getContentClass(int icol) {
            return this.startab.getColumnInfo(icol).getContentClass();
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            return this.startab.getRowSequence();
        }

        @Override
        public boolean isRandom() {
            return this.startab.isRandom();
        }

        @Override
        public RowAccess getRowAccess() throws IOException {
            return this.startab.getRowAccess();
        }

        @Override
        public Object getCell(long irow, int icol) throws IOException {
            return this.startab.getCell(irow, icol);
        }

        @Override
        public Object[] getRow(long irow) throws IOException {
            return this.startab.getRow(irow);
        }

        @Override
        public void close() throws IOException {
            this.startab.close();
        }
    }

    static class EmptyTabularData
    extends SequentialTabularData {
        public EmptyTabularData(Class<?>[] classes) {
            super(classes);
        }

        @Override
        public long getRowCount() {
            return 0L;
        }

        @Override
        public RowSequence getRowSequence() {
            return EmptyRowSequence.getInstance();
        }

        @Override
        public void close() {
        }
    }

    static abstract class SequentialTabularData
    implements TabularData {
        final int ncol;
        final Class<?>[] classes;

        public SequentialTabularData(Class<?>[] classes) {
            this.classes = classes;
            this.ncol = classes.length;
        }

        @Override
        public int getColumnCount() {
            return this.ncol;
        }

        @Override
        public long getRowCount() {
            return -1L;
        }

        @Override
        public Class<?> getContentClass(int icol) {
            return this.classes[icol];
        }

        @Override
        public abstract RowSequence getRowSequence() throws IOException;

        @Override
        public boolean isRandom() {
            return false;
        }

        @Override
        public RowAccess getRowAccess() {
            throw new UnsupportedOperationException("Not random");
        }

        @Override
        public Object getCell(long irow, int icol) {
            throw new UnsupportedOperationException("Not random");
        }

        @Override
        public Object[] getRow(long irow) {
            throw new UnsupportedOperationException("Not random");
        }

        @Override
        public void close() {
        }
    }
}

