/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import uk.ac.starlink.plastic.ApplicationItem;

class ApplicationListModel
extends AbstractListModel {
    private List appList_;
    private Map nameMap_;

    public ApplicationListModel() {
        this(null);
    }

    public ApplicationListModel(ApplicationItem[] items) {
        this.setItems(items);
    }

    public void setItems(ApplicationItem[] items) {
        this.nameMap_ = new HashMap();
        this.appList_ = items == null ? new ArrayList() : new ArrayList<ApplicationItem>(Arrays.asList(items));
        Iterator it = this.appList_.iterator();
        while (it.hasNext()) {
            this.retag((ApplicationItem)it.next());
        }
        this.fireContentsChanged(this, -1, -1);
    }

    public void register(URI id, String name, List supportedMessages) {
        final ApplicationItem item = new ApplicationItem(id, name, supportedMessages);
        this.retag(item);
        if (!this.appList_.contains(item)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ApplicationListModel.this.appList_.contains(item)) {
                        ApplicationListModel.this.appList_.add(item);
                        int index = ApplicationListModel.this.appList_.size() - 1;
                        ApplicationListModel.this.fireIntervalAdded(this, index, index);
                    }
                }
            });
        }
    }

    public void unregister(final URI id) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int nItem = ApplicationListModel.this.appList_.size();
                for (int i = 0; i < nItem; ++i) {
                    ApplicationItem item = (ApplicationItem)ApplicationListModel.this.appList_.get(i);
                    if (!id.equals(item.getId())) continue;
                    ApplicationListModel.this.appList_.remove(item);
                    ApplicationListModel.this.fireIntervalRemoved(this, i, i);
                    return;
                }
            }
        });
    }

    public void clear() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ApplicationListModel.this.appList_.isEmpty()) {
                    int nItem = ApplicationListModel.this.appList_.size();
                    ApplicationListModel.this.appList_.clear();
                    ApplicationListModel.this.fireIntervalRemoved(this, 0, nItem - 1);
                }
            }
        });
    }

    @Override
    public Object getElementAt(int index) {
        return (ApplicationItem)this.appList_.get(index);
    }

    @Override
    public int getSize() {
        return this.appList_.size();
    }

    private void retag(ApplicationItem item) {
        List nameIdList;
        int index;
        String name = item.getName();
        URI id = item.getId();
        if (!this.nameMap_.containsKey(name)) {
            this.nameMap_.put(name, new ArrayList());
        }
        if ((index = (nameIdList = (List)this.nameMap_.get(name)).indexOf(id)) < 0) {
            index = nameIdList.size();
            nameIdList.add(id);
        }
        item.setTag(index == 0 ? name : name + "-" + index);
    }
}

