/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import uk.ac.starlink.astrogrid.AcrConnection;
import uk.ac.starlink.connect.AuthKey;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;

public class AcrConnector
implements Connector {
    public static final String CACHE_PROPERTY = "myspace.cache";
    private static Icon icon_;
    private static final Logger logger_;

    @Override
    public String getName() {
        return "MySpace";
    }

    @Override
    public AuthKey[] getKeys() {
        return new AuthKey[0];
    }

    @Override
    public Icon getIcon() {
        URL url;
        if (icon_ == null && (url = this.getClass().getResource("AGlogo.gif")) != null) {
            icon_ = new ImageIcon(url);
        }
        return icon_;
    }

    public Connection logIn(Map authValues) throws IOException {
        return this.logIn();
    }

    public Connection logIn() throws IOException {
        AcrConnection connection = new AcrConnection(this);
        boolean cache = AcrConnector.getCacheDirectories();
        if (cache) {
            logger_.warning("Caching MySpace directories - better performance but may give out of date information");
        }
        connection.setCacheDirectories(cache);
        return connection;
    }

    public static boolean getCacheDirectories() {
        try {
            return Boolean.valueOf(System.getProperty(CACHE_PROPERTY));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        AcrConnection conn = (AcrConnection)new AcrConnector().logIn((Map)new HashMap());
        Object[] acrArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, acrArgs, 0, args.length - 1);
        Object result = conn.execute(args[0], acrArgs);
        if (result instanceof Object[]) {
            Object[] results = (Object[])result;
            for (int i = 0; i < results.length; ++i) {
                Object res = results[i];
                System.out.print("   " + (i + 1) + ": " + res);
                if (res != null) {
                    System.out.print("  (" + res.getClass().getName() + ")");
                }
                System.out.println();
            }
        } else {
            System.out.print("   " + result);
            if (result != null) {
                System.out.print("  (" + result.getClass().getName() + ")");
            }
            System.out.println();
        }
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.astrogrid");
    }
}

