/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.starlink.tfcat.Bbox;
import uk.ac.starlink.tfcat.Crs;
import uk.ac.starlink.tfcat.Datatype;
import uk.ac.starlink.tfcat.Decoder;
import uk.ac.starlink.tfcat.Feature;
import uk.ac.starlink.tfcat.FeatureCollection;
import uk.ac.starlink.tfcat.Field;
import uk.ac.starlink.tfcat.Geometry;
import uk.ac.starlink.tfcat.JsonTool;
import uk.ac.starlink.tfcat.LinearRing;
import uk.ac.starlink.tfcat.LocalCrs;
import uk.ac.starlink.tfcat.Position;
import uk.ac.starlink.tfcat.Reporter;
import uk.ac.starlink.tfcat.SpectralCoords;
import uk.ac.starlink.tfcat.TfcatObject;
import uk.ac.starlink.tfcat.TfcatUtil;
import uk.ac.starlink.tfcat.TimeCoords;

public abstract class Decoders {
    public static final boolean ALLOW_FCG_PROPERTIES = true;
    public static final Decoder<Position> POSITION = (reporter, json, parent) -> {
        double[] pair = new JsonTool(reporter).asNumericArray(json, 2);
        return pair == null ? null : new Position(pair[0], pair[1]);
    };
    public static final Decoder<Position[]> POSITIONS = Decoders.createArrayDecoder(POSITION, Position.class);
    public static final Decoder<Position[]> LINE_STRING = (reporter, json, parent) -> {
        Position[] positions = POSITIONS.decode(reporter, json, null);
        if (positions == null) {
            return null;
        }
        int np = positions.length;
        if (np < 2) {
            reporter.report("Too few positions (" + np + "<2)");
            return null;
        }
        return positions;
    };
    public static final Decoder<Position[][]> LINE_STRINGS = Decoders.createArrayDecoder(LINE_STRING, Position[].class);
    public static final Decoder<LinearRing> LINEAR_RING = (reporter, json, parent) -> {
        Position[] allPositions = POSITIONS.decode(reporter, json, null);
        if (allPositions == null) {
            return null;
        }
        int np1 = allPositions.length;
        if (np1 < 4) {
            reporter.report("too few positions for linear ring (" + np1 + "<4)");
            return null;
        }
        if (!allPositions[0].equals(allPositions[np1 - 1])) {
            reporter.report("first and last positions not identical for linear ring");
            return null;
        }
        Position[] distinctPositions = new Position[np1 - 1];
        System.arraycopy(allPositions, 0, distinctPositions, 0, np1 - 1);
        return new LinearRing(distinctPositions);
    };
    public static final Decoder<LinearRing[]> LINEAR_RINGS = Decoders.createArrayDecoder(LINEAR_RING, LinearRing.class);
    public static final Decoder<LinearRing[]> POLYGON = (reporter, json, parent) -> {
        LinearRing[] rings = LINEAR_RINGS.decode(reporter, json, null);
        if (rings != null && rings.length > 0) {
            if (rings[0].isClockwise()) {
                reporter.report("first (exterior) linear ring is not anticlockwise");
            }
            for (int ir = 1; ir < rings.length; ++ir) {
                if (rings[ir].isClockwise()) continue;
                reporter.report("interior linear ring #" + ir + " is not clockwise");
            }
        }
        return rings;
    };
    public static final Decoder<LinearRing[][]> POLYGONS = Decoders.createArrayDecoder(POLYGON, LinearRing[].class);
    public static final Decoder<Bbox> BBOX = (reporter, json, parent) -> {
        double[] bounds = new JsonTool(reporter).asNumericArray(json, 4);
        if (bounds == null) {
            return null;
        }
        if (bounds[0] <= bounds[2] && bounds[1] <= bounds[3]) {
            return new Bbox(bounds[0], bounds[1], bounds[2], bounds[3]);
        }
        reporter.report("bbox bounds out of sequence: " + Arrays.toString(bounds));
        return null;
    };
    public static final Decoder<Datatype<?>> DATATYPE = (reporter, json, parent) -> {
        String txt = new JsonTool(reporter).asString(json, false);
        if (txt == null) {
            reporter.report("no declared datatype, treat as string");
            return Datatype.STRING;
        }
        Datatype<?> datatype = Datatype.forName(txt);
        if (datatype == null) {
            reporter.report("Unknown datatype \"" + txt + "\", treat as string");
            return Datatype.STRING;
        }
        return datatype;
    };
    public static final Decoder<Field[]> FIELDS = (reporter, json, parent) -> {
        ArrayList<1> fieldList = new ArrayList<1>();
        JSONObject jobj = new JsonTool(reporter).asJSONObject(json);
        if (jobj != null) {
            for (final String key : jobj.keySet()) {
                Reporter fieldReporter = reporter.createReporter(key);
                JSONObject fieldObj = new JsonTool(fieldReporter).asJSONObject(jobj.get(key));
                if (fieldObj == null) continue;
                final String info = new JsonTool(fieldReporter.createReporter("info")).asString(fieldObj.opt("info"), true);
                final String ucd = new JsonTool(fieldReporter.createReporter("ucd")).asString(fieldObj.opt("ucd"), true);
                final String unit = new JsonTool(fieldReporter.createReporter("unit")).asString(fieldObj.opt("unit"), false);
                reporter.checkUcd(ucd);
                reporter.checkUnit(unit);
                final Datatype<?> datatype = DATATYPE.decode(fieldReporter.createReporter("datatype"), fieldObj.opt("datatype"), null);
                fieldList.add(new Field(){

                    @Override
                    public String getName() {
                        return key;
                    }

                    @Override
                    public String getInfo() {
                        return info;
                    }

                    @Override
                    public String getUcd() {
                        return ucd;
                    }

                    @Override
                    public String getUnit() {
                        return unit;
                    }

                    @Override
                    public Datatype<?> getDatatype() {
                        return datatype;
                    }
                });
            }
        }
        return fieldList.toArray(new Field[0]);
    };
    public static final Decoder<Geometry<?>> GEOMETRY = (reporter, json, parent) -> {
        Bbox bbox;
        JsonTool jtool = new JsonTool(reporter);
        JSONObject jobj = jtool.asJSONObject(json);
        if (jobj == null) {
            return null;
        }
        String type = new JsonTool(reporter.createReporter("type")).asString(jobj.opt("type"), true);
        Object crsJson = jobj.opt("crs");
        Crs crs = crsJson == null ? null : CRS.decode(reporter.createReporter("crs"), crsJson, null);
        Object bboxJson = jobj.opt("bbox");
        Bbox bbox2 = bbox = bboxJson == null ? null : BBOX.decode(reporter.createReporter("bbox"), bboxJson, null);
        if (type == null) {
            return null;
        }
        Map<String, ShapeType<?>> shapeTypes = Decoders.getShapeTypes();
        TfcatUtil.checkOption(reporter.createReporter("type"), type, shapeTypes.keySet());
        ShapeType<?> shapeType = shapeTypes.get(type);
        if (shapeType == null) {
            return null;
        }
        jtool.requireAbsent(jobj, "geometry");
        jtool.requireAbsent(jobj, "features");
        Geometry<?> geom = shapeType.createGeometry(reporter.createReporter(type), jobj, crs, bbox);
        if (geom != null) {
            geom.setParent(parent);
        }
        return geom;
    };
    public static final Decoder<Geometry<?>[]> GEOMETRIES = (reporter, json, parent) -> {
        Reporter geomsReporter;
        JSONArray jarray;
        ArrayList geomList = new ArrayList();
        JSONObject jobj = new JsonTool(reporter).asJSONObject(json);
        if (jobj != null && (jarray = new JsonTool(geomsReporter = reporter.createReporter("geometries")).asJSONArray(jobj.opt("geometries"))) != null) {
            for (int ig = 0; ig < jarray.length(); ++ig) {
                Geometry<?> geom = GEOMETRY.decode(geomsReporter.createReporter(ig), jarray.get(ig), parent);
                if (geom == null) continue;
                geomList.add(geom);
            }
        }
        return geomList.toArray(new Geometry[0]);
    };
    public static final Decoder<TimeCoords> TIME_COORDS = (reporter, json, parent) -> {
        Reporter tsReporter;
        String timeScale;
        if (json == null) {
            return null;
        }
        JSONObject jobj = new JsonTool(reporter).asJSONObject(json);
        final String name = new JsonTool(reporter.createReporter("name")).asString(jobj.opt("name"), false);
        final String unit = new JsonTool(reporter.createReporter("unit")).asString(jobj.opt("unit"), true);
        reporter.checkUnit(unit);
        Reporter toReporter = reporter.createReporter("time_origin");
        final String timeOrigin = new JsonTool(toReporter).asString(jobj.opt("time_origin"), true);
        if (timeOrigin != null && !TimeCoords.TIME_ORIGIN_REGEX.matcher(timeOrigin).matches()) {
            toReporter.report("not ISO-8601: \"" + timeOrigin + "\"");
        }
        if ((timeScale = new JsonTool(tsReporter = reporter.createReporter("time_scale")).asString(jobj.opt("time_scale"), true)) != null) {
            TfcatUtil.checkOption(tsReporter, timeScale, TimeCoords.TIME_SCALES);
        }
        return new TimeCoords(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getUnit() {
                return unit;
            }

            @Override
            public String getTimeOrigin() {
                return timeOrigin;
            }

            @Override
            public String getTimeScale() {
                return timeScale;
            }
        };
    };
    public static final Decoder<SpectralCoords> SPECTRAL_COORDS = (reporter, json, parent) -> {
        JSONObject jobj = new JsonTool(reporter).asJSONObject(json);
        if (jobj == null) {
            return null;
        }
        Reporter typeReporter = reporter.createReporter("type");
        final String type = new JsonTool(typeReporter).asString(jobj.opt("type"), true);
        if (type != null) {
            TfcatUtil.checkOption(typeReporter, type, SpectralCoords.TYPE_VALUES);
        }
        Reporter unitReporter = reporter.createReporter("unit");
        final String unit = new JsonTool(unitReporter).asString(jobj.opt("unit"), true);
        unitReporter.checkUnit(unit);
        Reporter scaleReporter = reporter.createReporter("scale");
        final String scale = new JsonTool(scaleReporter).asString(jobj.opt("scale"), false);
        if (scale != null) {
            TfcatUtil.checkOption(scaleReporter, scale, SpectralCoords.SCALE_VALUES);
        }
        return new SpectralCoords(){

            @Override
            public String getType() {
                return type;
            }

            @Override
            public String getUnit() {
                return unit;
            }

            @Override
            public String getScale() {
                return scale;
            }
        };
    };
    public static final Decoder<Crs> CRS = (reporter, json, parent) -> {
        TimeCoords timeCoords;
        JSONObject jobj = new JsonTool(reporter).asJSONObject(json);
        if (jobj == null) {
            return null;
        }
        Reporter typeReporter = reporter.createReporter("type");
        final String crsType = new JsonTool(typeReporter).asString(jobj.opt("type"), true);
        if (crsType == null) {
            return null;
        }
        if (!"local".equals(crsType)) {
            typeReporter.report("Unsupported CRS type \"" + crsType + "\"");
            return new Crs(){

                @Override
                public String getCrsType() {
                    return crsType;
                }
            };
        }
        Reporter propsReporter = reporter.createReporter("properties");
        JSONObject crsProps = new JsonTool(propsReporter).asJSONObject(jobj.opt("properties"));
        if (crsProps == null) {
            return null;
        }
        final String timeCoordsId = new JsonTool(propsReporter.createReporter("time_coords_id")).asString(crsProps.opt("time_coords_id"), false);
        Object timeCoordsObj = crsProps.opt("time_coords");
        TimeCoords timeCoordsDef = TIME_COORDS.decode(propsReporter.createReporter("time_coords"), crsProps.opt("time_coords"), null);
        if (timeCoordsDef != null) {
            timeCoords = timeCoordsDef;
            if (timeCoordsId != null) {
                propsReporter.report("time_coords_id unused since time_coords supplied");
            }
        } else if (timeCoordsId != null) {
            TfcatUtil.checkOption(reporter.createReporter("time_coords_id"), timeCoordsId, TimeCoords.PREDEF_MAP.keySet());
            timeCoords = TimeCoords.PREDEF_MAP.get(timeCoordsId);
        } else {
            propsReporter.report("Neither time_coords nor time_coords_id supplied");
            timeCoords = null;
        }
        final SpectralCoords spectralCoords = SPECTRAL_COORDS.decode(propsReporter.createReporter("spectral_coords"), crsProps.opt("spectral_coords"), null);
        final String refPositionId = new JsonTool(propsReporter.createReporter("ref_position_id")).asString(crsProps.opt("ref_position_id"), true);
        return new LocalCrs(){

            @Override
            public String getCrsType() {
                return "local";
            }

            @Override
            public String getTimeCoordsId() {
                return timeCoordsId;
            }

            @Override
            public TimeCoords getTimeCoords() {
                return timeCoords;
            }

            @Override
            public SpectralCoords getSpectralCoords() {
                return spectralCoords;
            }

            @Override
            public String getRefPositionId() {
                return refPositionId;
            }
        };
    };
    public static final Decoder<Feature> FEATURE = (reporter, json, parent) -> {
        JsonTool jtool = new JsonTool(reporter);
        JSONObject jobj = jtool.asJSONObject(json);
        if (jobj == null) {
            return null;
        }
        String type = new JsonTool(reporter.createReporter("type")).asString(jobj.opt("type"), true);
        if (type == null) {
            return null;
        }
        if (type.equals("Feature")) {
            Geometry<?> geometry = GEOMETRY.decode(reporter.createReporter("geometry"), jobj.opt("geometry"), null);
            if (geometry == null) {
                return null;
            }
            Object crsJson = jobj.opt("crs");
            Crs crs = crsJson == null ? null : CRS.decode(reporter.createReporter("crs"), crsJson, null);
            Object bboxJson = jobj.opt("bbox");
            Bbox bbox = bboxJson == null ? null : BBOX.decode(reporter.createReporter("bbox"), bboxJson, null);
            String id = new JsonTool(reporter.createReporter("id")).asStringOrNumber(jobj.opt("id"), false);
            Object propsJson = jobj.opt("properties");
            JSONObject properties = propsJson == null ? null : new JsonTool(reporter.createReporter("properties")).asJSONObject(propsJson);
            jtool.requireAbsent(jobj, "features");
            Feature feat = new Feature(jobj, crs, bbox, geometry, id, properties);
            feat.setParent(parent);
            assert (feat.getGeometry().getParent() == feat);
            return feat;
        }
        reporter.report("type is \"" + type + "\" not \"Feature\"");
        return null;
    };
    public static final Decoder<FeatureCollection> FEATURE_COLLECTION = (reporter, json, parent) -> {
        JsonTool jtool = new JsonTool(reporter);
        JSONObject jobj = jtool.asJSONObject(json);
        if (jobj == null) {
            return null;
        }
        String type = new JsonTool(reporter.createReporter("type")).asString(jobj.opt("type"), true);
        if (type == null) {
            return null;
        }
        if (type.equals("FeatureCollection")) {
            jtool.requireAbsent(jobj, "geometry");
            Field[] fields = FIELDS.decode(reporter.createReporter("fields"), jobj.opt("fields"), null);
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            for (Field field : fields) {
                fieldMap.put(field.getName(), field);
            }
            Reporter featsReporter = reporter.createReporter("features");
            Feature[] features = Decoders.createArrayDecoder(FEATURE, Feature.class).decode(featsReporter, jobj.opt("features"), null);
            if (features == null) {
                return null;
            }
            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                Feature feat = features[ifeat];
                Reporter featReporter = featsReporter.createReporter(ifeat);
                JSONObject props = feat.getProperties();
                if (props == null) continue;
                Reporter propsReporter = featReporter.createReporter("properties");
                Decoders.checkProperties(propsReporter, props, fieldMap);
            }
            Object bboxJson = jobj.opt("bbox");
            Bbox bbox = bboxJson == null ? null : BBOX.decode(reporter.createReporter("bbox"), bboxJson, null);
            Crs crs = CRS.decode(reporter.createReporter("crs"), jobj.opt("crs"), null);
            FeatureCollection fc = new FeatureCollection(jobj, crs, bbox, fieldMap, features);
            fc.setParent(parent);
            for (Feature f : fc.getFeatures()) {
                assert (f.getParent() == fc);
            }
            return fc;
        }
        reporter.report("type is \"" + type + "\" not \"FeatureCollection\"");
        return null;
    };
    private static final Map<String, ShapeType<?>> shapeTypes_ = Decoders.createShapeTypes();
    private static final Map<String, Decoder<? extends TfcatObject>> tfcatDecoders_ = Decoders.createTfcatDecoders();
    public static final Decoder<TfcatObject> TFCAT = (reporter, json, parent) -> {
        JsonTool jtool = new JsonTool(reporter);
        JSONObject jobj = jtool.asJSONObject(json);
        if (jobj == null) {
            return null;
        }
        Reporter typeReporter = reporter.createReporter("type");
        String type = new JsonTool(typeReporter).asString(jobj.opt("type"), true);
        if (type == null) {
            return null;
        }
        TfcatUtil.checkOption(typeReporter, type, tfcatDecoders_.keySet());
        Decoder<? extends TfcatObject> decoder = tfcatDecoders_.get(type);
        return decoder == null ? null : decoder.decode(reporter.createReporter(type), jobj, parent);
    };

    private Decoders() {
    }

    private static void checkProperties(Reporter reporter, JSONObject properties, Map<String, Field> fields) {
        for (String key : properties.keySet()) {
            Datatype<?> datatype;
            Field field = fields.get(key);
            Reporter propReporter = reporter.createReporter(key);
            if (field == null) {
                propReporter.report("no corresponding field for property");
                continue;
            }
            Object value = properties.get(key);
            if (JsonTool.isNull(value) || !(value instanceof Number) && !(value instanceof String) || (datatype = field.getDatatype()).isType(value.toString())) continue;
            propReporter.report("bad " + datatype + " syntax \"" + value + "\"");
        }
    }

    private static Map<String, ShapeType<?>> createShapeTypes() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("Point", new ShapeType<Position>(POSITION, Geometry.Point::new));
        map.put("MultiPoint", new ShapeType<Position[]>(POSITIONS, Geometry.MultiPoint::new));
        map.put("LineString", new ShapeType<Position[]>(LINE_STRING, Geometry.LineString::new));
        map.put("MultiLineString", new ShapeType<Position[][]>(LINE_STRINGS, Geometry.MultiLineString::new));
        map.put("Polygon", new ShapeType<LinearRing[]>(POLYGON, Geometry.Polygon::new));
        map.put("MultiPolygon", new ShapeType<LinearRing[][]>(POLYGONS, Geometry.MultiPolygon::new));
        map.put("GeometryCollection", new ShapeType<Geometry[]>(GEOMETRIES, Geometry.GeometryCollection::new));
        return map;
    }

    private static Map<String, Decoder<? extends TfcatObject>> createTfcatDecoders() {
        LinkedHashMap<String, Decoder<? extends TfcatObject>> map = new LinkedHashMap<String, Decoder<? extends TfcatObject>>();
        map.put("Feature", FEATURE);
        map.put("FeatureCollection", FEATURE_COLLECTION);
        for (String geomType : shapeTypes_.keySet()) {
            map.put(geomType, GEOMETRY);
        }
        return map;
    }

    private static <T> Decoder<T[]> createArrayDecoder(Decoder<T> scalarDecoder, Class<T> scalarClazz) {
        return (reporter, json, parent) -> {
            JSONArray jarray = new JsonTool(reporter).asJSONArray(json);
            if (jarray == null) {
                return null;
            }
            int n = jarray.length();
            Object[] array = (Object[])Array.newInstance(scalarClazz, n);
            for (int i = 0; i < n; ++i) {
                Object item = scalarDecoder.decode(reporter.createReporter(i), jarray.get(i), parent);
                if (item == null) {
                    return null;
                }
                array[i] = item;
            }
            return array;
        };
    }

    private static Map<String, ShapeType<?>> getShapeTypes() {
        return shapeTypes_;
    }

    private static class ShapeType<S> {
        private final Decoder<S> shapeDecoder_;
        private final GeomConstructor<S> geomConstructor_;

        ShapeType(Decoder<S> shapeDecoder, GeomConstructor<S> geomConstructor) {
            this.shapeDecoder_ = shapeDecoder;
            this.geomConstructor_ = geomConstructor;
        }

        Geometry<S> createGeometry(Reporter reporter, JSONObject json, Crs crs, Bbox bbox) {
            Reporter contentReporter;
            Object content;
            if (this.shapeDecoder_ == GEOMETRIES) {
                content = json;
                contentReporter = reporter;
            } else {
                content = json.opt("coordinates");
                if (content == null) {
                    reporter.report("no coordinates");
                    return null;
                }
                contentReporter = reporter.createReporter("coordinates");
            }
            S shape = this.shapeDecoder_.decode(contentReporter, content, null);
            return shape == null ? null : this.geomConstructor_.toGeom(json, crs, bbox, shape);
        }
    }

    @FunctionalInterface
    private static interface GeomConstructor<S> {
        public Geometry<S> toGeom(JSONObject var1, Crs var2, Bbox var3, S var4);
    }
}

