/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class TimeCoords {
    public static final Collection<String> TIME_SCALES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("GPS", "TAI", "TCB", "TCG", "TDB", "TT", "UT", "UTC", "UNKNOWN", "SCET", "SCLK")));
    public static final Pattern TIME_ORIGIN_REGEX = Pattern.compile("(-?[0-9]+)-([0-9]{2})-([0-9]{2})(?:T([0-9]{2})(?::([0-9]{2})(?::([0-9]{2}(?:\\.[0-9]*)?))?)?)?");
    public static final TimeCoords UNIX = TimeCoords.createTimeCoords("unix", "Unix Timestamp", "1970-01-01T00:00:00", "s", "UTC");
    public static final TimeCoords JD;
    public static final TimeCoords MJD;
    public static final TimeCoords MJD_NASA;
    public static final TimeCoords MJD_CNES;
    public static final TimeCoords CDF_TT2000;
    public static final Map<String, TimeCoords> PREDEF_MAP;

    public abstract String getName();

    public abstract String getUnit();

    public abstract String getTimeOrigin();

    public abstract String getTimeScale();

    private static TimeCoords createTimeCoords(final String id, final String description, final String origin, final String unit, final String scale) {
        boolean ok;
        boolean bl = ok = id != null && id.trim().length() > 0 && description != null && description.trim().length() > 0 && TIME_ORIGIN_REGEX.matcher(origin).matches() && ("d".equals(unit) || "s".equals(unit) || "ns".equals(unit));
        if (!ok) {
            throw new AssertionError((Object)("Bad predefined TimeCoords: " + id));
        }
        return new TimeCoords(){

            @Override
            public String getName() {
                return description;
            }

            @Override
            public String getUnit() {
                return unit;
            }

            @Override
            public String getTimeOrigin() {
                return origin;
            }

            @Override
            public String getTimeScale() {
                return scale;
            }

            public String toString() {
                return id;
            }
        };
    }

    static {
        PREDEF_MAP = Collections.unmodifiableMap(Arrays.asList(UNIX, JD = TimeCoords.createTimeCoords("jd", "Julian Day", "-4712-01-01T12:00:00", "d", "UTC"), MJD = TimeCoords.createTimeCoords("mjd", "Modified Julian Day", "1858-11-17T00:00:00", "d", "UTC"), MJD_NASA = TimeCoords.createTimeCoords("mjd_nasa", "NASA Modified Julian Day", "1968-05-24T00:00:00", "d", "UTC"), MJD_CNES = TimeCoords.createTimeCoords("mjd_cnes", "CNES Modified Julian Day", "1950-01-01T00:00:00", "d", "UTC"), CDF_TT2000 = TimeCoords.createTimeCoords("cdf_tt2000", "CDF Epoch TT2000", "2000-01-01T00:00:00", "ns", "TT")).stream().collect(Collectors.toMap(Object::toString, t -> t, (t1, t2) -> t1, LinkedHashMap::new)));
    }
}

