c
      subroutine conft(r,z1,z2,c,nrz,u,f,nuf)
c
c Subroutine conft: Perform radial FT-based convolution of arrays
c                   z1(i) and z2(i) sampled at points r(i) to array
c                   c(i) sampled at points r(i), using a Bessel 
c                   transform sampled at wavenumbers u(i). The radial
c                   FT f(i) of the convolution is also calculated.
c
c Update history:
c    V1.0  13-Sep-1993  Original version: minimise array access
c    V1.1  16-Sep-1993  r*4 version for speed 
c
      implicit none
c
c Arguments:
c    r(i)  = r*4(nrz) = input radius values
c    z1(i) = r*4(nrz) = input function-1 values
c    z2(i) = r*4(nrz) = input function-2 values
c    c(i)  = r*4(nrz) = output convolution values
c    nrz   = i*4      = input number of radius+function values
c    u(i)  = r*4(nuf) = input wavenumber values
c    f(i)  = r*4(nuf) = output radial FT calculated
c    nuf   = i*4      = input number of wavenumber+fourier values
c
      integer*4 nrz,nuf
      real*4    c(nrz),f(nuf),r(nrz),u(nuf),z1(nrz),z2(nrz)
c
c Subprogrammes:
c    getbj0 = r*4 function = J0 Bessel function
c
      real*4   getbj0
      external getbj0
c
c Local variables:
c    al0  = r*4 = Gaussian quadrature coefficient
c    alm  = r*4 = Gaussian quadrature coefficient (negative side)
c    alp  = r*4 = Gaussian quadrature coefficient (positive side)
c    arg  = r*4 = current calculation wavenumber
c    b0   = r*4 = Bessel-function factor
c    bp   = r*4 = Bessel-function factor (positive side)
c    dm   = r*4 = negative-going delta-radius
c    dp   = r*4 = positive-going delta-radius
c    f10  = r*4 = integrand value
c    f1m  = r*4 = integrand value (negative side)
c    f1p  = r*4 = integrand value (positive side)
c    f20  = r*4 = integrand value
c    f2m  = r*4 = integrand value (negative side)
c    f2p  = r*4 = integrand value (positive side)
c    i1   = i*4 = counting index
c    i2   = i*4 = counting index
c    r0   = r*4 = radius value
c    rm   = r*4 = radius value (negative side)
c    rp   = r*4 = radius value (positive side)
c    sum1 = r*4 = sum so far
c    sum2 = r*4 = sum so far
c
      integer*4 i1,i2
      real*4    al0,alm,alp,arg,b0,bp,dm,dp,
     +          f10,f1m,f1p,f20,f2m,f2p,r0,rm,rp,sum1,sum2
c
c For each desired wavenumber value, get radial FT of each function
c    and store product in f(i)
c
      do i1=1,nuf
c
c Get wavenumber
c
        arg=u(i1)
c
c Initial point
c
        i2=1
c
c Radius values
c
        r0=r(i2  )
        rp=r(i2+1)
c
c First parts of integrand
c
        b0=getbj0(arg*r0)*r0
        bp=getbj0(arg*rp)*rp
c
c Initial integrand-1 values
c
        f10=b0*z1(i2  )
        f1p=bp*z1(i2+1)
        f20=b0*z2(i2  )
        f2p=bp*z2(i2+1)
c
c Initial delta radius
c
        dp=rp-r0
c
c Initial quadrature coefficients
c          
        al0=0.5
        alp=0.5
c
c Initial contribution to sum
c
        sum1=(al0*f10+alp*f1p)*dp
        sum2=(al0*f20+alp*f2p)*dp
c
c Loop over other entries in function table
c
        do i2=2,nrz-1
c
c Get local radius values
c
          rm=r0
          r0=rp
          rp=r(i2+1)
c
c Get new bessel function bit
c
          bp=getbj0(arg*rp)*rp
c
c Get local values of integrand
c
          f1m=f10
          f10=f1p
          f1p=bp*z1(i2+1)
          f2m=f20
          f20=f2p
          f2p=bp*z2(i2+1)
c
c Get local changes in radius
c
          dm=dp
          dp=rp-r0
c
c Get gaussian quadrature coefficients for uneven sampling
c    (or even sampling: special case)
c
          alm=-(    dp**2    )/(6.0*(dm+dp)*dm)
          al0= (    dp+3.0*dm)/(6.0*dm        )
          alp= (2.0*dp+3.0*dm)/(6.0*(dm+dp)   )
c
c Combine results to sum, accurate to third order
c
          sum1=sum1+dp*(alm*f1m+al0*f10+alp*f1p)
          sum2=sum2+dp*(alm*f2m+al0*f20+alp*f2p)
c
        enddo
c
c Store product of results in FT array
c
        f(i1)=sum1*sum2
c
      enddo
c
c Now back-transform the FT array using the same methods:
c    just swap wavenumber and radius and restrict to one
c    array
c
      do i1=1,nrz
c
c Get wavenumber
c
        arg=r(i1)
c
c Initial point
c
        i2=1
c
c Radius values
c
        r0=u(i2  )
        rp=u(i2+1)
c
c Initial integrand values
c
        f10=getbj0(arg*r0)*r0*f(i2  )
        f1p=getbj0(arg*rp)*rp*f(i2+1)
c
c Initial delta radius
c
        dp=rp-r0
c
c Initial quadrature coefficients
c          
        al0=0.5
        alp=0.5
c
c Initial contribution to sum
c
        sum1=(al0*f10+alp*f1p)*dp
c
c Loop over other entries in function table
c
        do i2=2,nuf-1
c
c Get local radius values
c
          rm=r0
          r0=rp
          rp=u(i2+1)
c
c Get local values of integrand
c
          f1m=f10
          f10=f1p
          f1p=getbj0(arg*rp)*rp*f(i2+1)
c
c Get local changes in radius
c
          dm=dp
          dp=rp-r0
c
c Get gaussian quadrature coefficients for uneven sampling
c    (or even sampling: special case)
c
          alm =-(    dp**2    )/(6.0*(dm+dp)*dm)
          al0 = (    dp+3.0*dm)/(6.0*dm        )
          alp = (2.0*dp+3.0*dm)/(6.0*(dm+dp)   )
c
c Combine results to sum, accurate to third order
c
          sum1=sum1+dp*(alm*f1m+al0*f10+alp*f1p)
c
        enddo
c
c Store result in convolution array
c
        c(i1)=sum1*8.0*atan(1.0)
c
      enddo
c
c All processed, return
c
      return
c
      end
