c
      real*4 function getbj0(x)
c
c Function getbj0: Return value of Bessel function J0(x) using 
c                  asymptotic expansion (from Press et al).
c
c Update history:
c    V1.0  Original version                             31-Dec-1992
c
      IMPLICIT NONE
c
c Arguments:
c    x = r*4 = argument of Bessel function
c
      real*4 x
c
c Local parameters:
c    P1 - P5 = r*8 = coefficients in expansion at large argument
c    Q1 - Q5 = r*8 = coefficients in expansion at large argument
c    R1 - R6 = r*8 = coefficients in expansion at small argument
c    S1 - S6 = r*8 = coefficients in expansion at small argument
c
      real*8 P1,P2,P3,P4,P5
      real*8 Q1,Q2,Q3,Q4,Q5
      real*8 R1,R2,R3,R4,R5,R6
      real*8 S1,S2,S3,S4,S5,S6
      parameter (P1 =  1.0000000000d+00)
      parameter (P2 = -0.1098628627d-02)
      parameter (P3 =  0.2734510407d-04)
      parameter (P4 = -0.2073370639d-05)
      parameter (P5 =  0.2093887211d-06)
      parameter (Q1 = -0.1562499995d-01)
      parameter (Q2 =  0.1430488765d-03)
      parameter (Q3 = -0.6911147651d-05)
      parameter (Q4 =  0.7621095161d-06)
      parameter (Q5 = -0.9349451520d-07)
      parameter (R1 =  5.7568490574d+10)
      parameter (R2 = -1.3362590354d+10)
      parameter (R3 =  6.5161964070d+08)
      parameter (R4 = -1.1214424180d+07)
      parameter (R5 =  7.7392330170d+04)
      parameter (R6 = -1.8490524560d+02)
      parameter (S1 =  5.7568490411d+10)
      parameter (S2 =  1.0295329850d+09)
      parameter (S3 =  9.4946807180d+06)
      parameter (S4 =  5.9272648530d+04)
      parameter (S5 =  2.6785327120d+02)
      parameter (S6 =  1.0000000000d+00)
c
c Local variable:
c    ax = r*4 = absolute value of x
c    xx = r*4 = x - (pi/4)
c    y  = r*8 = argument of series
c    z  = r*4 = (8/ax)
c
      real*8 y
      real*8 ax,xx,z,pi
c
      pi=4.0d0*datan(1.0d0)
c
c Small-argument case is ratio of two series. Large-argument case
c    is standard asymptotic approximation
c
      if (abs(x) .lt. 8.0) then
        y     =x**2
        getbj0=(R1+y*(R2+y*(R3+y*(R4+y*(R5+y*R6)))))/
     +         (S1+y*(S2+y*(S3+y*(S4+y*(S5+y*S6)))))
      else
        ax=dble(abs(x))
        z =8.0d0/ax
        y =z**2
        xx=ax-0.25d0*pi
        getbj0=dsqrt(2.0d0/(pi*ax))*
     +              (dcos(xx)*(P1+y*(P2+y*(P3+y*(P4+y*P5))))
     +            -z*dsin(xx)*(Q1+y*(Q2+y*(Q3+y*(Q4+y*Q5)))))
      endif
c
      return
c
      end
c
