/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.starlink.hapi.HapiVersion;

public interface HapiCapabilities {
    public HapiVersion getHapiVersion();

    public String[] getOutputFormats();

    public static HapiCapabilities fromJson(JSONObject json) {
        final HapiVersion version = HapiVersion.fromText(json.optString("HAPI", null));
        JSONArray formatsArray = json.optJSONArray("outputFormats");
        ArrayList<String> formatList = new ArrayList<String>();
        if (formatsArray != null) {
            for (int i = 0; i < formatsArray.length(); ++i) {
                String fmt = formatsArray.optString(i, null);
                if (fmt == null) continue;
                formatList.add(fmt);
            }
        }
        if (formatList.size() == 0) {
            formatList.add("csv");
        }
        final String[] formats = formatList.toArray(new String[0]);
        return new HapiCapabilities(){

            @Override
            public HapiVersion getHapiVersion() {
                return version;
            }

            @Override
            public String[] getOutputFormats() {
                return (String[])formats.clone();
            }
        };
    }
}

