/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.hapi.HapiCapabilities;
import uk.ac.starlink.hapi.HapiEndpoint;
import uk.ac.starlink.hapi.HapiInfo;
import uk.ac.starlink.hapi.HapiService;
import uk.ac.starlink.hapi.HapiTableReader;
import uk.ac.starlink.hapi.HapiVersion;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableScheme;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.IOConsumer;
import uk.ac.starlink.util.IOSupplier;

public class HapiTableScheme
implements TableScheme,
Documented {
    private final boolean supplyDocExample_;
    private static final String DOC_EXAMPLE = "https://vires.services/hapi;GRACE_A_MAG;start=2009-01-01T00:00:00;stop=2009-01-01T00:00:10;parameters=Latitude,Longitude";
    private static final String CHUNKLIMIT_PARAM = "maxChunk";
    private static final String FAILONLIMIT_PARAM = "failOnLimit";
    private static final int CHUNKLIMIT_DFLT = 1;
    private static final boolean FAILONLIMIT_DFLT = false;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public HapiTableScheme() {
        this.supplyDocExample_ = false;
    }

    @Override
    public String getSchemeName() {
        return "hapi";
    }

    @Override
    public String getSchemeUsage() {
        return "<server-url>;<dataset>;start=<start>;stop=<stop>[;maxChunk=<n>][;failOnLimit=<true|false>][;<key>=<value>...]";
    }

    @Override
    public String getExampleSpecification() {
        return this.supplyDocExample_ ? DOC_EXAMPLE : null;
    }

    @Override
    public String getXmlDescription() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(String.join((CharSequence)"\n", "<p>Generates a table by interacting with a HAPI service.", "HAPI, the", "<a href='http://hapi-server.org/'", "   >Heliophysics Data Application Programmer's Interface</a>", "is a protocol for serving streamed time series data.", "</p>", "<p>In most cases it is not essential to use this scheme,", "since pointing the HAPI table input handler", "at a URL with suitable parameters will be able to read the data,", "but this scheme provides some added value", "by negotiating with the server to make sure that", "the correct version-sensitive request parameter names", "and the most efficient data stream format are used,", "and can split the request into multiple chunks", "if the service rejects the whole query as too large.", "</p>", "<p>The first token in the specification is", "the base URL of the HAPI service,", "the second is the dataset identifier,", "and others, as defined by the HAPI protocol, are supplied as", "<code>&lt;name&gt;=&lt;value&gt;</code> pairs,", "separated by a semicolon (\"<code>;</code>\")", "or an ampersand (\"<code>&amp;</code>\").", "The <code>start</code> and <code>stop</code> parameters,", "giving ISO-8601-like bounds for the interval requested,", "are required.", "</p>", "<p>Additionally, some parameters may be supplied which", "affect load behaviour but are not transmitted to the HAPI", "service.  These are:", "<dl>", "<dt><code>maxChunk=&lt;n&gt;</code></dt>", "<dd><p>divides the request up into at most <code>&lt;n&gt;</code>", "    smaller chunks", "    if the server refuses to supply the whole range at once.", "    </p></dd>", "<dt><code>failOnLimit=&lt;true|false&gt;</code></dt>", "<dd><p>determines what happens if the service does refuse", "    to serve the whole range (in chunks or otherwise);", "    if true, the table load will fail,", "    but if false as many rows as are available will be loaded.", "    </p></dd>", "</dl>", "</p>", "<p>Some variant syntax is permitted;", "an ampersand (\"<code>&amp;</code>\") may be used instead of", "a semicolon to separate tokens,", "and the names \"<code>time.min</code>\" and", "\"<code>time.max</code>\" may be used in place of", "\"<code>start</code>\" and \"<code>stop</code>\".", "</p>", "<p>Note that since semicolons and/or ampersands form part of", "the syntax, and these characters have special meaning", "in some contexts,", "it may be necessary to quote the scheme specification", "on the command line.", "</p>"));
        if (!this.supplyDocExample_) {
            sbuf.append(String.join((CharSequence)"\n", "<p>Example:", "<verbatim><![CDATA[", ":" + this.getSchemeName() + ":" + DOC_EXAMPLE, "+--------------------------+---------------+---------------+", "| Timestamp                | Latitude      | Longitude     |", "+--------------------------+---------------+---------------+", "| 2009-01-01T00:00:03.607Z | -74.136357526 | -78.905620222 |", "| 2009-01-01T00:00:05.607Z | -74.009378676 | -78.884853931 |", "| 2009-01-01T00:00:06.607Z | -73.945887793 | -78.874590667 |", "| 2009-01-01T00:00:07.607Z | -73.882397005 | -78.864406236 |", "| 2009-01-01T00:00:08.607Z | -73.818903534 | -78.854396448 |", "+--------------------------+---------------+---------------+", "]]></verbatim>", "</p>", ""));
        }
        return sbuf.toString();
    }

    @Override
    public StarTable createTable(String specification) throws IOException {
        String[] args = specification.split("[;&]", -1);
        if (args.length < 2) {
            throw new TableFormatException("Must specify server and dataset");
        }
        String server = args[0];
        String dataset = args[1];
        HapiService service = new HapiService(server);
        LinkedHashMap<String, String> extrasMap = new LinkedHashMap<String, String>();
        int chunkLimit = 1;
        boolean failOnLimit = false;
        for (int i = 2; i < args.length; ++i) {
            String arg = args[i];
            int ieq = arg.indexOf("=");
            if (ieq > 0) {
                String key = arg.substring(0, ieq);
                String value = arg.substring(ieq + 1, arg.length());
                if (CHUNKLIMIT_PARAM.equalsIgnoreCase(key)) {
                    try {
                        chunkLimit = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        String msg = "Bad maxChunk value";
                        throw new TableFormatException(msg);
                    }
                }
                if (FAILONLIMIT_PARAM.equalsIgnoreCase(key)) {
                    failOnLimit = Boolean.parseBoolean(value);
                    continue;
                }
                extrasMap.put(arg.substring(0, ieq), arg.substring(ieq + 1, arg.length()));
                continue;
            }
            String msg = "Optional parameter \"" + arg + "\" is not of form <key>=<value>";
            throw new TableFormatException(msg);
        }
        return HapiTableScheme.createHapiTable(service, dataset, extrasMap, chunkLimit, failOnLimit);
    }

    private static StarTable createHapiTable(HapiService service, String dataset, Map<String, String> requestParams, int chunkLimit, boolean failOnLimit) throws IOException {
        String format;
        String paramlist = requestParams.get("parameters");
        HapiCapabilities caps = HapiCapabilities.fromJson(service.readJson(HapiEndpoint.CAPABILITIES));
        HapiVersion version = caps.getHapiVersion();
        String datasetParamName = version.getDatasetRequestParam();
        String startParamName = version.getStartRequestParam();
        String stopParamName = version.getStopRequestParam();
        boolean supportsBinary = Arrays.stream(caps.getOutputFormats()).anyMatch(s -> "binary".equals(s));
        LinkedHashMap<String, String> infoParams = new LinkedHashMap<String, String>();
        infoParams.put(datasetParamName, dataset);
        if (paramlist != null) {
            infoParams.put("parameters", paramlist);
        }
        HapiInfo infoHdr = HapiInfo.fromJson(service.readJson(HapiEndpoint.INFO, infoParams));
        String start = null;
        String stop = null;
        for (HapiVersion v : HapiVersion.getStandardVersions()) {
            if (start == null) {
                start = requestParams.get(v.getStartRequestParam());
            }
            if (stop != null) continue;
            stop = requestParams.get(v.getStopRequestParam());
        }
        if (start == null) {
            start = infoHdr.getMetadata("sampleStartDate");
        }
        if (stop == null) {
            stop = infoHdr.getMetadata("sampleStopDate");
        }
        if (start == null || stop == null) {
            StringBuffer sbuf = new StringBuffer().append("Must supply start/stop; ").append("range is ").append(infoHdr.getMetadata("startDate")).append(" to ").append(infoHdr.getMetadata("stopDate"));
            String cadence = infoHdr.getMetadata("cadence");
            if (cadence != null) {
                sbuf.append(", cadence is ").append(cadence);
            }
            sbuf.append(".");
            throw new TableFormatException(sbuf.toString());
        }
        LinkedHashMap<String, String> dataParams = new LinkedHashMap<String, String>();
        dataParams.put(datasetParamName, dataset);
        dataParams.putAll(requestParams);
        for (HapiVersion v : HapiVersion.getStandardVersions()) {
            dataParams.remove(v.getStartRequestParam());
            dataParams.remove(v.getStopRequestParam());
        }
        dataParams.put(startParamName, start);
        dataParams.put(stopParamName, stop);
        boolean includeHeader = "header".equals(dataParams.get("include"));
        if (dataParams.containsKey("format")) {
            format = (String)dataParams.get("format");
        } else {
            format = supportsBinary ? "binary" : "csv";
            dataParams.put("format", format);
        }
        URL dataUrl = service.createQuery(HapiEndpoint.DATA, dataParams);
        LinkedHashMap<String, String> standaloneDataParams = new LinkedHashMap<String, String>(dataParams);
        standaloneDataParams.put("include", "header");
        URL standaloneUrl = service.createQuery(HapiEndpoint.DATA, standaloneDataParams);
        HapiTableReader rdr = new HapiTableReader(infoHdr.getParameters());
        boolean[] overflowFlag = new boolean[1];
        IOConsumer<String> limitCallback = msg -> {
            overflowFlag[0] = true;
            if (failOnLimit) {
                throw new IOException((String)msg);
            }
            logger_.warning(msg + " - table truncated");
        };
        IOSupplier<RowSequence> rseqSupplier = () -> {
            BufferedInputStream in = new BufferedInputStream(service.openChunkedStream(dataUrl, chunkLimit, limitCallback));
            return includeHeader ? rdr.createRowSequenceUsingHeader(in) : rdr.createRowSequence(in, null, format);
        };
        StarTable table = rdr.createStarTable(rseqSupplier);
        if (overflowFlag[0]) {
            table.setParameter(new DescribedValue(Tables.QUERY_STATUS_INFO, "OVERFLOW"));
        }
        table.setURL(standaloneUrl);
        table.setName(dataset + "-" + start.replaceFirst("T.*", ""));
        return table;
    }
}

