/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.util.URLUtils;

public abstract class ServerMeta {
    private static ServerMeta[] servers_;
    public static final String SERVER_LIST_URL = "https://raw.githubusercontent.com/hapi-server/servers/master/all_.txt";
    private static final Logger logger_;

    public abstract String getUrl();

    public abstract String getName();

    public abstract String getTitle();

    public abstract String getContact();

    public abstract String getEmail();

    public static ServerMeta[] getServers() {
        if (servers_ == null) {
            servers_ = ServerMeta.readServers();
        }
        return (ServerMeta[])servers_.clone();
    }

    private static ServerMeta[] readServers() {
        String[] lines;
        logger_.info("Reading HAPI servers from https://raw.githubusercontent.com/hapi-server/servers/master/all_.txt");
        try (BufferedReader in = new BufferedReader(new InputStreamReader(URLUtils.newURL(SERVER_LIST_URL).openStream()));){
            lines = (String[])in.lines().toArray(String[]::new);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "HAPI server list read failed", e);
            lines = new String[]{"https://cdaweb.gsfc.nasa.gov/hapi", "https://imag-data.bgs.ac.uk/GIN_V1/hapi", "http://hapi-server.org/servers/SSCWeb/hapi", "https://iswa.gsfc.nasa.gov/IswaSystemWebApp/hapi", "http://lasp.colorado.edu/lisird/hapi", "http://hapi-server.org/servers/TestData2.0/hapi", "https://amda.irap.omp.eu/service/hapi", "https://vires.services/hapi", "https://api.helioviewer.org/hapi/Helioviewer/hapi"};
        }
        return ServerMeta.parseServerLines(lines);
    }

    private static ServerMeta[] parseServerLines(String[] lines) {
        ArrayList<1> list = new ArrayList<1>();
        for (String line : lines) {
            boolean urlOk;
            String[] words = line.split(" *, *", -1);
            int nw = words.length;
            if (nw <= 0) continue;
            final String url = words[0];
            try {
                URLUtils.newURL(url);
                urlOk = true;
            }
            catch (MalformedURLException e) {
                urlOk = false;
            }
            if (!urlOk) continue;
            final String name = nw >= 5 ? words[1] : null;
            final String title = nw >= 5 ? words[2] : null;
            final String contact = nw >= 5 ? words[3] : null;
            final String email = nw >= 5 ? words[4] : null;
            list.add(new ServerMeta(){

                @Override
                public String getUrl() {
                    return url;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public String getContact() {
                    return contact;
                }

                @Override
                public String getEmail() {
                    return email;
                }
            });
        }
        return list.toArray(new ServerMeta[0]);
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.hapi");
    }
}

