/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractWideFits;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BasicInputThreadLocal;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.BlockManager;
import uk.ac.starlink.fits.BlockMappedInput;
import uk.ac.starlink.fits.BufferManager;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.SimpleMappedInput;
import uk.ac.starlink.fits.Unmapper;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.Loader;

public class ColFitsStarTable
extends AbstractStarTable {
    private final int ncol_;
    private final long nrow_;
    private final ValueReader[] valReaders_;
    private final InputFactory[] inputFacts_;
    private final boolean isRandom_;
    private final ColumnReader[] randomColReaders_;
    private final Closeable closer_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    public ColFitsStarTable(DataSource datsrc, FitsHeader hdr, long dataPos, boolean force, WideFits wide) throws IOException {
        boolean hasExtCol;
        if (!"BINTABLE".equals(hdr.getStringValue("XTENSION"))) {
            throw new TableFormatException("HDU 1 not BINTABLE");
        }
        if (hdr.getRequiredIntValue("NAXIS2") != 1) {
            throw new TableFormatException("Doesn't have exactly one row");
        }
        int ncolStd = hdr.getRequiredIntValue("TFIELDS");
        this.ncol_ = wide == null ? ncolStd : wide.getExtendedColumnCount(hdr, ncolStd);
        boolean bl = hasExtCol = this.ncol_ > ncolStd;
        if (hasExtCol) {
            assert (wide != null);
            AbstractWideFits.logWideRead(logger_, ncolStd, this.ncol_);
        }
        if (!force && "LDAC_IMHEAD".equals(hdr.getStringValue("EXTNAME"))) {
            throw new TableFormatException("Reject LDAC_IMHEAD table");
        }
        long nrow = 0L;
        this.valReaders_ = new ValueReader[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String txtype;
            String tutype;
            String tucd;
            String tcomm;
            String tunit;
            long nitem;
            int jcol = icol + 1;
            BintableColumnHeader colhead = hasExtCol && jcol >= ncolStd ? wide.createExtendedHeader(ncolStd, jcol) : BintableColumnHeader.createStandardHeader(jcol);
            ColumnInfo cinfo = new ColumnInfo("col" + jcol);
            String tform = hdr.getRequiredStringValue(colhead.getKeyName("TFORM")).trim();
            char formatChar = tform.charAt(tform.length() - 1);
            if (formatChar == 'B') {
                Number tzero = hdr.getNumberValue(colhead.getKeyName("TZERO"));
                Number tscale = hdr.getNumberValue(colhead.getKeyName("TSCALE"));
                if (tzero != null && tzero.doubleValue() == -128.0 && (tscale == null || tscale.doubleValue() == 1.0)) {
                    formatChar = 'b';
                }
            }
            try {
                nitem = Long.parseLong(tform.substring(0, tform.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new TableFormatException("Bad " + colhead.getKeyName("TFORM") + " '" + tform + '\"');
            }
            String tdims = hdr.getStringValue(colhead.getKeyName("TDIM"));
            long[] dims = ColFitsStarTable.parseTdim(tdims);
            if (dims == null) {
                logger_.info("No " + colhead.getKeyName("TDIM") + "; assume (1," + nitem + ")");
                dims = new long[]{1L, nitem};
            }
            if (ColFitsStarTable.multiply(dims) != nitem) {
                throw new TableFormatException(colhead.getKeyName("TDIM") + " doesn't match " + colhead.getKeyName("TFORM"));
            }
            int[] itemShape = new int[dims.length - 1];
            for (int i = 0; i < dims.length - 1; ++i) {
                itemShape[i] = Tables.checkedLongToInt(dims[i]);
            }
            long nr = dims[dims.length - 1];
            if (icol == 0) {
                nrow = nr;
            } else if (nr != nrow) {
                throw new TableFormatException("Row count mismatch");
            }
            Long blank = hdr.getLongValue(colhead.getKeyName("TNULL"));
            String ttype = hdr.getStringValue(colhead.getKeyName("TTYPE"));
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = hdr.getStringValue(colhead.getKeyName("TUNIT"))) != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tcomm = hdr.getStringValue(colhead.getKeyName("TCOMM"))) != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tucd = hdr.getStringValue(colhead.getKeyName("TUCD"))) != null) {
                cinfo.setUCD(tucd);
            }
            if ((tutype = hdr.getStringValue(colhead.getKeyName("TUTYP"))) != null) {
                cinfo.setUtype(tutype);
            }
            if ((txtype = hdr.getStringValue(colhead.getKeyName("TXTYP"))) != null) {
                cinfo.setXtype(txtype);
            }
            this.valReaders_[icol] = ColFitsStarTable.createValueReader(formatChar, cinfo, itemShape, blank);
        }
        this.nrow_ = nrow;
        this.inputFacts_ = new InputFactory[this.ncol_];
        boolean isFile = datsrc instanceof FileDataSource;
        if (isFile && datsrc.getCompression() == Compression.NONE && (Loader.is64Bit() || ((FileDataSource)datsrc).getFile().length() < 0x20000000L)) {
            this.isRandom_ = true;
            File file = ((FileDataSource)datsrc).getFile();
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            final FileChannel chan = raf.getChannel();
            this.closer_ = new Closeable(){

                @Override
                public void close() throws IOException {
                    chan.close();
                }
            };
            long pos = dataPos;
            for (int icol = 0; icol < this.ncol_; ++icol) {
                long offset = pos;
                long leng = (long)this.valReaders_[icol].getItemBytes() * this.nrow_;
                pos += leng;
                String logName = file.getName() + ":col" + (icol + 1) + "/" + this.ncol_;
                this.inputFacts_[icol] = ColFitsStarTable.createInputFactory(chan, offset, leng, logName);
            }
            if (pos > chan.size()) {
                logger_.warning("HDU too short for data: FITS file corrupted/truncated");
            }
        } else {
            if (isFile && datsrc.getCompression() != Compression.NONE) {
                logger_.warning("Can't map compressed file " + datsrc.getName() + " - uncompressing may improve performance");
            }
            this.isRandom_ = false;
            long pos = dataPos;
            for (int icol = 0; icol < this.ncol_; ++icol) {
                long offset = pos;
                long leng = (long)this.valReaders_[icol].getItemBytes() * this.nrow_;
                pos += leng;
                this.inputFacts_[icol] = InputFactory.createSequentialFactory(datsrc, offset, leng);
            }
            this.closer_ = new Closeable(){

                @Override
                public void close() {
                }
            };
        }
        String tname = hdr.getStringValue("EXTNAME");
        if (tname != null) {
            String extver = hdr.getStringValue("EXTVER");
            if (extver != null) {
                tname = tname + "-" + extver;
            }
            this.setName(tname);
        }
        this.getParameters().addAll(Arrays.asList(hdr.getUnusedParams()));
        if (this.isRandom_) {
            this.randomColReaders_ = new ColumnReader[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                final BasicInputThreadLocal bitl = new BasicInputThreadLocal(this.inputFacts_[icol], false);
                this.randomColReaders_[icol] = new ColumnReader(this.valReaders_[icol]){

                    @Override
                    protected BasicInput getInput() {
                        return (BasicInput)bitl.get();
                    }

                    @Override
                    public void close() throws IOException {
                        bitl.close();
                    }
                };
            }
        } else {
            this.randomColReaders_ = null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public boolean isRandom() {
        return this.isRandom_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.valReaders_[icol].getColumnInfo();
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        if (this.randomColReaders_ != null) {
            return this.randomColReaders_[icol].readIndexedCell(irow);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        if (this.randomColReaders_ != null) {
            Object[] row = new Object[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                row[icol] = this.randomColReaders_[icol].readIndexedCell(irow);
            }
            return row;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return new ColFitsRowSequence();
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        if (this.isRandom_) {
            return new ColFitsRowAccess();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.closer_.close();
    }

    static long[] parseTdim(String tdim) {
        if (tdim == null) {
            return null;
        }
        if ((tdim = tdim.trim()).charAt(0) != '(' || tdim.charAt(tdim.length() - 1) != ')') {
            return null;
        }
        String[] sdims = tdim.substring(1, tdim.length() - 1).split(",");
        long[] dims = new long[sdims.length];
        for (int i = 0; i < sdims.length; ++i) {
            try {
                dims[i] = Long.parseLong(sdims[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return dims;
    }

    private static long multiply(long[] dims) {
        long product = 1L;
        for (int i = 0; i < dims.length; ++i) {
            product *= dims[i];
        }
        return product;
    }

    private static long multiply(int[] dims) {
        long product = 1L;
        for (int i = 0; i < dims.length; ++i) {
            product *= (long)dims[i];
        }
        return product;
    }

    private static int toInt(long lval) {
        int ival = (int)lval;
        assert ((long)ival == lval);
        return ival;
    }

    private static ValueReader createValueReader(char formatChar, ColumnInfo info, int[] itemShape, Number blank) throws IOException {
        final int itemSize = Tables.checkedLongToInt(ColFitsStarTable.multiply(itemShape));
        int[] SCALAR = new int[]{};
        if (itemSize == 1) {
            if (formatChar == 'L') {
                info.setContentClass(Boolean.class);
                return new ValueReader(info, 1, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        switch (in.readByte()) {
                            case 84: {
                                return Boolean.TRUE;
                            }
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return null;
                    }
                };
            }
            if (formatChar == 'A') {
                info.setContentClass(Character.class);
                info.setNullable(false);
                return new ValueReader(info, 1, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        char chr = (char)(in.readByte() & 0xFF);
                        return chr == '\u0000' ? null : Character.valueOf(chr);
                    }
                };
            }
            if (formatChar == 'B') {
                info.setContentClass(Short.class);
                final boolean hasBad = blank != null;
                final byte badval = hasBad ? blank.byteValue() : (byte)0;
                info.setNullable(hasBad);
                return new ValueReader(info, 1, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        byte val = in.readByte();
                        return hasBad && val == badval ? null : Short.valueOf((short)(val & 0xFF));
                    }
                };
            }
            if (formatChar == 'b') {
                info.setContentClass(Short.class);
                final boolean hasBad = blank != null;
                final byte badval = hasBad ? blank.byteValue() : (byte)0;
                info.setNullable(hasBad);
                return new ValueReader(info, 1, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        byte val = in.readByte();
                        return hasBad && val == badval ? null : Short.valueOf(val);
                    }
                };
            }
            if (formatChar == 'I') {
                info.setContentClass(Short.class);
                final boolean hasBad = blank != null;
                final short badval = hasBad ? blank.shortValue() : (short)0;
                info.setNullable(hasBad);
                return new ValueReader(info, 2, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        short val = in.readShort();
                        return hasBad && val == badval ? null : Short.valueOf(val);
                    }
                };
            }
            if (formatChar == 'J') {
                info.setContentClass(Integer.class);
                final boolean hasBad = blank != null;
                final int badval = hasBad ? blank.intValue() : 0;
                info.setNullable(hasBad);
                return new ValueReader(info, 4, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        int val = in.readInt();
                        return hasBad && val == badval ? null : Integer.valueOf(val);
                    }
                };
            }
            if (formatChar == 'K') {
                info.setContentClass(Long.class);
                final boolean hasBad = blank != null;
                final long badval = hasBad ? blank.longValue() : 0L;
                info.setNullable(hasBad);
                return new ValueReader(info, 8, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        long val = in.readLong();
                        return hasBad && val == badval ? null : Long.valueOf(val);
                    }
                };
            }
            if (formatChar == 'E') {
                info.setContentClass(Float.class);
                return new ValueReader(info, 4, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        return Float.valueOf(in.readFloat());
                    }
                };
            }
            if (formatChar == 'D') {
                info.setContentClass(Double.class);
                return new ValueReader(info, 8, SCALAR){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        return in.readDouble();
                    }
                };
            }
        } else {
            info.setShape(itemShape);
            info.setNullable(false);
            if (formatChar == 'L') {
                info.setContentClass(boolean[].class);
                return new ValueReader(info, 1, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        boolean[] val = new boolean[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readByte() == 84;
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'B') {
                info.setContentClass(short[].class);
                return new ValueReader(info, 1, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        short[] val = new short[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = (short)(in.readByte() & 0xFF);
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'b') {
                info.setContentClass(short[].class);
                return new ValueReader(info, 1, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        short[] val = new short[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readByte();
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'I') {
                info.setContentClass(short[].class);
                return new ValueReader(info, 2, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        short[] val = new short[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readShort();
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'J') {
                info.setContentClass(int[].class);
                return new ValueReader(info, 4, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        int[] val = new int[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readInt();
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'K') {
                info.setContentClass(long[].class);
                return new ValueReader(info, 8, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        long[] val = new long[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readLong();
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'E') {
                info.setContentClass(float[].class);
                return new ValueReader(info, 4, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        float[] val = new float[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readFloat();
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'D') {
                info.setContentClass(double[].class);
                return new ValueReader(info, 8, itemShape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        double[] val = new double[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = in.readDouble();
                        }
                        return val;
                    }
                };
            }
            if (formatChar == 'A') {
                final int sleng = itemShape[0];
                info.setElementSize(sleng);
                info.setNullable(true);
                if (itemShape.length == 1) {
                    info.setContentClass(String.class);
                    return new ValueReader(info, sleng, SCALAR){

                        @Override
                        Object readValue(BasicInput in) throws IOException {
                            char[] charBuf = new char[sleng];
                            int iend = 0;
                            boolean end = false;
                            for (int i = 0; i < sleng; ++i) {
                                byte b = in.readByte();
                                if (b == 0) {
                                    end = true;
                                }
                                if (end) continue;
                                charBuf[i] = (char)(b & 0xFF);
                                if (b == 32) continue;
                                iend = i + 1;
                            }
                            return iend > 0 ? new String(charBuf, 0, iend) : null;
                        }
                    };
                }
                info.setContentClass(String[].class);
                int[] sshape = new int[itemShape.length - 1];
                System.arraycopy(itemShape, 1, sshape, 0, sshape.length);
                info.setShape(sshape);
                final int nstring = itemSize / sleng;
                assert (nstring * sleng == itemSize);
                return new ValueReader(info, sleng, sshape){

                    @Override
                    Object readValue(BasicInput in) throws IOException {
                        String[] val = new String[nstring];
                        char[] charBuf = new char[sleng];
                        for (int is = 0; is < nstring; ++is) {
                            int iend = 0;
                            boolean end = false;
                            for (int ic = 0; ic < sleng; ++ic) {
                                byte b = in.readByte();
                                if (b == 0) {
                                    end = true;
                                }
                                if (end) continue;
                                charBuf[ic] = (char)(b & 0xFF);
                                if (b == 32) continue;
                                iend = ic + 1;
                            }
                            val[is] = iend > 0 ? new String(charBuf, 0, iend) : null;
                        }
                        return val;
                    }
                };
            }
        }
        throw new IOException("Unknown TFORM character '" + formatChar + "'");
    }

    private static InputFactory createInputFactory(FileChannel chan, long offset, long leng, String logName) {
        Unmapper unmapper = Unmapper.getInstance();
        if (leng <= 0x10000000L) {
            final BufferManager bufManager = new BufferManager(chan, offset, (int)leng, logName, unmapper);
            return new InputFactory(){

                @Override
                public boolean isRandom() {
                    return true;
                }

                @Override
                public BasicInput createInput(boolean isSeq) throws IOException {
                    return new SimpleMappedInput(bufManager);
                }

                @Override
                public void close() {
                    bufManager.close();
                }
            };
        }
        final BlockManager blockManager = new BlockManager(chan, offset, leng, logName, unmapper, 0x10000000);
        return new InputFactory(){

            @Override
            public boolean isRandom() {
                return true;
            }

            @Override
            public BasicInput createInput(boolean isSeq) throws IOException {
                return BlockMappedInput.createInput(blockManager, !isSeq);
            }

            @Override
            public void close() {
                blockManager.close();
            }
        };
    }

    private static abstract class ColumnReader
    implements Closeable {
        private final ValueReader valReader_;
        private final long itemBytes_;

        ColumnReader(ValueReader valReader) {
            this.valReader_ = valReader;
            this.itemBytes_ = valReader.getItemBytes();
        }

        protected abstract BasicInput getInput() throws IOException;

        Object readIndexedCell(long irow) throws IOException {
            BasicInput input = this.getInput();
            input.seek(irow * this.itemBytes_);
            return this.valReader_.readValue(input);
        }

        Object readNextCell() throws IOException {
            return this.valReader_.readValue(this.getInput());
        }

        void skipCells(long nrow) throws IOException {
            this.getInput().skip(this.itemBytes_ * nrow);
        }
    }

    private static abstract class ValueReader {
        private final ColumnInfo info_;
        private final int typeBytes_;
        private final int[] itemShape_;
        private final int itemBytes_;

        ValueReader(ColumnInfo info, int typeBytes, int[] itemShape) {
            this.info_ = info;
            this.typeBytes_ = typeBytes;
            this.itemShape_ = itemShape;
            this.itemBytes_ = Tables.checkedLongToInt(ColFitsStarTable.multiply(itemShape)) * typeBytes;
        }

        abstract Object readValue(BasicInput var1) throws IOException;

        public int getItemBytes() {
            return this.itemBytes_;
        }

        public ColumnInfo getColumnInfo() {
            return this.info_;
        }
    }

    private class ColFitsRowAccess
    implements RowAccess {
        private final ColumnReader[] colReaders_;
        private final Object[] row_;
        private long irow_;

        ColFitsRowAccess() throws IOException {
            this.colReaders_ = new ColumnReader[ColFitsStarTable.this.ncol_];
            for (int icol = 0; icol < ColFitsStarTable.this.ncol_; ++icol) {
                final InputFactory inFact = ColFitsStarTable.this.inputFacts_[icol];
                this.colReaders_[icol] = new ColumnReader(ColFitsStarTable.this.valReaders_[icol]){
                    BasicInput input_;

                    @Override
                    protected BasicInput getInput() throws IOException {
                        if (this.input_ == null) {
                            this.input_ = inFact.createInput(false);
                        }
                        return this.input_;
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.input_ != null) {
                            this.input_.close();
                        }
                    }
                };
            }
            this.row_ = new Object[ColFitsStarTable.this.ncol_];
        }

        @Override
        public void setRowIndex(long irow) {
            this.irow_ = irow;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.colReaders_[icol].readIndexedCell(this.irow_);
        }

        @Override
        public Object[] getRow() throws IOException {
            for (int icol = 0; icol < ColFitsStarTable.this.ncol_; ++icol) {
                this.row_[icol] = this.colReaders_[icol].readIndexedCell(this.irow_);
            }
            return this.row_;
        }

        @Override
        public void close() throws IOException {
            for (ColumnReader colReader : this.colReaders_) {
                colReader.close();
            }
        }
    }

    private class ColFitsRowSequence
    implements RowSequence {
        private final ColumnReader[] seqColReaders_;
        private final long[] cursors_;
        private final Object[] lastValues_;
        private long irow_;

        ColFitsRowSequence() throws IOException {
            this.seqColReaders_ = new ColumnReader[ColFitsStarTable.this.ncol_];
            this.cursors_ = new long[ColFitsStarTable.this.ncol_];
            for (int icol = 0; icol < ColFitsStarTable.this.ncol_; ++icol) {
                final InputFactory inputFact = ColFitsStarTable.this.inputFacts_[icol];
                this.seqColReaders_[icol] = new ColumnReader(ColFitsStarTable.this.valReaders_[icol]){
                    BasicInput input_;

                    @Override
                    protected BasicInput getInput() throws IOException {
                        if (this.input_ == null) {
                            this.input_ = inputFact.createInput(true);
                        }
                        return this.input_;
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.input_ != null) {
                            this.input_.close();
                        }
                    }
                };
                this.cursors_[icol] = -1L;
            }
            this.lastValues_ = new Object[ColFitsStarTable.this.ncol_];
            this.irow_ = -1L;
        }

        @Override
        public boolean next() {
            return ++this.irow_ < ColFitsStarTable.this.nrow_;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            ColumnReader colReader = this.seqColReaders_[icol];
            long nskip = this.irow_ - this.cursors_[icol];
            if (nskip > 0L) {
                if (nskip > 1L) {
                    colReader.skipCells(nskip - 1L);
                }
                this.lastValues_[icol] = colReader.readNextCell();
                this.cursors_[icol] = this.irow_;
            } else if (this.irow_ < 0L) {
                throw new IllegalStateException();
            }
            return this.lastValues_[icol];
        }

        @Override
        public Object[] getRow() throws IOException {
            Object[] row = new Object[ColFitsStarTable.this.ncol_];
            for (int icol = 0; icol < ColFitsStarTable.this.ncol_; ++icol) {
                row[icol] = this.getCell(icol);
            }
            return row;
        }

        @Override
        public void close() throws IOException {
            for (ColumnReader colReader : this.seqColReaders_) {
                colReader.close();
            }
        }
    }
}

