/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.AbstractColumnWriter;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.FeatherType;

public abstract class NumberRandomWriter
extends AbstractColumnWriter {
    private final long nbyte_;

    protected NumberRandomWriter(String string, FeatherType featherType, boolean bl, String string2, int n, long l) {
        super(string, featherType, l, bl, string2);
        this.nbyte_ = (long)n * l;
    }

    protected abstract void writeData(OutputStream var1) throws IOException;

    @Override
    public boolean isNull(long l) {
        return false;
    }

    @Override
    public long writeDataBytes(OutputStream outputStream) throws IOException {
        this.writeData(outputStream);
        return this.nbyte_;
    }

    public static FeatherColumnWriter createDoubleWriter(String string, final double[] dArray, String string2) {
        final int n = dArray.length;
        return new NumberRandomWriter(string, FeatherType.DOUBLE, false, string2, 8, n){

            @Override
            protected void writeData(OutputStream outputStream) throws IOException {
                for (int i = 0; i < n; ++i) {
                    BufUtils.writeLittleEndianDouble(outputStream, dArray[i]);
                }
            }
        };
    }

    public static FeatherColumnWriter createFloatWriter(String string, final float[] fArray, String string2) {
        final int n = fArray.length;
        return new NumberRandomWriter(string, FeatherType.FLOAT, false, string2, 4, n){

            @Override
            protected void writeData(OutputStream outputStream) throws IOException {
                for (int i = 0; i < n; ++i) {
                    BufUtils.writeLittleEndianFloat(outputStream, fArray[i]);
                }
            }
        };
    }

    public static FeatherColumnWriter createLongWriter(String string, final long[] lArray, String string2) {
        final int n = lArray.length;
        return new NumberRandomWriter(string, FeatherType.INT64, false, string2, 8, n){

            @Override
            protected void writeData(OutputStream outputStream) throws IOException {
                for (int i = 0; i < n; ++i) {
                    BufUtils.writeLittleEndianLong(outputStream, lArray[i]);
                }
            }
        };
    }

    public static FeatherColumnWriter createIntWriter(String string, final int[] nArray, String string2) {
        final int n = nArray.length;
        return new NumberRandomWriter(string, FeatherType.INT32, false, string2, 4, n){

            @Override
            protected void writeData(OutputStream outputStream) throws IOException {
                for (int i = 0; i < n; ++i) {
                    BufUtils.writeLittleEndianInt(outputStream, nArray[i]);
                }
            }
        };
    }

    public static FeatherColumnWriter createShortWriter(String string, final short[] sArray, String string2) {
        final int n = sArray.length;
        return new NumberRandomWriter(string, FeatherType.INT16, false, string2, 2, n){

            @Override
            protected void writeData(OutputStream outputStream) throws IOException {
                for (int i = 0; i < n; ++i) {
                    BufUtils.writeLittleEndianShort(outputStream, sArray[i]);
                }
            }
        };
    }

    public static FeatherColumnWriter createByteWriter(String string, final byte[] byArray, String string2) {
        int n = byArray.length;
        return new NumberRandomWriter(string, FeatherType.INT8, false, string2, 1, n){

            @Override
            protected void writeData(OutputStream outputStream) throws IOException {
                outputStream.write(byArray);
            }
        };
    }
}

