/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.FieldRefElement;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.ParamRefElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;

public class GroupElement
extends VOElement {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    GroupElement(Element base, VODocument doc) {
        super(base, doc, "GROUP");
    }

    public ParamElement[] getParams() {
        ArrayList<ParamElement> paramList = new ArrayList<ParamElement>();
        for (Node ch = this.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (ch instanceof ParamRefElement) {
                ParamElement pel = ((ParamRefElement)ch).getParam();
                if (pel == null) {
                    logger_.warning("Missing referent for PARAMref");
                    continue;
                }
                paramList.add(pel);
                continue;
            }
            if (!(ch instanceof ParamElement)) continue;
            paramList.add((ParamElement)ch);
        }
        return paramList.toArray(new ParamElement[0]);
    }

    public FieldElement[] getFields() {
        ArrayList<FieldElement> fieldList = new ArrayList<FieldElement>();
        for (Node ch = this.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof FieldRefElement)) continue;
            FieldElement fel = ((FieldRefElement)ch).getField();
            if (fel == null) {
                logger_.warning("Missing referent for FIELDref");
                continue;
            }
            fieldList.add(fel);
        }
        return fieldList.toArray(new FieldElement[0]);
    }

    public GroupElement[] getGroups() {
        VOElement[] voels = this.getChildrenByName("GROUP");
        GroupElement[] gels = new GroupElement[voels.length];
        System.arraycopy(voels, 0, gels, 0, voels.length);
        return gels;
    }
}

