/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableParser;

class SingleTableReader
extends VOTableParser
implements TableHandler {
    private final StoragePolicy storage_;
    private final Namespacing namespacing_;
    private RowStore rowStore_;
    private boolean isVotable_;
    private TableElement tableEl_;
    private int skipTables_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    public SingleTableReader(StoragePolicy storage, int itable, boolean strict) {
        super(strict);
        this.storage_ = storage;
        this.skipTables_ = itable;
        this.setTableHandler(null);
        this.setReadHrefTables(false);
        this.namespacing_ = Namespacing.getInstance();
    }

    public TableElement getTargetTableElement() {
        return this.tableEl_;
    }

    public boolean isVotable() {
        return this.isVotable_;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        String tagName = this.namespacing_.getVOTagName(namespaceURI, localName, qName);
        if ("VOTABLE".equals(tagName)) {
            this.isVotable_ = true;
        }
        if ("TABLE".equals(tagName) && this.skipTables_-- == 0) {
            this.setReadHrefTables(true);
            this.setTableHandler(this);
        }
    }

    @Override
    public void startTable(StarTable meta) throws SAXException {
        this.rowStore_ = this.storage_.makeConfiguredRowStore(meta);
    }

    @Override
    public void rowData(Object[] row) throws SAXException {
        try {
            this.rowStore_.acceptRow(row);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
    }

    @Override
    public void endTable() throws SAXException {
        this.setTableHandler(null);
        this.setReadHrefTables(false);
        try {
            this.rowStore_.endRows();
            this.tableEl_ = this.getTableElement();
            TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(this.rowStore_.getStarTable());
            this.tableEl_.setData(tdata);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
    }

    public static VOStarTable readStarTable(InputSource saxsrc, int itable, StoragePolicy storage, boolean strict) throws IOException, SAXException {
        XMLReader parser;
        SingleTableReader reader = new SingleTableReader(storage, itable, strict);
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            reader.namespacing_.configureSAXParserFactory(spfact);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage(), e).initCause(e);
        }
        parser.setContentHandler(reader);
        parser.setEntityResolver(StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void warning(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        try {
            parser.parse(saxsrc);
        }
        catch (CharConversionException e) {
            if (reader.isVotable_) {
                throw e;
            }
            throw new TableFormatException("Bad XML characters", e);
        }
        catch (SAXException e) {
            e = VOElementFactory.fixStackTrace(e);
            if (reader.isVotable_) {
                throw e;
            }
            throw new TableFormatException(e);
        }
        if (reader.isVotable_) {
            TableElement tableEl = reader.getTargetTableElement();
            if (tableEl != null) {
                return new VOStarTable(tableEl);
            }
            throw new IOException("No TABLE element found");
        }
        throw new TableFormatException("No VOTABLE element");
    }
}

