/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.votable.SAXDocumentBuilder;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;

class VOSAXDocumentBuilder
implements SAXDocumentBuilder {
    private Locator locator_;
    private VODocument doc_;
    private NodeStack nodeStack_ = new NodeStack();
    private Map<String, String> prefixMap_ = new HashMap<String, String>();
    private boolean strict_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");
    private static final String[] ELEMENTS_WITH_ID = new String[]{"VOTABLE", "RESOURCE", "INFO", "PARAM", "TABLE", "FIELD", "GROUP", "VALUES", "LINK", "COOSYS", "TIMESYS"};

    public VOSAXDocumentBuilder(boolean strict) {
        this.strict_ = strict;
    }

    @Override
    public Node getNewestNode() {
        return this.nodeStack_.top();
    }

    @Override
    public Locator getLocator() {
        return this.locator_;
    }

    @Override
    public Document getDocument() {
        return this.doc_;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        Document baseDoc;
        try {
            baseDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException("Cannot create empty DOM", e).initCause(e);
        }
        String systemId = this.locator_ == null ? null : this.locator_.getSystemId();
        this.doc_ = new VODocument(baseDoc, systemId, this.strict_);
        this.nodeStack_.push(this.doc_);
    }

    @Override
    public void endDocument() {
        this.nodeStack_.pop().normalize();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap_.put(uri, prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        Iterator<String> it = this.prefixMap_.values().iterator();
        while (it.hasNext()) {
            if (!it.next().equals(prefix)) continue;
            it.remove();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXParseException {
        try {
            Element el;
            if (localName != null && localName.length() > 0) {
                String prefix = this.prefixMap_.get(namespaceURI);
                String qualifiedName = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
                el = this.doc_.createElementNS(namespaceURI, qualifiedName);
            } else {
                String tagName = qName;
                el = this.doc_.createElement(tagName);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                Attr att;
                String attURI = atts.getURI(i);
                String attLocalName = atts.getLocalName(i);
                String attQName = atts.getQName(i);
                String value = atts.getValue(i);
                String type = atts.getType(i);
                if (attURI != null && attURI.length() > 0 && attQName != null && attQName.length() > 0) {
                    att = this.doc_.createAttributeNS(attURI, attQName);
                    el.setAttributeNodeNS(att);
                } else if (attQName != null && attQName.length() > 0) {
                    att = this.doc_.createAttribute(attQName);
                    el.setAttributeNode(att);
                } else {
                    att = this.doc_.createAttribute(attLocalName);
                    el.setAttributeNode(att);
                }
                att.setValue(value);
                if (!type.equals("ID") && !this.isVotableID(att)) continue;
                if (this.doc_.getElementById(value) != null) {
                    logger_.warning("Multiple elements with ID " + value);
                }
                this.doc_.setElementId(el, value);
            }
            this.nodeStack_.top().appendChild(el);
            this.nodeStack_.push(el);
        }
        catch (DOMException e) {
            throw (SAXParseException)new SAXParseException("DOM building error", this.locator_, e).initCause(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        this.nodeStack_.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXParseException {
        if (this.nodeStack_.isEmpty() && new String(ch, start, length).trim().length() == 0) {
            return;
        }
        try {
            this.nodeStack_.top().appendChild(this.doc_.createTextNode(new String(ch, start, length)));
        }
        catch (DOMException e) {
            throw (SAXParseException)new SAXParseException("DOM building error", this.locator_, e).initCause(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
        logger_.info("Skipping entity " + name);
    }

    private boolean isVotableID(Attr att) {
        if (att.getName().equals("ID")) {
            String elName = ((VOElement)att.getOwnerElement()).getVOTagName();
            for (int i = 0; i < ELEMENTS_WITH_ID.length; ++i) {
                if (!ELEMENTS_WITH_ID[i].equals(elName)) continue;
                return true;
            }
        }
        return false;
    }

    private static class NodeStack {
        private LinkedList<Node> stack_ = new LinkedList();

        private NodeStack() {
        }

        void push(Node node) {
            this.stack_.add(node);
        }

        Node pop() {
            return this.stack_.removeLast();
        }

        Node top() {
            return this.stack_.isEmpty() ? null : this.stack_.getLast();
        }

        boolean isEmpty() {
            return this.stack_.isEmpty();
        }
    }
}

