/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.awt.Component;
import java.awt.event.ActionEvent;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.util.Loader;

public class ConnectorManager {
    private static Connector[] connectors_;
    private static ConnectorAction[] connectorActions_;
    private static final String[] KNOWN_CONNECTORS;
    public static final String CONNECTORS_PROPERTY = "star.connectors";

    public static Connector[] getConnectors() {
        if (connectors_ == null) {
            connectors_ = Loader.getClassInstances(KNOWN_CONNECTORS, CONNECTORS_PROPERTY, Connector.class).toArray(new Connector[0]);
        }
        return (Connector[])connectors_.clone();
    }

    public static synchronized ConnectorAction[] getConnectorActions() {
        if (connectorActions_ == null) {
            Connector[] connectors = ConnectorManager.getConnectors();
            int nconn = connectors.length;
            connectorActions_ = new ConnectorAction[nconn];
            for (int i = 0; i < nconn; ++i) {
                ConnectorManager.connectorActions_[i] = new ConnectorAction(connectors[i]);
            }
        }
        return (ConnectorAction[])connectorActions_.clone();
    }

    public static Connection showConnectionDialog(Component parent, Connector connector) {
        ConnectorAction connAct = new ConnectorAction(connector);
        Connection connection = connAct.getConnection();
        if (connection != null) {
            return connection;
        }
        connAct.actionPerformed(new ActionEvent(parent, 0, "Log In"));
        return connAct.getConnection();
    }

    static {
        KNOWN_CONNECTORS = new String[]{"uk.ac.starlink.astrogrid.AcrConnector", "uk.ac.starlink.srb.SRBConnector"};
    }
}

