/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.starlink.feather.AbstractItemAccumulator;
import uk.ac.starlink.feather.ItemAccumulator;
import uk.ac.starlink.feather.StarColumnWriter;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;

public abstract class NumberStarColumnWriter
extends StarColumnWriter {
    private final byte[] blank_;
    private final int itemSize_;

    protected NumberStarColumnWriter(StarTable table, int icol, FeatherType featherType, boolean isNullable, byte[] blank) {
        super(table, icol, featherType, isNullable);
        this.blank_ = (byte[])blank.clone();
        this.itemSize_ = blank.length;
    }

    protected abstract void writeNumber(OutputStream var1, Number var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarColumnWriter.DataStat writeDataBytes(OutputStream out) throws IOException {
        int icol = this.getColumnIndex();
        long nrow = 0L;
        try (RowSequence rseq = this.getTable().getRowSequence();){
            while (rseq.next()) {
                ++nrow;
                Object item = rseq.getCell(icol);
                if (item != null) {
                    this.writeNumber(out, (Number)item);
                    continue;
                }
                out.write(this.blank_);
            }
        }
        long nbyte = nrow * (long)this.itemSize_;
        return new StarColumnWriter.DataStat(nbyte, nrow);
    }

    @Override
    public ItemAccumulator createItemAccumulator(StoragePolicy storage) {
        final ByteStore dataStore = storage.makeByteStore();
        final BufferedOutputStream dataOut = new BufferedOutputStream(dataStore.getOutputStream());
        return new AbstractItemAccumulator(storage, this.isNullable()){
            long nbData;

            @Override
            public void addDataItem(Object item) throws IOException {
                if (item != null) {
                    NumberStarColumnWriter.this.writeNumber(dataOut, (Number)item);
                } else {
                    dataOut.write(NumberStarColumnWriter.this.blank_);
                }
                this.nbData += (long)NumberStarColumnWriter.this.itemSize_;
            }

            @Override
            public long writeDataBytes(OutputStream out) throws IOException {
                dataOut.close();
                dataStore.copy(out);
                dataStore.close();
                return this.nbData;
            }

            @Override
            public void closeData() throws IOException {
                dataOut.close();
                dataStore.close();
            }
        };
    }
}

