/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.IOException;
import java.io.OutputStream;
import org.json.JSONObject;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.ColStat;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.starlink.feather.ItemAccumulator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;

public abstract class StarColumnWriter
implements FeatherColumnWriter {
    private final StarTable table_;
    private final int icol_;
    private final FeatherType featherType_;
    private final boolean isNullable_;

    protected StarColumnWriter(StarTable table, int icol, FeatherType featherType, boolean isNullable) {
        this.table_ = table;
        this.icol_ = icol;
        this.featherType_ = featherType;
        this.isNullable_ = isNullable;
    }

    public abstract DataStat writeDataBytes(OutputStream var1) throws IOException;

    public StarTable getTable() {
        return this.table_;
    }

    public int getColumnIndex() {
        return this.icol_;
    }

    @Override
    public FeatherType getFeatherType() {
        return this.featherType_;
    }

    public boolean isNullable() {
        return this.isNullable_;
    }

    @Override
    public String getName() {
        return this.table_.getColumnInfo(this.icol_).getName();
    }

    @Override
    public String getUserMetadata() {
        ColumnInfo info = this.table_.getColumnInfo(this.icol_);
        JSONObject json = new JSONObject();
        StarColumnWriter.addJsonEntry(json, "unit", info.getUnitString());
        StarColumnWriter.addJsonEntry(json, "ucd", info.getUCD());
        StarColumnWriter.addJsonEntry(json, "utype", info.getUtype());
        StarColumnWriter.addJsonEntry(json, "description", info.getDescription());
        StarColumnWriter.addJsonEntry(json, "shape", DefaultValueInfo.formatShape((int[])info.getShape()));
        return json.length() > 0 ? json.toString(0).replaceAll("\n", " ") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColStat writeColumnBytes(OutputStream out) throws IOException {
        long maskBytes;
        long nNull = 0L;
        if (this.isNullable_ && this.table_.getColumnInfo(this.icol_).isNullable()) {
            int mask = 0;
            int ibit = 0;
            long nrow = 0L;
            try (RowSequence rseq = this.table_.getRowSequence();){
                while (rseq.next()) {
                    ++nrow;
                    if (rseq.getCell(this.icol_) == null) {
                        ++nNull;
                    } else {
                        mask |= 1 << ibit;
                    }
                    if (++ibit != 8) continue;
                    out.write(mask);
                    ibit = 0;
                    mask = 0;
                }
                if (ibit > 0) {
                    out.write(mask);
                }
            }
            long mb = (nrow + 7L) / 8L;
            maskBytes = mb + (long)BufUtils.align8(out, mb);
        } else {
            maskBytes = 0L;
        }
        DataStat dataStat = this.writeDataBytes(out);
        long db = dataStat.getByteCount();
        final long rowCount = dataStat.getRowCount();
        long dataBytes = db + (long)BufUtils.align8(out, db);
        boolean hasNull = nNull > 0L;
        final long byteCount = maskBytes + dataBytes;
        final long dataOffset = maskBytes;
        final long nullCount = nNull;
        return new ColStat(){

            @Override
            public long getRowCount() {
                return rowCount;
            }

            @Override
            public long getByteCount() {
                return byteCount;
            }

            @Override
            public long getDataOffset() {
                return dataOffset;
            }

            @Override
            public long getNullCount() {
                return nullCount;
            }
        };
    }

    public abstract ItemAccumulator createItemAccumulator(StoragePolicy var1);

    private static void addJsonEntry(JSONObject json, String key, String value) {
        if (value != null && value.trim().length() > 0) {
            json.put(key, value);
        }
    }

    public static class DataStat {
        private final long byteCount_;
        private final long rowCount_;

        public DataStat(long byteCount, long rowCount) {
            this.byteCount_ = byteCount;
            this.rowCount_ = rowCount;
        }

        public long getByteCount() {
            return this.byteCount_;
        }

        public long getRowCount() {
            return this.rowCount_;
        }
    }
}

