/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import uk.ac.starlink.hapi.HapiService;
import uk.ac.starlink.hapi.HapiSource;
import uk.ac.starlink.hapi.ServerMeta;
import uk.ac.starlink.hapi.ServicePanel;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.gui.ComboBoxBumper;

public class HapiBrowser
extends JPanel {
    private final Supplier<ContentCoding> codingSupplier_;
    private final Consumer<URL> docUrlHandler_;
    private final JComboBox<String> nameSelector_;
    private final JTextField urlField_;
    private final SpinnerNumberModel chunklimitModel_;
    private final JComponent serviceBox_;
    private final Map<HapiService, ServicePanel> serviceMap_;
    private final PropertyChangeListener pcForwarder_;
    private HapiService service_;
    private String format_;
    private boolean includeHeader_;
    private ServerMeta[] servers_;
    public static final String HAPISOURCE_PROP = "hapiSource";
    private static final int MAX_CHUNKLIMIT = 50;

    public HapiBrowser() {
        this(null, null);
    }

    public HapiBrowser(Supplier<ContentCoding> codingSupplier, Consumer<URL> docUrlHandler) {
        super(new BorderLayout());
        this.codingSupplier_ = codingSupplier;
        this.docUrlHandler_ = docUrlHandler;
        this.servers_ = new ServerMeta[0];
        this.serviceMap_ = new HashMap<HapiService, ServicePanel>();
        this.serviceBox_ = new JPanel(new BorderLayout());
        this.urlField_ = new JTextField();
        this.urlField_.addActionListener(evt -> this.setServerUrl(this.urlField_.getText()));
        this.nameSelector_ = new JComboBox();
        this.nameSelector_.addItemListener(evt -> {
            int isel = this.nameSelector_.getSelectedIndex();
            if (isel >= 0) {
                String name = this.nameSelector_.getItemAt(isel);
                for (ServerMeta server : this.servers_) {
                    if (!name.equals(server.getName())) continue;
                    String url = server.getUrl();
                    this.urlField_.setText(url);
                    this.setServerUrl(url);
                }
            }
        });
        this.chunklimitModel_ = new SpinnerNumberModel(1, 1, 50, 1);
        this.pcForwarder_ = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if (HapiBrowser.HAPISOURCE_PROP.equals(propName)) {
                    HapiBrowser.this.firePropertyChange(propName, evt.getOldValue(), evt.getNewValue());
                }
            }
        };
        this.setServerUrl(null);
        LabelledComponentStack stack = new LabelledComponentStack();
        Box selectorBox = Box.createHorizontalBox();
        selectorBox.add(this.nameSelector_);
        selectorBox.add(Box.createHorizontalStrut(5));
        selectorBox.add(new ComboBoxBumper(this.nameSelector_));
        stack.addLine("HAPI Server", selectorBox);
        stack.addLine("HAPI URL", this.urlField_);
        stack.addLine("Chunk Limit", new JSpinner(this.chunklimitModel_));
        stack.setBorder(HapiBrowser.createTitledBorder("Service Selection"));
        this.add((Component)stack, "North");
        this.add((Component)this.serviceBox_, "Center");
        this.setPreferredSize(new Dimension(600, 560));
    }

    public void init() {
        new Thread(() -> {
            ServerMeta[] servers = ServerMeta.getServers();
            SwingUtilities.invokeLater(() -> this.setServers(servers));
        }, "HAPI default service list loader").start();
    }

    public void setServers(ServerMeta[] servers) {
        this.servers_ = servers;
        this.nameSelector_.removeAllItems();
        for (ServerMeta server : servers) {
            this.nameSelector_.addItem(server.getName());
        }
        if (this.nameSelector_.getSelectedItem() == null && this.nameSelector_.getItemCount() > 0) {
            this.nameSelector_.setSelectedItem(this.nameSelector_.getItemAt(0));
        }
    }

    public void setFormat(String format) {
        this.format_ = format;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader_ = includeHeader;
    }

    public HapiSource getHapiSource() {
        ServicePanel servicePanel = this.getServicePanel();
        return servicePanel == null ? null : servicePanel.getHapiSource();
    }

    public HapiService getService() {
        return this.service_;
    }

    public int getChunkLimit() {
        return this.chunklimitModel_.getNumber().intValue();
    }

    public ServicePanel getServicePanel() {
        return this.serviceMap_.get(this.service_);
    }

    private void setServerUrl(String serverUrl) {
        HapiService service = null;
        if (serverUrl == null) {
            service = null;
        } else {
            try {
                service = new HapiService(serverUrl, this.codingSupplier_);
            }
            catch (MalformedURLException e) {
                service = null;
            }
        }
        if (!Objects.equals(service, this.service_)) {
            ServicePanel oldServicePanel = this.serviceMap_.get(this.service_);
            HapiSource oldHapiSrc = this.getHapiSource();
            if (oldServicePanel != null) {
                oldServicePanel.removePropertyChangeListener(this.pcForwarder_);
            }
            this.service_ = service;
            HapiService service0 = service;
            this.serviceMap_.computeIfAbsent(service, u -> {
                ServicePanel sp = new ServicePanel(service0, this.docUrlHandler_);
                sp.setFormatSupplier(() -> this.format_);
                sp.setHeaderInclusion(() -> this.includeHeader_);
                return sp;
            });
            ServicePanel servicePanel = this.serviceMap_.get(service);
            HapiSource hapiSrc = this.getHapiSource();
            if (servicePanel != null) {
                if (oldServicePanel != null) {
                    servicePanel.getDateRangePanel().configureFromTemplate(oldServicePanel.getDateRangePanel());
                }
                servicePanel.addPropertyChangeListener(this.pcForwarder_);
            }
            this.serviceBox_.removeAll();
            this.serviceBox_.add((Component)servicePanel, "Center");
            this.serviceBox_.revalidate();
            this.serviceBox_.repaint();
            if (!Objects.equals(oldHapiSrc, hapiSrc)) {
                this.firePropertyChange(HAPISOURCE_PROP, oldHapiSrc, hapiSrc);
            }
        }
    }

    static Border createTitledBorder(String txt) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), txt);
    }

    public static void main(String[] args) {
        HapiBrowser browser = new HapiBrowser();
        JFrame frame = new JFrame();
        frame.getContentPane().add(browser);
        frame.pack();
        frame.setVisible(true);
        browser.init();
    }
}

