/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.hapi.HapiInfo;
import uk.ac.starlink.hapi.HapiTableReader;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOSupplier;

public class HapiTableBuilder
extends DocumentedTableBuilder {
    public HapiTableBuilder() {
        super(new String[]{"hapi"});
    }

    @Override
    public boolean canStream() {
        return true;
    }

    @Override
    public String getFormatName() {
        return "HAPI";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return super.looksLikeFile(location) || location.startsWith("http") && location.indexOf("data?") > 0 && location.indexOf("include=header") > 0;
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>HAPI, the", "<a href='http://hapi-server.org/'", "   >Heliophysics Data Application Programmer's Interface</a>", "is a protocol for serving streamed time series data.", "This reader can read HAPI CSV and binary tables", "if they include header information", "(the <code>include=header</code> request parameter", " must be present).", "An example HAPI URL is", "<verbatim>", "   https://vires.services/hapi/data?dataset=GRACE_A_MAG&amp;start=2009-01-01&amp;stop=2009-01-02&amp;include=header", "</verbatim>", "</p>", "<p>While HAPI data is normally accessed directly", "from the service,", "it is possible to download a HAPI stream to a local file", "and use this handler to read it from disk.", "</p>", "");
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        Byte byte0;
        HapiInfo hdr;
        if (!HapiTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("No HAPI header");
        }
        try (InputStream in = datsrc.getInputStream();){
            int[] overread1 = new int[1];
            hdr = HapiInfo.fromCommentedStream(in, overread1);
            int b0 = overread1[0];
            byte0 = (b0 & 0xFF) == b0 ? Byte.valueOf((byte)b0) : null;
        }
        HapiTableReader rdr = new HapiTableReader(hdr.getParameters());
        String fmt = hdr.getFormat();
        IOSupplier<RowSequence> rseqSupplier = () -> {
            BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
            HapiInfo.fromCommentedStream(in, null);
            return rdr.createRowSequence(in, byte0, fmt);
        };
        return rdr.createStarTable(rseqSupplier);
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        int[] overread1 = new int[1];
        HapiInfo hdr = HapiInfo.fromCommentedStream(in, overread1);
        String fmt = hdr.getFormat();
        int b0 = overread1[0];
        Byte byte0 = (b0 & 0xFF) == b0 ? Byte.valueOf((byte)b0) : null;
        HapiTableReader rdr = new HapiTableReader(hdr.getParameters());
        StarTable meta = rdr.createStarTable(null);
        RowSequence rseq = rdr.createRowSequence(in, byte0, fmt);
        sink.acceptMetadata(meta);
        while (rseq.next()) {
            sink.acceptRow(rseq.getRow());
        }
        sink.endRows();
    }

    public static boolean isMagic(byte[] buf) {
        if (buf[0] != 35) {
            return false;
        }
        block4: for (int i = 1; i < buf.length; ++i) {
            switch (buf[i]) {
                case 10: 
                case 13: 
                case 32: 
                case 35: {
                    continue block4;
                }
                case 123: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

