/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import uk.ac.starlink.table.TimeMapper;

public class Times {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private Times() {
    }

    public static double isoToUnixSeconds(String isoTime) {
        return TimeMapper.ISO_8601.toUnixSeconds(isoTime);
    }

    public static String formatUnixSeconds(long unixSec, DateFormat format) {
        return format.format(unixSec * 1000L);
    }

    public static String formatUnixSeconds(long unixSec, String fmt) {
        return Times.formatUnixSeconds(unixSec, Times.createDateFormat(fmt));
    }

    public static DateFormat createDateFormat(String pattern) {
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(UTC);
        fmt.setCalendar(Times.createCalendar());
        return fmt;
    }

    public static int secToYear(long sec) {
        Calendar cal = Times.createCalendar();
        cal.setTimeInMillis(1000L * sec);
        return cal.get(1);
    }

    public static long yearToSec(int year) {
        Calendar cal = Times.createCalendar();
        cal.clear();
        cal.set(1, year);
        return cal.getTimeInMillis() / 1000L;
    }

    private static Calendar createCalendar() {
        GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
        cal.setLenient(true);
        return cal;
    }
}

