/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializerConfig;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.CountCheckRowSequence;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.util.BufferedBase64OutputStream;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.Encoder;
import uk.ac.starlink.votable.FlagIO;
import uk.ac.starlink.votable.StringElementSizer;
import uk.ac.starlink.votable.UnifiedFitsTableWriter;
import uk.ac.starlink.votable.VOSerializerConfig;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.datalink.ExampleUrl;
import uk.ac.starlink.votable.datalink.ServiceDescriptor;
import uk.ac.starlink.votable.datalink.ServiceParam;

public abstract class VOSerializer {
    private final StarTable table_;
    private final DataFormat format_;
    private final VOTableVersion version_;
    private final List<DescribedValue> paramList_;
    private final String ucd_;
    private final String utype_;
    private final String description_;
    private final ServiceDescriptor[] servDescrips_;
    final Map<MetaEl, String> coosysMap_;
    final Map<MetaEl, String> timesysMap_;
    private boolean isCompact_;
    static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    private static final AtomicLong idSeq_ = new AtomicLong();
    private static final String NL_STRING = VOSerializer.getNewline();
    private static final byte[] NL_BYTES = VOSerializer.toAsciiBytes(NL_STRING);
    private static final byte[] LT_BYTES = VOSerializer.toAsciiBytes("&lt;");
    private static final byte[] GT_BYTES = VOSerializer.toAsciiBytes("&gt;");
    private static final byte[] AMP_BYTES = VOSerializer.toAsciiBytes("&amp;");

    private VOSerializer(StarTable table, DataFormat format, VOTableVersion version) {
        this.table_ = table;
        this.format_ = format;
        this.version_ = version;
        this.paramList_ = new ArrayList<DescribedValue>();
        String description = null;
        String ucd = null;
        String utype = null;
        ArrayList<ServiceDescriptor> sdList = new ArrayList<ServiceDescriptor>();
        for (DescribedValue dval : table.getParameters()) {
            ValueInfo pinfo = dval.getInfo();
            String pname = pinfo.getName();
            Class<?> pclazz = pinfo.getContentClass();
            Object value = dval.getValue();
            if (pname == null || pclazz == null) continue;
            if (pname.equalsIgnoreCase("description") && pclazz == String.class) {
                description = (String)value;
                continue;
            }
            if (pname.equals(VOStarTable.UCD_INFO.getName()) && pclazz == String.class) {
                ucd = (String)value;
                continue;
            }
            if (pname.equals(VOStarTable.UTYPE_INFO.getName()) && pclazz == String.class) {
                utype = (String)value;
                continue;
            }
            if (ServiceDescriptor.class.isAssignableFrom(pclazz)) {
                if (!(value instanceof ServiceDescriptor)) continue;
                sdList.add((ServiceDescriptor)value);
                continue;
            }
            this.paramList_.add(dval);
        }
        this.description_ = description;
        this.ucd_ = ucd;
        this.utype_ = utype;
        this.servDescrips_ = sdList.toArray(new ServiceDescriptor[0]);
        String baseId = "t" + Long.toString(idSeq_.incrementAndGet());
        this.coosysMap_ = new LinkedHashMap<MetaEl, String>();
        this.timesysMap_ = new LinkedHashMap<MetaEl, String>();
        int ncol = table.getColumnCount();
        int ics = 0;
        int its = 0;
        ArrayList<ValueInfo> infos = new ArrayList<ValueInfo>();
        for (int ic = 0; ic < ncol; ++ic) {
            infos.add(table.getColumnInfo(ic));
        }
        for (DescribedValue dval : table.getParameters()) {
            infos.add(dval.getInfo());
        }
        for (ValueInfo info : infos) {
            MetaEl timesys;
            MetaEl coosys = VOSerializer.getCoosys(info, version);
            if (coosys != null && !this.coosysMap_.containsKey(coosys)) {
                String id = baseId + "-coosys-" + ++ics;
                this.coosysMap_.put(coosys, id);
            }
            if (!version.allowTimesys() || (timesys = VOSerializer.getTimesys(info)) == null || this.timesysMap_.containsKey(timesys)) continue;
            String id = baseId + "-timesys-" + ++its;
            this.timesysMap_.put(timesys, id);
        }
    }

    public DataFormat getFormat() {
        return this.format_;
    }

    public StarTable getTable() {
        return this.table_;
    }

    public VOTableVersion getVersion() {
        return this.version_;
    }

    public void setCompact(boolean isCompact) {
        this.isCompact_ = isCompact;
    }

    public boolean isCompact() {
        return this.isCompact_;
    }

    public abstract void writeFields(BufferedWriter var1) throws IOException;

    public abstract void writeInlineDataElement(BufferedWriter var1) throws IOException;

    public abstract void writeInlineDataElementUTF8(OutputStream var1) throws IOException;

    public abstract void writeHrefDataElement(BufferedWriter var1, String var2, OutputStream var3) throws IOException;

    public void writeInlineTableElement(BufferedWriter writer) throws IOException {
        this.writePreDataXML(writer);
        this.writeInlineDataElement(writer);
        this.writePostDataXML(writer);
    }

    public void writeInlineTableElementUTF8(OutputStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.writePreDataXML(bw);
        bw.flush();
        this.writeInlineDataElementUTF8(out);
        this.writePostDataXML(bw);
        bw.flush();
    }

    public void writeHrefTableElement(BufferedWriter xmlwriter, String href, OutputStream streamout) throws IOException {
        this.writePreDataXML(xmlwriter);
        this.writeHrefDataElement(xmlwriter, href, streamout);
        this.writePostDataXML(xmlwriter);
    }

    public void writeParams(BufferedWriter writer) throws IOException {
        for (DescribedValue param : this.paramList_) {
            int[] shape;
            ValueInfo pinfo0 = param.getInfo();
            DefaultValueInfo pinfo = new DefaultValueInfo(pinfo0);
            Object pvalue = param.getValue();
            if (pinfo.isArray() && (shape = pinfo.getShape()) != null && shape.length > 0 && shape[shape.length - 1] < 0 && pvalue != null && pvalue.getClass().isArray()) {
                long block = 1L;
                for (int idim = 0; idim < shape.length - 1 && block >= 1L; block *= (long)shape[idim], ++idim) {
                }
                int leng = Array.getLength(pvalue);
                if (block <= Integer.MAX_VALUE && (long)leng % block == 0L) {
                    shape[shape.length - 1] = leng / (int)block;
                    pinfo.setShape(shape);
                }
            }
            if (String.class.equals(pinfo.getContentClass()) && pinfo.getElementSize() < 0 && pvalue instanceof String) {
                pinfo.setElementSize(((String)pvalue).length());
            }
            if (String[].class.equals(pinfo.getContentClass()) && pinfo.getElementSize() < 0 && pvalue instanceof String[]) {
                int leng = 0;
                String[] strs = (String[])pvalue;
                for (int is = 0; is < strs.length; ++is) {
                    if (strs[is] == null) continue;
                    leng = Math.max(leng, strs[is].length());
                }
                pinfo.setElementSize(leng);
            }
            pinfo.setNullable(Tables.isBlank(pvalue));
            Encoder encoder = Encoder.getEncoder(pinfo, false, false);
            if (encoder != null) {
                String valtext = encoder.encodeAsText(pvalue);
                String content = encoder.getFieldContent();
                LinkedHashMap<String, String> attMap = new LinkedHashMap<String, String>();
                attMap.putAll(VOSerializer.getFieldAttributes(encoder, this.version_, this.coosysMap_, this.timesysMap_));
                attMap.put("value", valtext);
                writer.write("<PARAM");
                writer.write(VOSerializer.formatAttributes(attMap));
                if (content.length() > 0) {
                    writer.write(">");
                    writer.write(content);
                    writer.newLine();
                    writer.write("</PARAM>");
                } else {
                    writer.write("/>");
                }
                writer.newLine();
                continue;
            }
            if (pvalue instanceof URL) {
                writer.write("<LINK" + VOSerializer.formatAttribute("title", pinfo.getName()) + VOSerializer.formatAttribute("href", pvalue.toString()) + "/>");
                writer.newLine();
                continue;
            }
            writer.write("<INFO");
            writer.write(VOSerializer.formatAttribute("name", pinfo.getName()));
            if (pvalue != null) {
                writer.write(VOSerializer.formatAttribute("value", pvalue.toString()));
            }
            writer.write("/>");
            writer.newLine();
        }
    }

    public void writeDescription(BufferedWriter writer) throws IOException {
        if (this.description_ != null && this.description_.trim().length() > 0) {
            writer.write("<DESCRIPTION>");
            writer.newLine();
            writer.write(VOSerializer.formatText(this.description_.trim()));
            writer.newLine();
            writer.write("</DESCRIPTION>");
            writer.newLine();
        }
    }

    public void writeServiceDescriptors(BufferedWriter writer) throws IOException {
        for (ServiceDescriptor sd : this.servDescrips_) {
            this.writeServiceDescriptor(writer, sd);
        }
    }

    private void writeServiceDescriptor(BufferedWriter writer, ServiceDescriptor sdesc) throws IOException {
        String sdId = sdesc.getDescriptorId();
        String sdName = sdesc.getName();
        String sdDescription = sdesc.getDescription();
        StringBuffer rtag = new StringBuffer().append("<RESOURCE").append(VOSerializer.formatAttribute("type", "meta")).append(VOSerializer.formatAttribute("utype", "adhoc:service"));
        if (sdName != null) {
            rtag.append(VOSerializer.formatAttribute("name", sdName));
        }
        if (sdId != null && sdId.length() > 0) {
            rtag.append(VOSerializer.formatAttribute("ID", sdId));
        }
        rtag.append(">");
        writer.write(rtag.toString());
        writer.newLine();
        if (sdDescription != null) {
            writer.write("  <DESCRIPTION>" + VOSerializer.formatText(sdDescription.trim()) + "</DESCRIPTION>");
            writer.newLine();
        }
        this.writeStringParam(writer, "accessURL", sdesc.getAccessUrl());
        this.writeStringParam(writer, "standardID", sdesc.getStandardId());
        this.writeStringParam(writer, "resourceIdentifier", sdesc.getResourceIdentifier());
        this.writeStringParam(writer, "contentType", sdesc.getContentType());
        ServiceParam[] sdParams = sdesc.getInputParams();
        if (sdParams.length > 0) {
            writer.write("  <GROUP" + VOSerializer.formatAttribute("name", "inputParams") + ">");
            writer.newLine();
            for (ServiceParam sdParam : sdParams) {
                this.writeServiceParam(writer, sdParam);
            }
            writer.write("  </GROUP>");
            writer.newLine();
        }
        for (ExampleUrl exampleUrl : sdesc.getExampleUrls()) {
            this.writeStringParam(writer, "exampleURL", exampleUrl.getUrl(), exampleUrl.getDescription());
        }
        writer.write("</RESOURCE>");
        writer.newLine();
    }

    private void writeStringParam(BufferedWriter writer, String pname, String pvalue) throws IOException {
        this.writeStringParam(writer, pname, pvalue, null);
    }

    private void writeStringParam(BufferedWriter writer, String pname, String pvalue, String description) throws IOException {
        if (pvalue != null && pvalue.length() > 0) {
            StringBuffer sbuf = new StringBuffer().append("  <PARAM").append(VOSerializer.formatAttribute("name", pname)).append(VOSerializer.formatAttribute("datatype", "char")).append(VOSerializer.formatAttribute("arraysize", "*")).append(VOSerializer.formatAttribute("value", pvalue));
            if (description != null && description.trim().length() > 0) {
                sbuf.append(">").append("<DESCRIPTION>").append(VOSerializer.formatText(description)).append("</DESCRIPTION>").append("</PARAM>");
            } else {
                sbuf.append("/>");
            }
            writer.write(sbuf.toString());
            writer.newLine();
        }
    }

    private void writeServiceParam(BufferedWriter writer, ServiceParam param) throws IOException {
        String max;
        int[] arraysize = param.getArraysize();
        String name = param.getName();
        String datatype = param.getDatatype();
        String value = param.getValue();
        LinkedHashMap<String, String> atts = new LinkedHashMap<String, String>();
        atts.put("name", name == null ? "??" : name);
        atts.put("datatype", datatype == null ? "char" : datatype);
        if (arraysize != null && arraysize.length > 0) {
            atts.put("arraysize", DefaultValueInfo.formatShape(arraysize));
        }
        atts.put("value", value == null ? "" : value);
        atts.put("unit", param.getUnit());
        atts.put("ucd", param.getUcd());
        atts.put("utype", param.getUtype());
        atts.put("xtype", param.getXtype());
        atts.put("ref", param.getRef());
        for (String aname : new String[]{"unit", "ucd", "utype", "xtype", "ref"}) {
            String aval = (String)atts.get(aname);
            if (aval != null && aval.length() != 0) continue;
            atts.remove(aname);
        }
        writer.write("    <PARAM" + VOSerializer.formatAttributes(atts) + ">");
        writer.newLine();
        String descrip = param.getDescription();
        if (descrip != null && descrip.trim().length() > 0) {
            writer.write("      <DESCRIPTION>" + VOSerializer.formatText(descrip) + "</DESCRIPTION>");
            writer.newLine();
        }
        String[] options = param.getOptions();
        String[] minmax = param.getMinMax();
        String min = minmax == null ? null : minmax[0];
        String string = max = minmax == null ? null : minmax[1];
        if (min != null || max != null || options != null) {
            writer.write("      <VALUES>");
            writer.newLine();
            if (min != null) {
                writer.write("        <MIN" + VOSerializer.formatAttribute("value", min) + "/>");
                writer.newLine();
            }
            if (max != null) {
                writer.write("        <MAX" + VOSerializer.formatAttribute("value", max) + "/>");
                writer.newLine();
            }
            if (options != null) {
                for (String opt : options) {
                    writer.write("        <OPTION" + VOSerializer.formatAttribute("value", opt) + "/>");
                    writer.newLine();
                }
            }
            writer.write("      </VALUES>");
            writer.newLine();
        }
        writer.write("    </PARAM>");
        writer.newLine();
    }

    public void writePreDataXML(BufferedWriter writer) throws IOException {
        long nrow;
        if (this.coosysMap_.size() + this.timesysMap_.size() > 0) {
            writer.write("<RESOURCE>");
            writer.newLine();
            LinkedHashMap<MetaEl, String> metamap = new LinkedHashMap<MetaEl, String>();
            metamap.putAll(this.coosysMap_);
            metamap.putAll(this.timesysMap_);
            for (Map.Entry entry : metamap.entrySet()) {
                MetaEl meta = (MetaEl)entry.getKey();
                String id = (String)entry.getValue();
                writer.write("  " + meta.toXml(id));
                writer.newLine();
            }
            writer.write("</RESOURCE>");
            writer.newLine();
        }
        writer.write("<TABLE");
        String tname = this.getTable().getName();
        if (tname != null && tname.trim().length() > 0) {
            writer.write(VOSerializer.formatAttribute("name", tname.trim()));
        }
        if ((nrow = this.getRowCount()) > 0L) {
            writer.write(VOSerializer.formatAttribute("nrows", Long.toString(nrow)));
        }
        if (this.ucd_ != null) {
            writer.write(VOSerializer.formatAttribute("ucd", this.ucd_));
        }
        if (this.utype_ != null) {
            writer.write(VOSerializer.formatAttribute("utype", this.utype_));
        }
        writer.write(">");
        writer.newLine();
        this.writeDescription(writer);
        this.writeParams(writer);
        this.writeFields(writer);
    }

    public void writePostDataXML(BufferedWriter writer) throws IOException {
        writer.write("</TABLE>");
        writer.newLine();
        this.writeServiceDescriptors(writer);
    }

    public long getRowCount() {
        return this.getTable().getRowCount();
    }

    public RowSequence getRowSequence() throws IOException {
        StarTable table = this.getTable();
        return CountCheckRowSequence.getSafeRowSequence(table.getRowSequence(), table.getColumnCount(), this.getRowCount());
    }

    public static String formatAttribute(String name, String value) {
        char c;
        int i;
        int vleng = value.length();
        StringBuffer buf = new StringBuffer(name.length() + vleng + 4);
        buf.append(' ').append(name).append('=').append('\"');
        int nquot = 0;
        int napos = 0;
        block13: for (i = 0; i < vleng; ++i) {
            c = value.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block13;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block13;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block13;
                }
                case '\"': {
                    buf.append("&quot;");
                    ++nquot;
                    continue block13;
                }
                case '\'': {
                    ++napos;
                    buf.append(VOSerializer.ensureLegalXml(c));
                    continue block13;
                }
                default: {
                    buf.append(VOSerializer.ensureLegalXml(c));
                }
            }
        }
        buf.append('\"');
        if (nquot <= napos) {
            return buf.toString();
        }
        buf.setLength(0);
        buf.append(' ').append(name).append('=').append('\'');
        block14: for (i = 0; i < vleng; ++i) {
            c = value.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block14;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block14;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block14;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block14;
                }
                default: {
                    buf.append(VOSerializer.ensureLegalXml(c));
                }
            }
        }
        buf.append('\'');
        return buf.toString();
    }

    public static String formatText(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        block5: for (int i = 0; i < leng; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block5;
                }
                default: {
                    sbuf.append(VOSerializer.ensureLegalXml(c));
                }
            }
        }
        return sbuf.toString();
    }

    private static void writeEscapedTextUTF8(String txt, DataBufferedOutputStream out) throws IOException {
        int leng = txt.length();
        block5: for (int i = 0; i < leng; ++i) {
            char c = txt.charAt(i);
            switch (c) {
                case '<': {
                    out.write(LT_BYTES);
                    continue block5;
                }
                case '>': {
                    out.write(GT_BYTES);
                    continue block5;
                }
                case '&': {
                    out.write(AMP_BYTES);
                    continue block5;
                }
                default: {
                    out.writeCharUTF8(VOSerializer.ensureLegalXml(c));
                }
            }
        }
    }

    private static byte[] toAsciiBytes(String txt) {
        int leng = txt.length();
        byte[] buf = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            buf[i] = (byte)txt.charAt(i);
        }
        return buf;
    }

    private static String getNewline() {
        try {
            return System.getProperty("line.separator");
        }
        catch (Throwable e) {
            return "\n";
        }
    }

    public static char ensureLegalXml(char c) {
        return (char)(c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c == 9 || c == 10 || c == 13 ? c : 191);
    }

    private static String formatAttributes(Map<String, String> atts) {
        StringBuffer sbuf = new StringBuffer();
        for (String attname : new TreeSet<String>(atts.keySet())) {
            String attval = atts.get(attname);
            sbuf.append(VOSerializer.formatAttribute(attname, attval));
        }
        return sbuf.toString();
    }

    private static void writeFieldElement(BufferedWriter writer, String content, Map<String, String> attributes) throws IOException {
        writer.write("<FIELD" + VOSerializer.formatAttributes(attributes));
        if (content != null && content.length() > 0) {
            writer.write(62);
            writer.write(content);
            writer.newLine();
            writer.write("</FIELD>");
        } else {
            writer.write("/>");
        }
        writer.newLine();
    }

    private static StarTable prepareForSerializer(StarTable table, boolean magicNulls, boolean allowXtype, StringElementSizer stringSizer) throws IOException {
        ValueInfo badKey = Tables.NULL_VALUE_INFO;
        ValueInfo ubyteKey = Tables.UBYTE_FLAG_INFO;
        int ncol = table.getColumnCount();
        final ColumnInfo[] colInfos = new ColumnInfo[ncol];
        int modified = 0;
        IntList varStringArrayIcols = new IntList();
        for (int icol = 0; icol < ncol; ++icol) {
            String xt;
            DescribedValue nv;
            Number badValue;
            ColumnInfo cinfo = new ColumnInfo(table.getColumnInfo(icol));
            boolean isUbyte = Boolean.TRUE.equals(cinfo.getAuxDatumValue(ubyteKey, Boolean.class));
            Class<?> clazz = cinfo.getContentClass();
            if (magicNulls && cinfo.isNullable() && Number.class.isAssignableFrom(clazz) && cinfo.getAuxDatum(badKey) == null && (badValue = isUbyte ? (Number)((short)255) : (Number)(clazz == Byte.class || clazz == Short.class ? (Number)((short)Short.MIN_VALUE) : (Number)(clazz == Integer.class ? (Number)Integer.MIN_VALUE : (Number)(clazz == Long.class ? Long.valueOf(Long.MIN_VALUE) : null)))) != null) {
                ++modified;
                cinfo.getAuxData().add(new DescribedValue(badKey, badValue));
            }
            if (!magicNulls && !cinfo.isArray() && (nv = cinfo.getAuxDatum(badKey)) != null) {
                cinfo.getAuxData().remove(nv);
                ++modified;
            }
            if (!allowXtype && (xt = cinfo.getXtype()) != null) {
                cinfo.setXtype(null);
                ++modified;
            }
            if (String[].class.equals(clazz) && cinfo.getElementSize() < 0) {
                varStringArrayIcols.add(icol);
            }
            colInfos[icol] = cinfo;
        }
        if (varStringArrayIcols.size() > 0) {
            int[] vsaIcols = varStringArrayIcols.toIntArray();
            int[] elSizes = stringSizer.calculateStringArrayElementSizes(table, vsaIcols);
            for (int i = 0; i < vsaIcols.length; ++i) {
                int icol = vsaIcols[i];
                ColumnInfo cinfo = table.getColumnInfo(icol);
                if (elSizes[i] == cinfo.getElementSize()) continue;
                ColumnInfo cinfo1 = new ColumnInfo(cinfo);
                cinfo1.setElementSize(elSizes[i]);
                colInfos[icol] = cinfo1;
                ++modified;
            }
        }
        if (modified > 0) {
            table = new WrapperStarTable(table){

                @Override
                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
        }
        return table;
    }

    @Deprecated
    public static VOSerializer makeSerializer(DataFormat dataFormat, StarTable table) throws IOException {
        VOSerializerConfig config = new VOSerializerConfig(dataFormat, VOTableVersion.getDefaultVersion(), StringElementSizer.NOCALC);
        return VOSerializer.makeSerializer(config, table);
    }

    @Deprecated
    public static VOSerializer makeSerializer(DataFormat dataFormat, VOTableVersion version, StarTable table) throws IOException {
        VOSerializerConfig config = new VOSerializerConfig(dataFormat, version, StringElementSizer.NOCALC);
        return VOSerializer.makeSerializer(config, table);
    }

    public static VOSerializer makeSerializer(VOSerializerConfig config, StarTable table) throws IOException {
        DataFormat dataFormat = config.getDataFormat();
        VOTableVersion version = config.getVersion();
        StringElementSizer stringSizer = config.getStringSizer();
        boolean magicNulls = dataFormat == DataFormat.BINARY || dataFormat == DataFormat.FITS || dataFormat == DataFormat.TABLEDATA && !version.allowEmptyTd();
        table = VOSerializer.prepareForSerializer(table, magicNulls, version.allowXtype(), stringSizer);
        if (dataFormat == DataFormat.TABLEDATA) {
            TabledataVOSerializer tdser = new TabledataVOSerializer(table, version, magicNulls);
            tdser.setCompact(table.getColumnCount() <= 4);
            return tdser;
        }
        if (dataFormat == DataFormat.FITS) {
            FitsTableSerializerConfig fitsConfig = new FitsTableSerializerConfig(){

                @Override
                public boolean allowSignedByte() {
                    return false;
                }

                @Override
                public WideFits getWide() {
                    return null;
                }

                @Override
                public boolean allowZeroLengthString() {
                    return false;
                }

                @Override
                public byte getPadCharacter() {
                    return 0;
                }
            };
            return new FITSVOSerializer(table, version, new StandardFitsTableSerializer(fitsConfig, table));
        }
        if (dataFormat == DataFormat.BINARY) {
            return new BinaryVOSerializer(table, version, magicNulls);
        }
        if (dataFormat == DataFormat.BINARY2) {
            if (version.allowBinary2()) {
                return new Binary2VOSerializer(table, version, magicNulls);
            }
            throw new IllegalArgumentException("BINARY2 format not legal for VOTable " + version);
        }
        throw new AssertionError((Object)("No such format " + dataFormat.toString()));
    }

    public static VOSerializer makeFitsSerializer(StarTable table, final FitsTableSerializer fitser, VOTableVersion version) throws IOException {
        boolean magicNulls = false;
        boolean allowXtype = true;
        StringElementSizer stringSizer = new StringElementSizer(){

            @Override
            public int[] calculateStringArrayElementSizes(StarTable table, int[] icols) {
                int[] elSizes = new int[icols.length];
                for (int i = 0; i < icols.length; ++i) {
                    int[] shape = fitser.getDimensions(icols[i]);
                    elSizes[i] = shape[0];
                }
                return elSizes;
            }
        };
        table = VOSerializer.prepareForSerializer(table, magicNulls, allowXtype, stringSizer);
        return new FITSVOSerializer(table, version, fitser);
    }

    private static Encoder[] getEncoders(StarTable table, boolean magicNulls) {
        int ncol = table.getColumnCount();
        Encoder[] encoders = new Encoder[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            boolean isUnicode = "unicodeChar".equals(info.getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class));
            encoders[icol] = Encoder.getEncoder(info, magicNulls, isUnicode);
            if (encoders[icol] != null) continue;
            logger.warning("Can't serialize column " + info + " of type " + info.getContentClass().getName());
        }
        return encoders;
    }

    private static void outputFields(Encoder[] encoders, StarTable table, VOTableVersion version, Map<MetaEl, String> coosysMap, Map<MetaEl, String> timesysMap, BufferedWriter writer) throws IOException {
        int ncol = encoders.length;
        for (int icol = 0; icol < ncol; ++icol) {
            Encoder encoder = encoders[icol];
            if (encoder != null) {
                String content = encoder.getFieldContent();
                Map<String, String> atts = VOSerializer.getFieldAttributes(encoder, version, coosysMap, timesysMap);
                VOSerializer.writeFieldElement(writer, content, atts);
                continue;
            }
            writer.write("<!-- Omitted column " + table.getColumnInfo(icol) + " -->");
            writer.newLine();
        }
    }

    private static Map<String, String> getFieldAttributes(Encoder encoder, VOTableVersion version, Map<MetaEl, String> coosysMap, Map<MetaEl, String> timesysMap) {
        String tsId;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(encoder.getFieldAttributes());
        ValueInfo info = encoder.getInfo();
        MetaEl coosys = VOSerializer.getCoosys(info, version);
        MetaEl timesys = VOSerializer.getTimesys(info);
        String csId = coosysMap != null ? coosysMap.get(coosys) : null;
        String string = tsId = timesysMap != null ? timesysMap.get(timesys) : null;
        if (csId != null) {
            map.put("ref", csId);
        } else if (tsId != null) {
            map.put("ref", tsId);
        }
        if (version.forbidArraysize1() && "1".equals(map.get("arraysize"))) {
            map.remove("arraysize");
        }
        return map;
    }

    private static MetaEl getCoosys(ValueInfo info, VOTableVersion version) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        VOSerializer.addAtt(map, info, VOStarTable.COOSYS_SYSTEM_INFO, "system");
        VOSerializer.addAtt(map, info, VOStarTable.COOSYS_EPOCH_INFO, "epoch");
        if (version.allowCoosysRefposition()) {
            VOSerializer.addAtt(map, info, VOStarTable.COOSYS_REFPOSITION_INFO, "refposition");
        }
        VOSerializer.addAtt(map, info, VOStarTable.COOSYS_EQUINOX_INFO, "equinox");
        return map.size() > 0 ? new MetaEl("COOSYS", map) : null;
    }

    private static MetaEl getTimesys(ValueInfo info) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        VOSerializer.addAtt(map, info, VOStarTable.TIMESYS_TIMEORIGIN_INFO, "timeorigin");
        VOSerializer.addAtt(map, info, VOStarTable.TIMESYS_TIMESCALE_INFO, "timescale");
        VOSerializer.addAtt(map, info, VOStarTable.TIMESYS_REFPOSITION_INFO, "refposition");
        return map.size() > 0 ? new MetaEl("TIMESYS", map) : null;
    }

    private static void addAtt(Map<String, String> map, ValueInfo info, ValueInfo auxKey, String attname) {
        String value;
        DescribedValue dval = info.getAuxDatumByName(auxKey.getName());
        if (dval != null && (value = dval.getTypedValue(String.class)) != null && value.trim().length() > 0) {
            map.put(attname, value);
        }
    }

    private static class MetaEl {
        private final String elName_;
        private final Map<String, String> attMap_;

        MetaEl(String elName, Map<String, String> attMap) {
            this.elName_ = elName;
            this.attMap_ = Collections.unmodifiableMap(attMap);
        }

        public String toXml(String id) {
            return new StringBuffer().append("<").append(this.elName_).append(VOSerializer.formatAttribute("ID", id)).append(VOSerializer.formatAttributes(this.attMap_)).append("/>").toString();
        }

        public int hashCode() {
            int code = 442041;
            code = 23 * code + this.elName_.hashCode();
            code = 23 * code + this.attMap_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof MetaEl) {
                MetaEl other = (MetaEl)o;
                return this.elName_.equals(other.elName_) && this.attMap_.equals(other.attMap_);
            }
            return false;
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        Writer writer;
        static final int BUFLENG = 10240;
        char[] mainBuf = new char[10240];

        WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            char[] buf = len <= 10240 ? this.mainBuf : new char[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = (char)b[off++];
            }
            this.writer.write(buf, 0, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }

    private static class FITSVOSerializer
    extends StreamableVOSerializer {
        private final FitsTableSerializer fitser;

        FITSVOSerializer(StarTable table, VOTableVersion version, FitsTableSerializer fitser) throws IOException {
            super(table, DataFormat.FITS, version, "FITS");
            this.fitser = fitser;
        }

        @Override
        public long getRowCount() {
            return this.fitser.getRowCount();
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            int ncol = this.getTable().getColumnCount();
            for (int icol = 0; icol < ncol; ++icol) {
                char tform = this.fitser.getFormatChar(icol);
                int[] dims = this.fitser.getDimensions(icol);
                String badval = this.fitser.getBadValue(icol);
                if (dims != null) {
                    String datatype;
                    Encoder encoder = Encoder.getEncoder(this.getTable().getColumnInfo(icol), true, false);
                    String content = encoder.getFieldContent();
                    Map atts = VOSerializer.getFieldAttributes(encoder, this.getVersion(), this.coosysMap_, this.timesysMap_);
                    switch (tform) {
                        case 'L': {
                            datatype = "boolean";
                            break;
                        }
                        case 'X': {
                            datatype = "bit";
                            break;
                        }
                        case 'B': {
                            datatype = "unsignedByte";
                            break;
                        }
                        case 'I': {
                            datatype = "short";
                            break;
                        }
                        case 'J': {
                            datatype = "int";
                            break;
                        }
                        case 'K': {
                            datatype = "long";
                            break;
                        }
                        case 'A': {
                            datatype = "char";
                            break;
                        }
                        case 'E': {
                            datatype = "float";
                            break;
                        }
                        case 'D': {
                            datatype = "double";
                            break;
                        }
                        case 'C': {
                            datatype = "floatComplex";
                            break;
                        }
                        case 'M': {
                            datatype = "doubleComplex";
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown format letter " + tform));
                        }
                    }
                    atts.put("datatype", datatype);
                    if (dims.length == 0) {
                        if (!"1".equals(atts.get("arraysize"))) {
                            atts.remove("arraysize");
                        }
                    } else {
                        StringBuffer arraysize = new StringBuffer();
                        for (int i = 0; i < dims.length; ++i) {
                            if (i > 0) {
                                arraysize.append('x');
                            }
                            arraysize.append(dims[i]);
                        }
                        atts.put("arraysize", arraysize.toString());
                    }
                    encoder.setNullString(badval);
                    VOSerializer.writeFieldElement(writer, content, atts);
                    continue;
                }
                writer.write("<!-- Omitted column " + this.getTable().getColumnInfo(icol) + " -->");
                writer.newLine();
            }
        }

        @Override
        public void streamData(OutputStream out) throws IOException {
            FitsUtil.writeEmptyPrimary(out);
            new UnifiedFitsTableWriter().writeTableHDU(this.getTable(), this.fitser, out);
        }
    }

    private static class Binary2VOSerializer
    extends StreamableVOSerializer {
        private final Encoder[] encoders;

        Binary2VOSerializer(StarTable table, VOTableVersion version, boolean magicNulls) {
            super(table, DataFormat.BINARY2, version, "BINARY2");
            this.encoders = VOSerializer.getEncoders(table, magicNulls);
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), this.getVersion(), this.coosysMap_, this.timesysMap_, writer);
        }

        @Override
        public void streamData(OutputStream out) throws IOException {
            IntList icolList = new IntList(this.encoders.length);
            for (int icol = 0; icol < this.encoders.length; ++icol) {
                if (this.encoders[icol] == null) continue;
                icolList.add(icol);
            }
            int[] icols = icolList.toIntArray();
            int ncol = icols.length;
            boolean[] nullFlags = new boolean[ncol];
            DataBufferedOutputStream dout = new DataBufferedOutputStream(out);
            try (RowSequence rseq = this.getRowSequence();){
                while (rseq.next()) {
                    Object cell;
                    int icol;
                    int jcol;
                    Object[] row = rseq.getRow();
                    for (jcol = 0; jcol < ncol; ++jcol) {
                        icol = icols[jcol];
                        cell = row[icol];
                        nullFlags[jcol] = cell == null;
                    }
                    FlagIO.writeFlags(dout, nullFlags);
                    for (jcol = 0; jcol < ncol; ++jcol) {
                        icol = icols[jcol];
                        cell = row[icol];
                        this.encoders[icol].encodeToStream(cell, dout);
                    }
                }
            }
            dout.flush();
        }
    }

    private static class BinaryVOSerializer
    extends StreamableVOSerializer {
        private final Encoder[] encoders;

        BinaryVOSerializer(StarTable table, VOTableVersion version, boolean magicNulls) {
            super(table, DataFormat.BINARY, version, "BINARY");
            this.encoders = VOSerializer.getEncoders(table, magicNulls);
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), this.getVersion(), this.coosysMap_, this.timesysMap_, writer);
        }

        @Override
        public void streamData(OutputStream out) throws IOException {
            int ncol = this.encoders.length;
            DataBufferedOutputStream dout = new DataBufferedOutputStream(out);
            try (RowSequence rseq = this.getRowSequence();){
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        encoder.encodeToStream(row[icol], dout);
                    }
                }
            }
            dout.flush();
        }
    }

    static abstract class StreamableVOSerializer
    extends VOSerializer {
        private final String tagname;

        private StreamableVOSerializer(StarTable table, DataFormat format, VOTableVersion version, String tagname) {
            super(table, format, version);
            this.tagname = tagname;
        }

        public abstract void streamData(OutputStream var1) throws IOException;

        @Override
        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<" + this.tagname + ">");
            writer.newLine();
            writer.write("<STREAM encoding='base64'>");
            writer.newLine();
            BufferedBase64OutputStream b64out = new BufferedBase64OutputStream(new WriterOutputStream(writer));
            this.streamData(b64out);
            b64out.endBase64();
            writer.write("</STREAM>");
            writer.newLine();
            writer.write("</" + this.tagname + ">");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
        }

        @Override
        public void writeInlineDataElementUTF8(OutputStream out) throws IOException {
            out.write(VOSerializer.toAsciiBytes("<DATA>"));
            out.write(NL_BYTES);
            out.write(VOSerializer.toAsciiBytes("<" + this.tagname + ">"));
            out.write(NL_BYTES);
            out.write(VOSerializer.toAsciiBytes("<STREAM encoding='base64'>"));
            out.write(NL_BYTES);
            BufferedBase64OutputStream b64out = new BufferedBase64OutputStream(out);
            this.streamData(b64out);
            b64out.endBase64();
            out.write(VOSerializer.toAsciiBytes("</STREAM>"));
            out.write(NL_BYTES);
            out.write(VOSerializer.toAsciiBytes("</" + this.tagname + ">"));
            out.write(NL_BYTES);
            out.write(VOSerializer.toAsciiBytes("</DATA>"));
            out.write(NL_BYTES);
        }

        @Override
        public void writeHrefDataElement(BufferedWriter xmlwriter, String href, OutputStream streamout) throws IOException {
            xmlwriter.write("<DATA>");
            xmlwriter.newLine();
            xmlwriter.write('<' + this.tagname + '>');
            xmlwriter.newLine();
            xmlwriter.write("<STREAM" + StreamableVOSerializer.formatAttribute("href", href) + "/>");
            xmlwriter.newLine();
            xmlwriter.write("</" + this.tagname + ">");
            xmlwriter.newLine();
            xmlwriter.write("</DATA>");
            xmlwriter.newLine();
            this.streamData(streamout);
        }
    }

    private static class TabledataVOSerializer
    extends VOSerializer {
        private final Encoder[] encoders;

        TabledataVOSerializer(StarTable table, VOTableVersion version, boolean magicNulls) {
            super(table, DataFormat.TABLEDATA, version);
            this.encoders = VOSerializer.getEncoders(table, magicNulls);
        }

        @Override
        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.getTable(), this.getVersion(), this.coosysMap_, this.timesysMap_, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<TABLEDATA>");
            writer.newLine();
            TdTags tdTags = new TdTags(this.isCompact());
            int ncol = this.encoders.length;
            try (RowSequence rseq = this.getRowSequence();){
                while (rseq.next()) {
                    writer.write(tdTags.preTr_);
                    Object[] rowdata = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        String text = encoder.encodeAsText(rowdata[icol]);
                        writer.write(tdTags.preTd_);
                        writer.write(TabledataVOSerializer.formatText(text));
                        writer.write(tdTags.postTd_);
                    }
                    writer.write(tdTags.postTr_);
                }
            }
            writer.write("</TABLEDATA>");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
            writer.flush();
        }

        @Override
        public void writeInlineDataElementUTF8(OutputStream out) throws IOException {
            DataBufferedOutputStream dout = new DataBufferedOutputStream(out);
            TdTags tdTags = new TdTags(this.isCompact());
            byte[] preTr = VOSerializer.toAsciiBytes(tdTags.preTr_);
            byte[] preTd = VOSerializer.toAsciiBytes(tdTags.preTd_);
            byte[] postTd = VOSerializer.toAsciiBytes(tdTags.postTd_);
            byte[] postTr = VOSerializer.toAsciiBytes(tdTags.postTr_);
            dout.writeBytes("<DATA>");
            dout.write(NL_BYTES);
            dout.writeBytes("<TABLEDATA>");
            dout.write(NL_BYTES);
            int ncol = this.encoders.length;
            try (RowSequence rseq = this.getRowSequence();){
                while (rseq.next()) {
                    dout.write(preTr);
                    Object[] rowdata = rseq.getRow();
                    for (int icol = 0; icol < ncol; ++icol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder == null) continue;
                        String text = encoder.encodeAsText(rowdata[icol]);
                        dout.write(preTd);
                        VOSerializer.writeEscapedTextUTF8(text, dout);
                        dout.write(postTd);
                    }
                    dout.write(postTr);
                }
            }
            dout.writeBytes("</TABLEDATA>");
            dout.write(NL_BYTES);
            dout.writeBytes("</DATA>");
            dout.write(NL_BYTES);
            dout.flush();
        }

        @Override
        public void writeHrefDataElement(BufferedWriter writer, String href, OutputStream streamout) {
            throw new UnsupportedOperationException("TABLEDATA only supports inline output");
        }

        private static class TdTags {
            final String preTr_;
            final String preTd_;
            final String postTd_;
            final String postTr_;

            TdTags(boolean isCompact) {
                if (isCompact) {
                    this.preTr_ = "<TR>";
                    this.preTd_ = "<TD>";
                    this.postTd_ = "</TD>";
                    this.postTr_ = "</TR>" + NL_STRING;
                } else {
                    this.preTr_ = "  <TR>" + NL_STRING;
                    this.preTd_ = "    <TD>";
                    this.postTd_ = "</TD>" + NL_STRING;
                    this.postTr_ = "  </TR>" + NL_STRING;
                }
            }
        }
    }
}

