/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.datalink;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.datalink.ExampleUrl;
import uk.ac.starlink.votable.datalink.ServiceDescriptor;
import uk.ac.starlink.votable.datalink.ServiceParam;

public class ServiceDescriptorInfo
extends DefaultValueInfo {
    final StarTable table_;

    public ServiceDescriptorInfo(String name, String description, StarTable table) {
        super(name, ServiceDescriptor.class, description == null ? "Datalink-style service descriptor" : description);
        this.table_ = table;
    }

    @Override
    public String formatValue(Object value, int maxLength) {
        if (value == null) {
            return null;
        }
        String txt = ServiceDescriptorInfo.formatDescriptor((ServiceDescriptor)value, this.table_);
        return txt.length() <= maxLength ? txt : txt.substring(0, maxLength - 3) + "...";
    }

    @Override
    public Object unformatString(String txt) {
        return null;
    }

    public static String formatDescriptor(ServiceDescriptor sd, StarTable table) {
        StringBuffer sbuf = new StringBuffer().append(ServiceDescriptorInfo.formatItem("ID", sd.getDescriptorId())).append(ServiceDescriptorInfo.formatItem("accessURL", sd.getAccessUrl())).append(ServiceDescriptorInfo.formatItem("standardId", sd.getStandardId())).append(ServiceDescriptorInfo.formatItem("resourceIdentifier", sd.getResourceIdentifier())).append(ServiceDescriptorInfo.formatItem("contentType", sd.getContentType()));
        for (ExampleUrl example : sd.getExampleUrls()) {
            sbuf.append(ServiceDescriptorInfo.formatItem("exampleURL", example.getUrl()));
        }
        sbuf.append("Input parameters:");
        for (ServiceParam param : sd.getInputParams()) {
            sbuf.append("\n").append("   ").append(param.getName()).append(" (");
            String ref = param.getRef();
            String value = param.getValue();
            if (ref != null) {
                sbuf.append("column=");
                int icol = VOStarTable.getRefColumnIndex(ref, table);
                if (icol >= 0) {
                    sbuf.append(table.getColumnInfo(icol).getName());
                } else {
                    sbuf.append("ID:").append(ref);
                }
            } else if (value != null && value.length() > 0) {
                sbuf.append("default=\"").append(value).append("\"");
            } else {
                sbuf.append("type=").append(param.getDatatype());
                int[] shape = param.getArraysize();
                if (shape != null && shape.length > 0) {
                    sbuf.append("[").append(DefaultValueInfo.formatShape(shape)).append("]");
                }
            }
            sbuf.append(")");
        }
        return sbuf.toString();
    }

    private static String formatItem(String name, String value) {
        return value == null || value.trim().length() == 0 ? "" : name + ":\n   " + value + "\n";
    }
}

