/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.AuthUtil;
import uk.ac.starlink.auth.BadChallengeException;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.ContextFactory;
import uk.ac.starlink.auth.IvoaLoginProtocol;
import uk.ac.starlink.auth.LoginProtocol;
import uk.ac.starlink.auth.UserInterface;
import uk.ac.starlink.auth.UserPass;

public abstract class IvoaAuthScheme
implements AuthScheme {
    private final String schemeName_;
    public static final String STANDARDID_PARAM = "standard_id";
    public static final String ACCESSURL_PARAM = "access_url";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.auth");

    protected IvoaAuthScheme(String schemeName) {
        this.schemeName_ = schemeName;
    }

    @Override
    public String getName() {
        return this.schemeName_;
    }

    @Override
    public ContextFactory createContextFactory(Challenge challenge, URL url) throws BadChallengeException {
        if (this.schemeName_.equalsIgnoreCase(challenge.getSchemeName())) {
            String stdId = challenge.getRequiredParameter(STANDARDID_PARAM);
            URL accUrl = challenge.getRequiredParameterUrl(ACCESSURL_PARAM);
            IvoaLoginProtocol loginProto = IvoaLoginProtocol.getProtocol(stdId);
            return loginProto == null ? null : this.createContextFactory(loginProto, accUrl, url);
        }
        return null;
    }

    protected abstract ContextFactory createContextFactory(LoginProtocol var1, URL var2, URL var3) throws BadChallengeException;

    public static HttpURLConnection getSuccessResponse(LoginProtocol loginProto, AuthScheme authScheme, URL loginUrl, UserInterface ui) throws IOException {
        String[] msgLines = new String[]{"Login URL: " + loginUrl, "Auth Scheme: " + authScheme.getName(), "Login Protocol: " + loginProto.getProtocolName()};
        do {
            String failMsg;
            UserPass userpass;
            if ((userpass = ui.readUserPassword(msgLines)) == null) {
                return null;
            }
            String username = userpass.getUsername();
            logger_.info("Attempt login as " + username + " at " + loginUrl + " (" + loginProto.getProtocolName() + ")");
            HttpURLConnection conn = loginProto.presentCredentials(loginUrl, userpass);
            int code = conn.getResponseCode();
            if (code == 200) {
                logger_.info("Login success for " + username);
                return conn;
            }
            if (code == 401 || code == 403) {
                failMsg = AuthUtil.authFailureMessage(conn);
                logger_.info("Login failure for " + username + ": " + code + " " + failMsg);
                if (!ui.canRetry()) {
                    throw new IOException("Login attempt failed: " + failMsg);
                }
            } else {
                failMsg = AuthUtil.authFailureMessage(conn);
                logger_.info("Login failure for " + username + ": " + code + " " + failMsg);
                throw new IOException("Login error: " + failMsg);
            }
            ui.message(new String[]{failMsg});
        } while (ui.canRetry());
        return null;
    }

    public static <A> A readAuth(LoginProtocol loginProto, AuthScheme authScheme, URL loginUrl, UserInterface ui, AuthReader<A> authReader) {
        HttpURLConnection conn;
        try {
            conn = IvoaAuthScheme.getSuccessResponse(loginProto, authScheme, loginUrl, ui);
        }
        catch (IOException e) {
            ui.message(new String[]{"Login communications failed: " + e});
            return null;
        }
        if (conn == null) {
            return null;
        }
        try {
            return authReader.readAuth(conn);
        }
        catch (IOException e) {
            ui.message(new String[]{"Login protocol failed: " + e});
            return null;
        }
    }

    @FunctionalInterface
    public static interface AuthReader<T> {
        public T readAuth(HttpURLConnection var1) throws IOException;
    }
}

