/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

class TableSorter {
    TableSorter() {
    }

    public static long[] getSortedOrder(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
        if (!table.isRandom()) {
            throw new IOException("Table does not have random access");
        }
        int nrow = Tables.checkedLongToInt(table.getRowCount());
        Number[] rowMap = new Number[nrow];
        for (int i = 0; i < nrow; ++i) {
            rowMap[i] = i;
        }
        RowComparator comp = new RowComparator(table, colIndices, up, nullsLast);
        try {
            Arrays.sort(rowMap, comp);
        }
        catch (SortException e) {
            throw e.asIOException();
        }
        long[] order = new long[nrow];
        for (int i = 0; i < nrow; ++i) {
            order[i] = rowMap[i].longValue();
        }
        return order;
    }

    private static class SortException
    extends RuntimeException {
        SortException(String msg, Throwable e) {
            super(msg, e);
        }

        IOException asIOException() {
            Throwable error = this.getCause();
            return error instanceof IOException ? (IOException)error : (IOException)new IOException(this.getMessage()).initCause(error);
        }
    }

    private static class RowComparator
    implements Comparator<Number> {
        final StarTable table_;
        final int[] colIndices_;
        final boolean up_;
        final boolean nullsLast_;
        final int ncol_;

        RowComparator(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
            this.table_ = table;
            this.colIndices_ = colIndices;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.ncol_ = this.colIndices_.length;
            for (int icol = 0; icol < this.ncol_; ++icol) {
                ColumnInfo info = table.getColumnInfo(icol);
                if (Comparable.class.isAssignableFrom(info.getContentClass())) continue;
                throw new IOException("Column " + info + " has no defined sort order");
            }
        }

        @Override
        public int compare(Number num1, Number num2) {
            long irow1 = num1.longValue();
            long irow2 = num2.longValue();
            int c = 0;
            for (int i = 0; i < this.ncol_ && c == 0; ++i) {
                Object val2;
                Object val1;
                int icol = this.colIndices_[i];
                try {
                    val1 = this.table_.getCell(irow1, icol);
                    val2 = this.table_.getCell(irow2, icol);
                }
                catch (IOException e) {
                    throw new SortException("Sort Error", e);
                }
                try {
                    c = this.compareValues((Comparable)val1, (Comparable)val2);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new SortException("Expression comparison error during sorting", e);
                }
            }
            return c;
        }

        private int compareValues(Comparable o1, Comparable o2) {
            boolean null1 = Tables.isBlank(o1);
            boolean null2 = Tables.isBlank(o2);
            if (null1 && null2) {
                return 0;
            }
            if (null1) {
                return this.up_ ^ this.nullsLast_ ? -1 : 1;
            }
            if (null2) {
                return this.up_ ^ this.nullsLast_ ? 1 : -1;
            }
            return this.up_ ? o1.compareTo(o2) : o2.compareTo(o1);
        }
    }
}

