/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TimeMapper;

public class RowEvaluator {
    private final Decoder<?>[] decoders_;
    private boolean[][] flagArrays_;
    private int[] stringLength_;
    private long nrow_;
    private int ncol_ = -1;
    public static final Pattern ISO8601_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?Z?)?");
    private static final Pattern HMS_REGEX = Pattern.compile("[ 012]?[0-9][:h ][ 0-6][0-9][:m ][0-6][0-9](\\.[0-9]*)?");
    private static final Pattern DMS_REGEX = Pattern.compile("[-+][ 0-9]?[0-9][:d ][ 0-6][0-9][:m ][0-6][0-9](\\.[0-9]*)?");
    private static final Pattern NAN_REGEX = Pattern.compile("NaN", 2);
    private static final Pattern INFINITY_REGEX = Pattern.compile("([+-]?)(Infinity|inf)", 2);
    public static final Decoder<?> BLANK_DECODER = RowEvaluator.createBlankDecoder("blank");
    public static final Decoder<Boolean> BOOLEAN_DECODER = new Decoder<Boolean>(Boolean.class, "boolean"){

        @Override
        public Boolean decode(String value) {
            char v1 = value.trim().charAt(0);
            return v1 == 't' || v1 == 'T' ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean isValid(String value) {
            return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("f") || value.equalsIgnoreCase("t");
        }
    };
    public static final Decoder<Short> SHORT_DECODER = new Decoder<Short>(Short.class, "short"){

        @Override
        public Short decode(String value) {
            return Short.valueOf(value.trim());
        }

        @Override
        public boolean isValid(String value) {
            try {
                return Short.parseShort(value) != 0 || value.charAt(0) != '-';
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Decoder<Integer> INTEGER_DECODER = new Decoder<Integer>(Integer.class, "int"){

        @Override
        public Integer decode(String value) {
            return Integer.valueOf(value.trim());
        }

        @Override
        public boolean isValid(String value) {
            try {
                return Integer.parseInt(value) != 0 || value.charAt(0) != '-';
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Decoder<Long> LONG_DECODER = new Decoder<Long>(Long.class, "long"){

        @Override
        public Long decode(String value) {
            return Long.valueOf(value.trim());
        }

        @Override
        public boolean isValid(String value) {
            try {
                return Long.parseLong(value) != 0L || value.charAt(0) != '-';
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Decoder<Float> FLOAT_DECODER = new Decoder<Float>(Float.class, "float"){

        @Override
        public Float decode(String value) {
            return Float.valueOf((float)RowEvaluator.parseFloating((String)value.trim()).dValue);
        }

        @Override
        public boolean isValid(String value) {
            try {
                ParsedFloat pf = RowEvaluator.parseFloating(value);
                double dval = pf.dValue;
                return dval == 0.0 || Double.isNaN(dval) || Double.isInfinite(dval) || pf.sigFig <= 6 && this.isSinglePrecision(dval);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean isSinglePrecision(double dval) {
            double absVal = Math.abs(dval);
            return absVal > 1.1754943508222875E-38 && absVal < 3.4028234663852886E38;
        }
    };
    public static final Decoder<Double> DOUBLE_DECODER = new Decoder<Double>(Double.class, "double"){

        @Override
        public Double decode(String value) {
            return RowEvaluator.parseFloating((String)value.trim()).dValue;
        }

        @Override
        public boolean isValid(String value) {
            try {
                RowEvaluator.parseFloating(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final Decoder<String> DATE_DECODER = new StringDecoder("date"){

        @Override
        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setXtype("timestamp");
            info.setDomainMappers(new DomainMapper[]{TimeMapper.ISO_8601});
            return info;
        }

        @Override
        public boolean isValid(String value) {
            return ISO8601_REGEX.matcher(value).matches();
        }
    };
    public static final Decoder<String> HMS_DECODER = new StringDecoder("hms"){

        @Override
        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setUnitString("hms");
            return info;
        }

        @Override
        public boolean isValid(String value) {
            return HMS_REGEX.matcher(value).matches();
        }
    };
    public static final Decoder<String> DMS_DECODER = new StringDecoder("dms"){

        @Override
        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setUnitString("dms");
            return info;
        }

        @Override
        public boolean isValid(String value) {
            return DMS_REGEX.matcher(value).matches();
        }
    };
    public static final Decoder<String> STRING_DECODER = new StringDecoder("string"){

        @Override
        public boolean isValid(String value) {
            return true;
        }
    };
    private static final Decoder<?>[] DECODERS = new Decoder[]{BLANK_DECODER, BOOLEAN_DECODER, SHORT_DECODER, INTEGER_DECODER, LONG_DECODER, FLOAT_DECODER, DOUBLE_DECODER, DATE_DECODER, HMS_DECODER, DMS_DECODER, STRING_DECODER};

    public RowEvaluator() {
        this(DECODERS);
    }

    public RowEvaluator(Decoder<?>[] decoders) {
        this.decoders_ = (Decoder[])decoders.clone();
    }

    public RowEvaluator(int ncol) {
        this();
        this.init(ncol);
    }

    private void init(int ncol) {
        this.ncol_ = ncol;
        this.flagArrays_ = new boolean[this.decoders_.length][];
        for (int idec = 0; idec < this.decoders_.length; ++idec) {
            this.flagArrays_[idec] = new boolean[this.ncol_];
            Arrays.fill(this.flagArrays_[idec], true);
        }
        this.stringLength_ = new int[ncol];
    }

    public void submitRow(List<String> row) throws TableFormatException {
        ++this.nrow_;
        if (this.ncol_ < 0) {
            this.init(row.size());
        }
        if (row.size() != this.ncol_) {
            throw new TableFormatException("Wrong number of columns at row " + this.nrow_ + " (expecting " + this.ncol_ + ", found " + row.size() + ")");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            boolean done = false;
            String cell0 = row.get(icol);
            int leng0 = cell0 == null ? 0 : cell0.length();
            String cell = cell0 == null ? "" : cell0.trim();
            int leng = cell.length();
            if (leng0 > this.stringLength_[icol]) {
                this.stringLength_[icol] = leng0;
            }
            if (leng <= 0) continue;
            for (int idec = 0; idec < this.decoders_.length; ++idec) {
                RowEvaluator.updateColFlag(icol, cell, this.flagArrays_[idec], this.decoders_[idec]);
            }
        }
    }

    private static void updateColFlag(int icol, String cell, boolean[] colFlags, Decoder<?> decoder) {
        if (colFlags[icol] && !decoder.isValid(cell)) {
            colFlags[icol] = false;
        }
    }

    public Metadata getMetadata() {
        ColumnInfo[] colInfos = new ColumnInfo[this.ncol_];
        Decoder[] decoders = new Decoder[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String name = "col" + (icol + 1);
            Decoder<String> decoder = null;
            for (int idec = 0; idec < this.decoders_.length && decoder == null; ++idec) {
                if (!this.flagArrays_[idec][icol]) continue;
                decoder = this.decoders_[idec];
            }
            if (decoder == null) {
                decoder = STRING_DECODER;
            }
            decoders[icol] = decoder;
            ColumnInfo info = decoder.createColumnInfo(name);
            if (decoder instanceof StringDecoder) {
                info.setElementSize(this.stringLength_[icol]);
            }
            colInfos[icol] = info;
        }
        return new Metadata(colInfos, decoders, this.nrow_);
    }

    private static ParsedFloat parseFloating(String item) {
        if (NAN_REGEX.matcher(item).matches()) {
            return ParsedFloat.NaN;
        }
        Matcher infMatcher = INFINITY_REGEX.matcher(item);
        if (infMatcher.matches()) {
            String sign = infMatcher.group(1);
            return sign.length() > 0 && sign.charAt(0) == '-' ? ParsedFloat.NEGATIVE_INFINITY : ParsedFloat.POSITIVE_INFINITY;
        }
        int nc = item.length();
        boolean foundExp = false;
        int sigFig = 0;
        block5: for (int i = 0; i < nc; ++i) {
            char c = item.charAt(i);
            switch (c) {
                case 'D': 
                case 'd': {
                    if (!foundExp) {
                        StringBuffer sbuf = new StringBuffer(item);
                        sbuf.setCharAt(i, 'e');
                        item = sbuf.toString();
                    }
                    foundExp = true;
                    continue block5;
                }
                case 'E': 
                case 'e': {
                    foundExp = true;
                    continue block5;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (foundExp) continue block5;
                    ++sigFig;
                    continue block5;
                }
            }
        }
        double dvalue = Double.parseDouble(item);
        return new ParsedFloat(sigFig, dvalue);
    }

    public static Decoder<?>[] getStandardDecoders() {
        return (Decoder[])DECODERS.clone();
    }

    private static Decoder<String> createBlankDecoder(String name) {
        return new StringDecoder(name){
            private Pattern blankRegex_ = Pattern.compile(" *");

            @Override
            public String decode(String value) {
                return null;
            }

            @Override
            public boolean isValid(String value) {
                return value == null || this.blankRegex_.matcher(value).matches();
            }
        };
    }

    private static class ParsedFloat {
        final int sigFig;
        final double dValue;
        static final ParsedFloat NaN = new ParsedFloat(0, Double.NaN);
        static final ParsedFloat POSITIVE_INFINITY = new ParsedFloat(0, Double.POSITIVE_INFINITY);
        static final ParsedFloat NEGATIVE_INFINITY = new ParsedFloat(0, Double.NEGATIVE_INFINITY);

        ParsedFloat(int sigFig, double dValue) {
            this.sigFig = sigFig;
            this.dValue = dValue;
        }
    }

    private static abstract class StringDecoder
    extends Decoder<String> {
        StringDecoder(String name) {
            super(String.class, name);
        }

        @Override
        public String decode(String value) {
            return value;
        }
    }

    public static abstract class Decoder<T> {
        private final Class<T> clazz_;
        private final String name_;

        public Decoder(Class<T> clazz, String name) {
            this.clazz_ = clazz;
            this.name_ = name;
        }

        public Class<T> getDecodedClass() {
            return this.clazz_;
        }

        public String getName() {
            return this.name_;
        }

        public ColumnInfo createColumnInfo(String name) {
            return new ColumnInfo(name, this.clazz_, null);
        }

        public abstract T decode(String var1);

        public abstract boolean isValid(String var1);
    }

    public static class Metadata {
        public final ColumnInfo[] colInfos_;
        public final Decoder<?>[] decoders_;
        public final long nrow_;
        public final int ncol_;

        public Metadata(ColumnInfo[] colInfos, Decoder<?>[] decoders, long nrow) {
            this.colInfos_ = colInfos;
            this.decoders_ = decoders;
            this.nrow_ = nrow;
            if (this.colInfos_.length != this.decoders_.length) {
                throw new IllegalArgumentException();
            }
            this.ncol_ = this.colInfos_.length;
        }
    }
}

