/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;

public class AccessRowSequence
implements RowSequence {
    private final RowAccess racc_;
    private final long nrow_;
    private long irow_;

    public AccessRowSequence(RowAccess racc, long nrow) {
        this.racc_ = racc;
        this.nrow_ = nrow;
        this.irow_ = -1L;
    }

    @Override
    public boolean next() throws IOException {
        if (this.irow_ + 1L < this.nrow_) {
            this.racc_.setRowIndex(++this.irow_);
            return true;
        }
        return false;
    }

    @Override
    public Object getCell(int icol) throws IOException {
        if (this.irow_ >= 0L) {
            return this.racc_.getCell(icol);
        }
        throw new IllegalStateException();
    }

    @Override
    public Object[] getRow() throws IOException {
        if (this.irow_ >= 0L) {
            return this.racc_.getRow();
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IOException {
        this.racc_.close();
    }

    public static AccessRowSequence createInstance(StarTable table) throws IOException {
        if (!table.isRandom()) {
            throw new IllegalArgumentException("Table " + table + " is not random access");
        }
        long nrow = table.getRowCount();
        if (nrow < 0L) {
            throw new IllegalArgumentException("Table " + table + " row count unknown (getRowCount()=" + nrow + ")");
        }
        return new AccessRowSequence(table.getRowAccess(), nrow);
    }
}

