/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowPipe;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

class OnceRowPipe2
implements RowPipe,
RowSequence {
    private final BlockingQueue<Object[]> rowQueue_;
    private final CountDownLatch tableLatch_;
    private StarTable table_;
    private volatile IOException error_;
    private volatile boolean seqClosed_;
    private Object[] seqRow_;
    private static final Object[] END_ROWS = new Object[0];

    public OnceRowPipe2() {
        this(1024);
    }

    public OnceRowPipe2(int queueSize) {
        this.rowQueue_ = new LinkedBlockingQueue<Object[]>(queueSize);
        this.tableLatch_ = new CountDownLatch(1);
    }

    @Override
    public void setError(IOException error) {
        this.rowQueue_.clear();
        if (this.error_ == null) {
            this.error_ = error;
        }
    }

    @Override
    public void acceptMetadata(StarTable meta) {
        this.table_ = new WrapperStarTable(meta){
            RowSequence rseq_;
            {
                this.rseq_ = OnceRowPipe2.this;
            }

            @Override
            public boolean isRandom() {
                return false;
            }

            @Override
            public RowAccess getRowAccess() {
                throw new UnsupportedOperationException();
            }

            @Override
            public RowSplittable getRowSplittable() throws IOException {
                return Tables.getDefaultRowSplittable(this);
            }

            @Override
            public synchronized RowSequence getRowSequence() throws IOException {
                if (this.rseq_ == null) {
                    throw new UnrepeatableSequenceException("Can't re-read data from stream");
                }
                OnceRowPipe2.this.checkError();
                RowSequence rseq = this.rseq_;
                this.rseq_ = null;
                return new WrapperRowSequence(rseq){

                    @Override
                    public boolean next() throws IOException {
                        OnceRowPipe2.this.checkError();
                        return super.next();
                    }

                    @Override
                    public Object getCell(int icol) throws IOException {
                        OnceRowPipe2.this.checkError();
                        return super.getCell(icol);
                    }

                    @Override
                    public Object[] getRow() throws IOException {
                        OnceRowPipe2.this.checkError();
                        return super.getRow();
                    }

                    @Override
                    public void close() throws IOException {
                        OnceRowPipe2.this.checkError();
                        super.close();
                    }
                };
            }
        };
        this.tableLatch_.countDown();
    }

    @Override
    public void acceptRow(Object[] row) throws IOException {
        if (this.seqClosed_) {
            throw new IOException("Stream closed at reading end");
        }
        this.checkError();
        try {
            this.rowQueue_.put(row);
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
    }

    @Override
    public void endRows() throws IOException {
        try {
            this.rowQueue_.put(END_ROWS);
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        if (this.table_ == null) {
            this.setError(new IOException("No data in table"));
        }
        this.tableLatch_.countDown();
    }

    @Override
    public StarTable waitForStarTable() throws IOException {
        try {
            this.tableLatch_.await();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        this.checkError();
        return this.table_;
    }

    @Override
    public boolean next() throws IOException {
        this.checkError();
        if (this.seqRow_ != END_ROWS) {
            try {
                this.seqRow_ = this.rowQueue_.take();
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Thread interrupted").initCause(e);
            }
        }
        return this.seqRow_ != END_ROWS;
    }

    @Override
    public Object[] getRow() {
        if (this.seqRow_ != null) {
            return this.seqRow_;
        }
        throw new IllegalStateException("next() has not been called yet");
    }

    @Override
    public Object getCell(int icol) {
        return this.getRow()[icol];
    }

    @Override
    public void close() {
        this.seqClosed_ = true;
    }

    private void checkError() throws IOException {
        if (this.error_ != null) {
            String msg = this.error_.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = this.error_.toString();
            }
            throw (IOException)new IOException(msg).initCause(this.error_);
        }
    }
}

