/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;

public abstract class RandomStarTable
extends AbstractStarTable {
    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public RowSequence getRowSequence() {
        final RandomStarTable table = this;
        final long nrow = this.getRowCount();
        return new RowSequence(){
            long irow_ = -1L;

            @Override
            public boolean next() {
                if (this.irow_ < nrow - 1L) {
                    ++this.irow_;
                    return true;
                }
                return false;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                if (this.irow_ >= 0L) {
                    return table.getCell(this.irow_, icol);
                }
                throw new IllegalStateException("No current row");
            }

            @Override
            public Object[] getRow() throws IOException {
                if (this.irow_ >= 0L) {
                    return table.getRow(this.irow_);
                }
                throw new IllegalStateException("No current row");
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public RowAccess getRowAccess() {
        final RandomStarTable table = this;
        return new RowAccess(){
            long irow_ = -1L;

            @Override
            public void setRowIndex(long irow) {
                this.irow_ = irow;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return table.getCell(this.irow_, icol);
            }

            @Override
            public Object[] getRow() throws IOException {
                return table.getRow(this.irow_);
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public abstract long getRowCount();

    @Override
    public abstract Object getCell(long var1, int var3) throws IOException;
}

