/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.function.Supplier;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.SplitPolicy;
import uk.ac.starlink.util.SplitProcessor;

public class RowRunner {
    private final SplitProcessor<RowSplittable> processor_;
    public static final SplitPolicy DFLT_POLICY = SplitPolicy.DFLT_POLICY;
    private static final boolean STD_IS_POOL = false;
    public static final RowRunner DEFAULT = new RowRunner(SplitProcessor.createStandardProcessor(DFLT_POLICY, false));
    public static final RowRunner SEQUENTIAL = new RowRunner(SplitProcessor.createSequentialProcessor()){

        @Override
        public RowSplittable createRowSplittable(StarTable table) throws IOException {
            return new SequentialRowSplittable(table);
        }
    };
    public static final RowRunner PARTEST = RowRunner.createParallelTestRunner(10);

    public RowRunner(SplitProcessor<?> processor) {
        SplitProcessor<?> rowProcessor = processor;
        this.processor_ = rowProcessor;
    }

    public <A> A collect(RowCollector<A> collector, StarTable table) throws IOException {
        RowSplittable splittable = this.createRowSplittable(table);
        return (A)RowRunner.invokeWithSmuggledIOException(() -> this.processor_.collect(collector, splittable));
    }

    public RowSplittable createRowSplittable(StarTable table) throws IOException {
        return table.getRowSplittable();
    }

    public SplitProcessor<RowSplittable> getSplitProcessor() {
        return this.processor_;
    }

    private static <T> T invokeWithSmuggledIOException(Supplier<T> supplier) throws IOException {
        try {
            return supplier.get();
        }
        catch (RuntimeException err) {
            IOException ioErr = RowRunner.getNestedIOException(err);
            if (ioErr == null) {
                throw err;
            }
            throw new IOException(ioErr.getMessage(), err);
        }
    }

    private static IOException getNestedIOException(Throwable err) {
        for (Throwable e = err; e != null; e = e.getCause()) {
            if (!(e instanceof IOException)) continue;
            return (IOException)e;
        }
        return null;
    }

    private static RowRunner createParallelTestRunner(int minTaskSize) {
        short maxTasksPerCore = -1;
        SplitPolicy policy = new SplitPolicy(null, minTaskSize, maxTasksPerCore);
        SplitProcessor processor = SplitProcessor.createBasicParallelProcessor(policy);
        return new RowRunner(processor);
    }
}

