/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LabelledComponentStack
extends JPanel {
    private final Font inputFont_ = new JTextField().getFont();
    private final GridBagLayout layer_ = new GridBagLayout();
    private final GridBagConstraints cons_ = new GridBagConstraints();
    private final List<JLabel> labels_ = new ArrayList<JLabel>();
    private final List<Component> fields_ = new ArrayList<Component>();

    public LabelledComponentStack() {
        this.setLayout(this.layer_);
        this.cons_.gridy = 0;
    }

    public void addLine(String name, String pad, Component comp) {
        this.addLine(name, pad, comp, comp instanceof JTextField);
    }

    public void addLine(String name, String pad, Component comp, boolean xfill) {
        if (this.cons_.gridy > 0) {
            this.cons_.gridx = 0;
            Component strut = Box.createVerticalStrut(4);
            this.layer_.setConstraints(strut, this.cons_);
            this.add(strut);
            ++this.cons_.gridy;
        }
        JLabel nameComp = new JLabel(name == null ? null : name + ":  ");
        GridBagConstraints cons1 = (GridBagConstraints)this.cons_.clone();
        cons1.gridx = 0;
        cons1.anchor = 13;
        this.layer_.setConstraints(nameComp, cons1);
        this.add(nameComp);
        JLabel padComp = null;
        if (pad != null) {
            GridBagConstraints cons2 = (GridBagConstraints)this.cons_.clone();
            padComp = new JLabel(pad + "  ");
            ((Component)padComp).setFont(this.inputFont_);
            cons2.gridx = 1;
            cons2.anchor = 13;
            this.layer_.setConstraints(padComp, cons2);
            this.add(padComp);
        }
        GridBagConstraints cons3 = (GridBagConstraints)this.cons_.clone();
        cons3.gridx = 2;
        cons3.anchor = 17;
        cons3.weightx = 1.0;
        cons3.fill = xfill ? 2 : 0;
        cons3.gridwidth = 0;
        this.layer_.setConstraints(comp, cons3);
        this.add(comp);
        ++this.cons_.gridy;
        this.labels_.add(nameComp);
        this.fields_.add(comp);
    }

    public void addLine(String name, Component comp) {
        this.addLine(name, null, comp);
    }

    public void addLine(String name, String value) {
        this.addLine(name, new JLabel(value));
    }

    public Font getInputFont() {
        return this.inputFont_;
    }

    public JLabel[] getLabels() {
        return this.labels_.toArray(new JLabel[0]);
    }

    public Component[] getFields() {
        return this.fields_.toArray(new Component[0]);
    }
}

