/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import uk.ac.starlink.table.StarTable;

public class StarTableModel
extends AbstractTableModel {
    protected StarTable startable;
    private boolean rowHeader;
    private int extraCols;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table.gui");

    public StarTableModel(StarTable startable) {
        this(startable, false);
    }

    public StarTableModel(StarTable startable, boolean rowHeader) {
        this.startable = startable;
        this.rowHeader = rowHeader;
        int n = this.extraCols = rowHeader ? 1 : 0;
        if (!startable.isRandom()) {
            throw new IllegalArgumentException("Table " + startable + " does not have random access");
        }
        if (startable.getRowCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Table has too many rows (" + startable.getRowCount() + " > Integer.MAX_VALUE)");
        }
    }

    public boolean hasRowHeader() {
        return this.rowHeader;
    }

    public StarTable getStarTable() {
        return this.startable;
    }

    @Override
    public int getRowCount() {
        return (int)this.startable.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.startable.getColumnCount() + this.extraCols;
    }

    @Override
    public Object getValueAt(int irow, int icol) {
        if (this.rowHeader && icol == 0) {
            return irow + 1;
        }
        try {
            return this.startable.getCell(irow, icol - this.extraCols);
        }
        catch (IOException e) {
            logger.warning("IOException for table cell " + irow + ", " + icol);
            return e.getMessage();
        }
    }

    @Override
    public String getColumnName(int icol) {
        if (this.rowHeader && icol == 0) {
            return "";
        }
        return this.startable.getColumnInfo(icol - this.extraCols).getName();
    }

    @Override
    public Class<?> getColumnClass(int icol) {
        if (this.rowHeader && icol == 0) {
            return Integer.class;
        }
        return this.startable.getColumnInfo(icol - this.extraCols).getContentClass();
    }
}

