/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.ByteStoreColumnReader;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnReader;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.FileByteStore;
import uk.ac.starlink.table.storage.NioByteStoreAccess;
import uk.ac.starlink.util.DataBufferedOutputStream;

public class IndexedStreamColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final File dataFile_;
    private final File indexFile_;
    private final DataBufferedOutputStream dataOut_;
    private final DataBufferedOutputStream indexOut_;
    private long dataOffset_;
    private long nrow_;
    private ByteBuffer[] dataBufs_;
    private ByteBuffer[] indexBufs_;

    public IndexedStreamColumnStore(Codec codec, File dataFile, File indexFile) throws IOException {
        this.codec_ = codec;
        this.dataFile_ = dataFile;
        this.indexFile_ = indexFile;
        this.dataOut_ = new DataBufferedOutputStream(new FileOutputStream(dataFile));
        this.indexOut_ = new DataBufferedOutputStream(new FileOutputStream(indexFile));
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        this.indexOut_.writeLong(this.dataOffset_);
        this.dataOffset_ += (long)this.codec_.encode(value, this.dataOut_);
        ++this.nrow_;
    }

    @Override
    public void endCells() throws IOException {
        this.dataOut_.close();
        this.indexOut_.close();
        this.dataBufs_ = FileByteStore.toByteBuffers(this.dataFile_);
        this.indexBufs_ = FileByteStore.toByteBuffers(this.indexFile_);
    }

    @Override
    public ColumnReader createReader() {
        ByteStoreAccess dataAccess = NioByteStoreAccess.createAccess(NioByteStoreAccess.copyBuffers(this.dataBufs_));
        final ByteStoreAccess indexAccess = NioByteStoreAccess.createAccess(NioByteStoreAccess.copyBuffers(this.indexBufs_));
        return new ByteStoreColumnReader(this.codec_, dataAccess, this.nrow_){

            @Override
            public long getAccessOffset(long ix) throws IOException {
                indexAccess.seek(8L * ix);
                return indexAccess.readLong();
            }
        };
    }
}

