/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.cdf;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import uk.ac.bristol.star.cdf.CdfContent;
import uk.ac.bristol.star.cdf.CdfReader;
import uk.ac.bristol.star.cdf.Variable;
import uk.ac.bristol.star.cdf.VariableAttribute;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Bufs;
import uk.ac.bristol.star.cdf.record.WrapperBuf;
import uk.ac.starlink.cdf.CdfStarTable;
import uk.ac.starlink.cdf.CdfTableProfile;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;

public class CdfTableBuilder
extends DocumentedTableBuilder
implements MultiTableBuilder {
    public static final CdfTableProfile DEFAULT_PROFILE = CdfTableBuilder.createProfile(true, new String[]{"CATDESC", "FIELDNAM", "DESCRIP", "DESCRIPTION"}, new String[]{"UNITS", "UNIT", "UNITSTRING"}, new String[]{"FILLVAL"}, new String[]{"DEPEND_0"});
    private static final int IPOS_BASE = 0;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.cdf");
    private final CdfTableProfile profile_;

    public CdfTableBuilder() {
        this(DEFAULT_PROFILE);
    }

    public CdfTableBuilder(CdfTableProfile profile) {
        super(new String[]{"cdf"});
        this.profile_ = profile;
    }

    public String getFormatName() {
        return "CDF";
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        int ipos;
        TablesContent tcontent = new TablesContent(datsrc, storagePolicy, this.profile_);
        String pos = datsrc.getPosition();
        if (pos == null || pos.trim().length() == 0) {
            ipos = 0;
        } else if (pos.trim().matches("[0-9]+")) {
            ipos = Integer.parseInt(pos.trim());
        } else if (tcontent.getTableIndex(pos) >= 0) {
            ipos = tcontent.getTableIndex(pos) + 0;
        } else {
            String msg = "Unknown pos \"" + pos + "\", should be numeric (" + 0 + "-" + (0 + tcontent.getTableCount()) + ") or one of " + Arrays.stream(tcontent.dependVars_).map(Variable::getName).collect(Collectors.toList());
            throw new TableFormatException(msg);
        }
        int jpos = ipos - 0;
        if (jpos < 0 || jpos >= tcontent.getTableCount()) {
            throw new TableFormatException("No table at pos #" + ipos);
        }
        return tcontent.createTable(jpos);
    }

    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy storagePolicy) throws IOException {
        TablesContent tcontent = new TablesContent(datsrc, storagePolicy, this.profile_);
        int nt = tcontent.getTableCount();
        CdfStarTable[] tables = new CdfStarTable[nt];
        for (int it = 0; it < nt; ++it) {
            tables[it] = tcontent.createTable(it);
        }
        return Tables.arrayTableSequence((StarTable[])tables);
    }

    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        throw new TableFormatException("Can't stream from CDF format");
    }

    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>NASA's Common Data Format, described at", DocumentedIOHandler.toLink((String)"https://cdf.gsfc.nasa.gov/") + ",", "is a binary format for storing self-described data.", "It is typically used to store tabular data for subject areas", "like space and solar physics.", "</p>", "<p>CDF does not store tables as such, but sets of variables", "(columns) which are typically linked to a time quantity;", "there may be multiple such disjoint sets in a single CDF file.", "This reader attempts to extract these sets into separate tables", "using, where present, the <code>DEPEND_0</code> attribute", "defined by the", "<webref url='https://spdf.gsfc.nasa.gov/sp_use_of_cdf.html'", ">ISTP Metadata Guidelines</webref>.", "Where there are multiple tables they can be identified", "using a \"<code>#</code>\" symbol at the end of the filename", "by index (\"<code>&lt;file&gt;.cdf#0</code>\" is the first table)", "or by the name of the independent variable", "(\"<code>&lt;file&gt;.cdf#EPOCH</code>\" is the table relating to", "the <code>EPOCH</code> column).", "</p>", "");
    }

    public boolean docIncludesExample() {
        return false;
    }

    public boolean canStream() {
        return false;
    }

    private static Variable getVariable(CdfContent content, String name) {
        for (Variable var : content.getVariables()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    private static VariableAttribute getVariableAttribute(CdfContent content, String name) {
        for (VariableAttribute att : content.getVariableAttributes()) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    public static CdfTableProfile createProfile(boolean invarParams, String[] descripAttNames, String[] unitAttNames, String[] blankvalAttNames, String[] depend0AttNames) {
        return new ListCdfTableProfile(invarParams, descripAttNames, unitAttNames, blankvalAttNames, depend0AttNames);
    }

    private static class TablesContent {
        private final CdfContent content_;
        private final CdfTableProfile profile_;
        private final Variable[] dependVars_;

        TablesContent(DataSource datsrc, StoragePolicy storagePolicy, CdfTableProfile profile) throws IOException {
            VariableAttribute dependAtt;
            Buf nbuf;
            this.profile_ = profile;
            if (!CdfReader.isMagic(datsrc.getIntro())) {
                throw new TableFormatException("Not a CDF file");
            }
            if (datsrc instanceof FileDataSource && datsrc.getCompression() == Compression.NONE) {
                File file = ((FileDataSource)datsrc).getFile();
                nbuf = Bufs.createBuf(file, true, true);
            } else {
                ByteStore byteStore = storagePolicy.makeByteStore();
                BufferedOutputStream storeOut = new BufferedOutputStream(byteStore.getOutputStream());
                InputStream dataIn = datsrc.getInputStream();
                IOUtils.copy((InputStream)dataIn, (OutputStream)storeOut);
                dataIn.close();
                storeOut.flush();
                ByteBuffer[] bbufs = byteStore.toByteBuffers();
                storeOut.close();
                byteStore.close();
                nbuf = Bufs.createBuf(bbufs, true, true);
            }
            StoragePolicyBuf buf = new StoragePolicyBuf(nbuf, storagePolicy);
            this.content_ = new CdfContent(new CdfReader(buf));
            String[] attNames = (String[])Arrays.stream(this.content_.getVariableAttributes()).map(VariableAttribute::getName).toArray(String[]::new);
            String dependAttName = profile.getDepend0Attribute(attNames);
            String[] dependVarNames = dependAttName != null ? ((dependAtt = CdfTableBuilder.getVariableAttribute(this.content_, dependAttName)) != null ? (String[])Arrays.stream(this.content_.getVariables()).map(v -> CdfStarTable.getStringEntry(dependAtt, v)).filter(s -> s != null && s.trim().length() > 0).distinct().toArray(String[]::new) : null) : null;
            ArrayList<Variable> dependVars = new ArrayList<Variable>();
            if (dependVarNames != null && dependVarNames.length > 0) {
                for (String varName : dependVarNames) {
                    Variable var = CdfTableBuilder.getVariable(this.content_, varName);
                    if (var == null) {
                        logger_.warning("Unknown independent variable " + varName);
                        continue;
                    }
                    dependVars.add(var);
                }
            }
            this.dependVars_ = dependVars.toArray(new Variable[0]);
        }

        public int getTableCount() {
            return this.dependVars_.length == 0 ? 1 : this.dependVars_.length;
        }

        public int getTableIndex(String pos) {
            for (int it = 0; it < this.dependVars_.length; ++it) {
                if (!this.dependVars_[it].getName().equalsIgnoreCase(pos)) continue;
                return it;
            }
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CdfStarTable createTable(int itable) throws IOException {
            Variable dependVar;
            if (this.dependVars_.length == 0) {
                if (itable != 0) throw new TableFormatException("No table at " + itable);
                dependVar = null;
                return new CdfStarTable(this.content_, this.profile_, dependVar);
            } else {
                dependVar = this.dependVars_[itable];
            }
            return new CdfStarTable(this.content_, this.profile_, dependVar);
        }
    }

    private static class ListCdfTableProfile
    implements CdfTableProfile {
        private final boolean invarParams_;
        private final String[] descAttNames_;
        private final String[] unitAttNames_;
        private final String[] blankvalAttNames_;
        private final String[] depend0AttNames_;

        ListCdfTableProfile(boolean invarParams, String[] descripAttNames, String[] unitAttNames, String[] blankvalAttNames, String[] depend0AttNames) {
            this.invarParams_ = invarParams;
            this.descAttNames_ = descripAttNames;
            this.unitAttNames_ = unitAttNames;
            this.blankvalAttNames_ = blankvalAttNames;
            this.depend0AttNames_ = depend0AttNames;
        }

        @Override
        public boolean invariantVariablesToParameters() {
            return this.invarParams_;
        }

        @Override
        public String getDescriptionAttribute(String[] attNames) {
            return this.match(this.descAttNames_, attNames);
        }

        @Override
        public String getUnitAttribute(String[] attNames) {
            return this.match(this.unitAttNames_, attNames);
        }

        @Override
        public String getBlankValueAttribute(String[] attNames) {
            return this.match(this.blankvalAttNames_, attNames);
        }

        @Override
        public String getDepend0Attribute(String[] attNames) {
            return this.match(this.depend0AttNames_, attNames);
        }

        private String match(String[] opts, String[] targets) {
            int i;
            HashSet<String> targetSet = new HashSet<String>();
            for (i = 0; i < targets.length; ++i) {
                targetSet.add(this.normalise(targets[i]));
            }
            for (i = 0; i < opts.length; ++i) {
                String opt = opts[i];
                if (!targetSet.contains(this.normalise(opt))) continue;
                return opt;
            }
            return null;
        }

        private String normalise(String txt) {
            return txt.trim().toLowerCase();
        }
    }

    private static class StoragePolicyBuf
    extends WrapperBuf {
        private final Buf baseBuf_;
        private final StoragePolicy storagePolicy_;

        StoragePolicyBuf(Buf baseBuf, StoragePolicy storagePolicy) {
            super(baseBuf);
            this.baseBuf_ = baseBuf;
            this.storagePolicy_ = storagePolicy;
        }

        @Override
        public Buf fillNewBuf(long count, InputStream in) throws IOException {
            ByteStore byteStore = this.storagePolicy_.makeByteStore();
            OutputStream out = byteStore.getOutputStream();
            int bufsiz = 16384;
            byte[] a = new byte[bufsiz];
            int ntot = 0;
            while ((long)ntot < count) {
                int n = in.read(a, 0, Math.min(bufsiz, (int)(count - (long)ntot)));
                if (n < 0) {
                    throw new IOException("Stream ended after " + ntot + "/" + count + " bytes");
                }
                out.write(a, 0, n);
                ntot += n;
            }
            out.flush();
            ByteBuffer[] bbufs = byteStore.toByteBuffers();
            byteStore.close();
            return Bufs.createBuf(bbufs, super.isBit64(), super.isBigendian());
        }
    }
}

