/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.BadChallengeException;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.ContentType;
import uk.ac.starlink.auth.ContextFactory;
import uk.ac.starlink.auth.IvoaAuthScheme;
import uk.ac.starlink.auth.LoginProtocol;
import uk.ac.starlink.auth.ProtectionSpace;
import uk.ac.starlink.auth.UserInterface;
import uk.ac.starlink.auth.ssl.SSLUtil;
import uk.ac.starlink.auth.ssl.X509CertificateChain;

public class X509IvoaAuthScheme
extends IvoaAuthScheme {
    public static final X509IvoaAuthScheme INSTANCE = new X509IvoaAuthScheme();
    public static final String SCHEME_NAME = "ivoa_x509";
    private static final int MAX_CERT_SIZE = 65536;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.auth");

    private X509IvoaAuthScheme() {
        super(SCHEME_NAME);
    }

    @Override
    public ContextFactory createContextFactory(final LoginProtocol loginProto, final URL loginUrl, URL challengeUrl) {
        final ProtectionSpace scope = new ProtectionSpace(challengeUrl, null);
        return new ContextFactory(){

            @Override
            public AuthContext createContext(UserInterface ui) {
                X509CertificateChain chain = IvoaAuthScheme.readAuth(loginProto, X509IvoaAuthScheme.this, loginUrl, ui, x$0 -> X509IvoaAuthScheme.readCertificate(x$0));
                return chain == null ? null : this.createX509Context(chain);
            }

            @Override
            public AuthContext createUnauthContext() {
                return this.createX509Context(null);
            }

            private AuthContext createX509Context(X509CertificateChain chain) {
                return new X509Context(X509IvoaAuthScheme.this, loginUrl.toString(), scope, chain);
            }
        };
    }

    private static X509CertificateChain readCertificate(HttpURLConnection conn) throws IOException {
        byte[] buf;
        ContentType ctype = ContentType.parse(conn.getContentType());
        StringBuffer sbuf = new StringBuffer().append("Attempting to read X509 certificate in PEM format from ").append(conn.getURL());
        if (ctype != null) {
            sbuf.append(" (").append(ctype).append(")");
        }
        logger_.info(sbuf.toString());
        try (InputStream in = conn.getInputStream();){
            buf = X509IvoaAuthScheme.readStream(in, 65536);
        }
        try {
            return SSLUtil.readPemCertificateAndKey(buf);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error reading certificate", e);
        }
    }

    private static byte[] readStream(InputStream in, int maxLeng) throws IOException {
        byte[] buf = new byte[maxLeng];
        int n = 0;
        while (true) {
            if (n >= maxLeng) {
                throw new IOException("Certificate content surprisingly large (>" + maxLeng + ") - bailing out");
            }
            int c = in.read(buf, n, maxLeng - n);
            if (c < 0) {
                if (n == 0) {
                    throw new IOException("No certificate data found");
                }
                byte[] buf1 = new byte[n];
                System.arraycopy(buf, 0, buf1, 0, n);
                return buf1;
            }
            n += c;
        }
    }

    private static class X509Context
    implements AuthContext {
        private final X509IvoaAuthScheme scheme_;
        private final String loginUrl_;
        private final ProtectionSpace scope_;
        private final SSLSocketFactory sslFact_;
        private final long expireTime_;

        X509Context(X509IvoaAuthScheme scheme, String loginUrl, ProtectionSpace scope, X509CertificateChain chain) {
            this.scheme_ = scheme;
            this.loginUrl_ = loginUrl;
            this.scope_ = scope;
            this.sslFact_ = chain == null ? null : SSLUtil.getSocketFactory(chain);
            Date expireDate = chain == null ? null : chain.getExpiryDate();
            this.expireTime_ = expireDate == null ? Long.MAX_VALUE : expireDate.getTime();
        }

        @Override
        public AuthScheme getScheme() {
            return this.scheme_;
        }

        @Override
        public boolean hasCredentials() {
            return this.sslFact_ != null;
        }

        @Override
        public void configureConnection(HttpURLConnection conn) throws IOException {
            if (conn instanceof HttpsURLConnection && this.sslFact_ != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslFact_);
            }
        }

        @Override
        public boolean isUrlDomain(URL url) {
            return this.scope_.equals(new ProtectionSpace(url, null));
        }

        @Override
        public boolean isChallengeDomain(Challenge challenge, URL url) {
            try {
                return this.scheme_.createContextFactory(challenge, url) != null && this.loginUrl_.equals(challenge.getParams().get("access_url"));
            }
            catch (BadChallengeException e) {
                return false;
            }
        }

        @Override
        public boolean isExpired() {
            return System.currentTimeMillis() > this.expireTime_;
        }

        @Override
        public String[] getCurlArgs(URL url, boolean showSecret) {
            String[] stringArray;
            if (this.hasCredentials()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "--cert";
                stringArray = stringArray2;
                stringArray2[1] = "<PEM-FILE>";
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }
}

