/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import gov.nasa.pds.label.object.FieldType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import uk.ac.starlink.pds4.Field;
import uk.ac.starlink.pds4.Table;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.IOUtils;

public abstract class Pds4StarTable
extends AbstractStarTable {
    private final URL dataUrl_;
    private final long dataOffset_;
    private final long nrow_;
    public static final ValueInfo DESCRIPTION_INFO = new DefaultValueInfo("Description", String.class, "table description");

    protected Pds4StarTable(Table table, URI contextUri) throws IOException {
        this.dataUrl_ = contextUri.resolve(table.getFileName()).toURL();
        this.dataOffset_ = table.getOffset();
        this.nrow_ = table.getRecordCount();
        String name = table.getName();
        if (name != null) {
            this.setName(name);
        } else {
            String localIdentifier = table.getLocalIdentifier();
            if (localIdentifier != null) {
                this.setName(localIdentifier);
            }
        }
        String description = table.getDescription();
        if (description != null) {
            this.getParameters().add(new DescribedValue(DESCRIPTION_INFO, description));
        }
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    InputStream getDataStream() throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.dataUrl_.openStream());
        IOUtils.skip(in, this.dataOffset_);
        return in;
    }

    URL getDataUrl() {
        return this.dataUrl_;
    }

    long getDataOffset() {
        return this.dataOffset_;
    }

    static ColumnInfo createColumnInfo(Field field, Class<?> clazz) {
        ColumnInfo info = new ColumnInfo(field.getName(), clazz, field.getDescription());
        info.setUnitString(field.getUnit());
        DomainMapper mapper = Pds4StarTable.getDomainMapper(field.getFieldType());
        if (mapper != null && clazz.isAssignableFrom(mapper.getSourceClass())) {
            info.setDomainMappers(new DomainMapper[]{mapper});
        }
        return info;
    }

    private static DomainMapper getDomainMapper(FieldType ftype) {
        switch (ftype) {
            case ASCII_DATE_DOY: 
            case ASCII_DATE_TIME_DOY: 
            case ASCII_DATE_TIME_DOY_UTC: 
            case ASCII_DATE_TIME_YMD: 
            case ASCII_DATE_TIME_YMD_UTC: 
            case ASCII_DATE_YMD: 
            case ASCII_DATE: 
            case ASCII_DATE_TIME: 
            case ASCII_DATE_TIME_UTC: {
                return TimeMapper.ISO_8601;
            }
        }
        return null;
    }
}

