/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.fbs.google;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import uk.ac.bristol.star.fbs.google.Table;
import uk.ac.bristol.star.fbs.google.Utf8;

public class FlatBufferBuilder {
    ByteBuffer bb;
    int space;
    int minalign = 1;
    int[] vtable = null;
    int vtable_in_use = 0;
    boolean nested = false;
    boolean finished = false;
    int object_start;
    int[] vtables = new int[16];
    int num_vtables = 0;
    int vector_num_elems = 0;
    boolean force_defaults = false;
    ByteBufferFactory bb_factory;
    final Utf8 utf8;

    public FlatBufferBuilder(int n, ByteBufferFactory byteBufferFactory) {
        this(n, byteBufferFactory, null, Utf8.getDefault());
    }

    public FlatBufferBuilder(int n, ByteBufferFactory byteBufferFactory, ByteBuffer byteBuffer, Utf8 utf8) {
        if (n <= 0) {
            n = 1;
        }
        this.space = n;
        this.bb_factory = byteBufferFactory;
        if (byteBuffer != null) {
            this.bb = byteBuffer;
            this.bb.clear();
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.bb = byteBufferFactory.newByteBuffer(n);
        }
        this.utf8 = utf8;
    }

    public FlatBufferBuilder(int n) {
        this(n, HeapByteBufferFactory.INSTANCE, null, Utf8.getDefault());
    }

    public FlatBufferBuilder() {
        this(1024);
    }

    public FlatBufferBuilder(ByteBuffer byteBuffer, ByteBufferFactory byteBufferFactory) {
        this(byteBuffer.capacity(), byteBufferFactory, byteBuffer, Utf8.getDefault());
    }

    public FlatBufferBuilder(ByteBuffer byteBuffer) {
        this(byteBuffer, (ByteBufferFactory)new HeapByteBufferFactory());
    }

    public FlatBufferBuilder init(ByteBuffer byteBuffer, ByteBufferFactory byteBufferFactory) {
        this.bb_factory = byteBufferFactory;
        this.bb = byteBuffer;
        this.bb.clear();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.minalign = 1;
        this.space = this.bb.capacity();
        this.vtable_in_use = 0;
        this.nested = false;
        this.finished = false;
        this.object_start = 0;
        this.num_vtables = 0;
        this.vector_num_elems = 0;
        return this;
    }

    public void clear() {
        this.space = this.bb.capacity();
        this.bb.clear();
        this.minalign = 1;
        while (this.vtable_in_use > 0) {
            this.vtable[--this.vtable_in_use] = 0;
        }
        this.vtable_in_use = 0;
        this.nested = false;
        this.finished = false;
        this.object_start = 0;
        this.num_vtables = 0;
        this.vector_num_elems = 0;
    }

    static ByteBuffer growByteBuffer(ByteBuffer byteBuffer, ByteBufferFactory byteBufferFactory) {
        int n = byteBuffer.capacity();
        if ((n & 0xC0000000) != 0) {
            throw new AssertionError((Object)"FlatBuffers: cannot grow buffer beyond 2 gigabytes.");
        }
        int n2 = n == 0 ? 1 : n << 1;
        byteBuffer.position(0);
        ByteBuffer byteBuffer2 = byteBufferFactory.newByteBuffer(n2);
        byteBuffer2.position(n2 - n);
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    public int offset() {
        return this.bb.capacity() - this.space;
    }

    public void pad(int n) {
        for (int i = 0; i < n; ++i) {
            this.bb.put(--this.space, (byte)0);
        }
    }

    public void prep(int n, int n2) {
        if (n > this.minalign) {
            this.minalign = n;
        }
        int n3 = ~(this.bb.capacity() - this.space + n2) + 1 & n - 1;
        while (this.space < n3 + n + n2) {
            int n4 = this.bb.capacity();
            ByteBuffer byteBuffer = this.bb;
            this.bb = FlatBufferBuilder.growByteBuffer(byteBuffer, this.bb_factory);
            if (byteBuffer != this.bb) {
                this.bb_factory.releaseByteBuffer(byteBuffer);
            }
            this.space += this.bb.capacity() - n4;
        }
        this.pad(n3);
    }

    public void putBoolean(boolean bl) {
        this.bb.put(--this.space, (byte)(bl ? 1 : 0));
    }

    public void putByte(byte by) {
        this.bb.put(--this.space, by);
    }

    public void putShort(short s) {
        this.bb.putShort(this.space -= 2, s);
    }

    public void putInt(int n) {
        this.bb.putInt(this.space -= 4, n);
    }

    public void putLong(long l) {
        this.bb.putLong(this.space -= 8, l);
    }

    public void putFloat(float f) {
        this.bb.putFloat(this.space -= 4, f);
    }

    public void putDouble(double d) {
        this.bb.putDouble(this.space -= 8, d);
    }

    public void addBoolean(boolean bl) {
        this.prep(1, 0);
        this.putBoolean(bl);
    }

    public void addByte(byte by) {
        this.prep(1, 0);
        this.putByte(by);
    }

    public void addShort(short s) {
        this.prep(2, 0);
        this.putShort(s);
    }

    public void addInt(int n) {
        this.prep(4, 0);
        this.putInt(n);
    }

    public void addLong(long l) {
        this.prep(8, 0);
        this.putLong(l);
    }

    public void addFloat(float f) {
        this.prep(4, 0);
        this.putFloat(f);
    }

    public void addDouble(double d) {
        this.prep(8, 0);
        this.putDouble(d);
    }

    public void addOffset(int n) {
        this.prep(4, 0);
        assert (n <= this.offset());
        n = this.offset() - n + 4;
        this.putInt(n);
    }

    public void startVector(int n, int n2, int n3) {
        this.notNested();
        this.vector_num_elems = n2;
        this.prep(4, n * n2);
        this.prep(n3, n * n2);
        this.nested = true;
    }

    public int endVector() {
        if (!this.nested) {
            throw new AssertionError((Object)"FlatBuffers: endVector called without startVector");
        }
        this.nested = false;
        this.putInt(this.vector_num_elems);
        return this.offset();
    }

    public ByteBuffer createUnintializedVector(int n, int n2, int n3) {
        int n4 = n * n2;
        this.startVector(n, n2, n3);
        this.bb.position(this.space -= n4);
        ByteBuffer byteBuffer = this.bb.slice().order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.limit(n4);
        return byteBuffer;
    }

    public int createVectorOfTables(int[] nArray) {
        this.notNested();
        this.startVector(4, nArray.length, 4);
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.addOffset(nArray[i]);
        }
        return this.endVector();
    }

    public <T extends Table> int createSortedVectorOfTables(T t, int[] nArray) {
        t.sortTables(nArray, this.bb);
        return this.createVectorOfTables(nArray);
    }

    public int createString(CharSequence charSequence) {
        int n = this.utf8.encodedLength(charSequence);
        this.addByte((byte)0);
        this.startVector(1, n, 1);
        this.bb.position(this.space -= n);
        this.utf8.encodeUtf8(charSequence, this.bb);
        return this.endVector();
    }

    public int createString(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.addByte((byte)0);
        this.startVector(1, n, 1);
        this.bb.position(this.space -= n);
        this.bb.put(byteBuffer);
        return this.endVector();
    }

    public int createByteVector(byte[] byArray) {
        int n = byArray.length;
        this.startVector(1, n, 1);
        this.bb.position(this.space -= n);
        this.bb.put(byArray);
        return this.endVector();
    }

    public void finished() {
        if (!this.finished) {
            throw new AssertionError((Object)"FlatBuffers: you can only access the serialized buffer after it has been finished by FlatBufferBuilder.finish().");
        }
    }

    public void notNested() {
        if (this.nested) {
            throw new AssertionError((Object)"FlatBuffers: object serialization must not be nested.");
        }
    }

    public void Nested(int n) {
        if (n != this.offset()) {
            throw new AssertionError((Object)"FlatBuffers: struct must be serialized inline.");
        }
    }

    public void startObject(int n) {
        this.notNested();
        if (this.vtable == null || this.vtable.length < n) {
            this.vtable = new int[n];
        }
        this.vtable_in_use = n;
        Arrays.fill(this.vtable, 0, this.vtable_in_use, 0);
        this.nested = true;
        this.object_start = this.offset();
    }

    public void addBoolean(int n, boolean bl, boolean bl2) {
        if (this.force_defaults || bl != bl2) {
            this.addBoolean(bl);
            this.slot(n);
        }
    }

    public void addByte(int n, byte by, int n2) {
        if (this.force_defaults || by != n2) {
            this.addByte(by);
            this.slot(n);
        }
    }

    public void addShort(int n, short s, int n2) {
        if (this.force_defaults || s != n2) {
            this.addShort(s);
            this.slot(n);
        }
    }

    public void addInt(int n, int n2, int n3) {
        if (this.force_defaults || n2 != n3) {
            this.addInt(n2);
            this.slot(n);
        }
    }

    public void addLong(int n, long l, long l2) {
        if (this.force_defaults || l != l2) {
            this.addLong(l);
            this.slot(n);
        }
    }

    public void addFloat(int n, float f, double d) {
        if (this.force_defaults || (double)f != d) {
            this.addFloat(f);
            this.slot(n);
        }
    }

    public void addDouble(int n, double d, double d2) {
        if (this.force_defaults || d != d2) {
            this.addDouble(d);
            this.slot(n);
        }
    }

    public void addOffset(int n, int n2, int n3) {
        if (this.force_defaults || n2 != n3) {
            this.addOffset(n2);
            this.slot(n);
        }
    }

    public void addStruct(int n, int n2, int n3) {
        if (n2 != n3) {
            this.Nested(n2);
            this.slot(n);
        }
    }

    public void slot(int n) {
        this.vtable[n] = this.offset();
    }

    public int endObject() {
        int n;
        if (this.vtable == null || !this.nested) {
            throw new AssertionError((Object)"FlatBuffers: endObject called without startObject");
        }
        this.addInt(0);
        int n2 = this.offset();
        for (n = this.vtable_in_use - 1; n >= 0 && this.vtable[n] == 0; --n) {
        }
        int n3 = n + 1;
        while (n >= 0) {
            short s = (short)(this.vtable[n] != 0 ? n2 - this.vtable[n] : 0);
            this.addShort(s);
            --n;
        }
        this.addShort((short)(n2 - this.object_start));
        this.addShort((short)((n3 + 2) * 2));
        int n4 = 0;
        block2: for (n = 0; n < this.num_vtables; ++n) {
            int n5 = this.bb.capacity() - this.vtables[n];
            int n6 = this.space;
            int n7 = this.bb.getShort(n5);
            if (n7 != this.bb.getShort(n6)) continue;
            for (int i = 2; i < n7; i += 2) {
                if (this.bb.getShort(n5 + i) != this.bb.getShort(n6 + i)) continue block2;
            }
            n4 = this.vtables[n];
            break;
        }
        if (n4 != 0) {
            this.space = this.bb.capacity() - n2;
            this.bb.putInt(this.space, n4 - n2);
        } else {
            if (this.num_vtables == this.vtables.length) {
                this.vtables = Arrays.copyOf(this.vtables, this.num_vtables * 2);
            }
            this.vtables[this.num_vtables++] = this.offset();
            this.bb.putInt(this.bb.capacity() - n2, this.offset() - n2);
        }
        this.nested = false;
        return n2;
    }

    public void required(int n, int n2) {
        boolean bl;
        int n3 = this.bb.capacity() - n;
        int n4 = n3 - this.bb.getInt(n3);
        boolean bl2 = bl = this.bb.getShort(n4 + n2) != 0;
        if (!bl) {
            throw new AssertionError((Object)("FlatBuffers: field " + n2 + " must be set"));
        }
    }

    protected void finish(int n, boolean bl) {
        this.prep(this.minalign, 4 + (bl ? 4 : 0));
        this.addOffset(n);
        if (bl) {
            this.addInt(this.bb.capacity() - this.space);
        }
        this.bb.position(this.space);
        this.finished = true;
    }

    public void finish(int n) {
        this.finish(n, false);
    }

    public void finishSizePrefixed(int n) {
        this.finish(n, true);
    }

    protected void finish(int n, String string, boolean bl) {
        this.prep(this.minalign, 8 + (bl ? 4 : 0));
        if (string.length() != 4) {
            throw new AssertionError((Object)"FlatBuffers: file identifier must be length 4");
        }
        for (int i = 3; i >= 0; --i) {
            this.addByte((byte)string.charAt(i));
        }
        this.finish(n, bl);
    }

    public void finish(int n, String string) {
        this.finish(n, string, false);
    }

    public void finishSizePrefixed(int n, String string) {
        this.finish(n, string, true);
    }

    public FlatBufferBuilder forceDefaults(boolean bl) {
        this.force_defaults = bl;
        return this;
    }

    public ByteBuffer dataBuffer() {
        this.finished();
        return this.bb;
    }

    @Deprecated
    private int dataStart() {
        this.finished();
        return this.space;
    }

    public byte[] sizedByteArray(int n, int n2) {
        this.finished();
        byte[] byArray = new byte[n2];
        this.bb.position(n);
        this.bb.get(byArray);
        return byArray;
    }

    public byte[] sizedByteArray() {
        return this.sizedByteArray(this.space, this.bb.capacity() - this.space);
    }

    public InputStream sizedInputStream() {
        this.finished();
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.position(this.space);
        byteBuffer.limit(this.bb.capacity());
        return new ByteBufferBackedInputStream(byteBuffer);
    }

    static class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.buf.get() & 0xFF;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                return -1;
            }
        }
    }

    public static final class HeapByteBufferFactory
    extends ByteBufferFactory {
        public static final HeapByteBufferFactory INSTANCE = new HeapByteBufferFactory();

        @Override
        public ByteBuffer newByteBuffer(int n) {
            return ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public static abstract class ByteBufferFactory {
        public abstract ByteBuffer newByteBuffer(int var1);

        public void releaseByteBuffer(ByteBuffer byteBuffer) {
        }
    }
}

