/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.fbs.google;

import java.nio.ByteBuffer;
import uk.ac.bristol.star.fbs.google.Utf8Safe;

public abstract class Utf8 {
    private static Utf8 DEFAULT;

    public abstract int encodedLength(CharSequence var1);

    public abstract void encodeUtf8(CharSequence var1, ByteBuffer var2);

    public abstract String decodeUtf8(ByteBuffer var1, int var2, int var3);

    public static Utf8 getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Utf8Safe();
        }
        return DEFAULT;
    }

    public static void setDefault(Utf8 utf8) {
        DEFAULT = utf8;
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int n, int n2) {
            super("Unpaired surrogate at index " + n + " of " + n2);
        }
    }

    static class DecodeUtil {
        DecodeUtil() {
        }

        static boolean isOneByte(byte by) {
            return by >= 0;
        }

        static boolean isTwoBytes(byte by) {
            return by < -32;
        }

        static boolean isThreeBytes(byte by) {
            return by < -16;
        }

        static void handleOneByte(byte by, char[] cArray, int n) {
            cArray[n] = (char)by;
        }

        static void handleTwoBytes(byte by, byte by2, char[] cArray, int n) throws IllegalArgumentException {
            if (by < -62 || DecodeUtil.isNotTrailingByte(by2)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            cArray[n] = (char)((by & 0x1F) << 6 | DecodeUtil.trailingByteValue(by2));
        }

        static void handleThreeBytes(byte by, byte by2, byte by3, char[] cArray, int n) throws IllegalArgumentException {
            if (DecodeUtil.isNotTrailingByte(by2) || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || DecodeUtil.isNotTrailingByte(by3)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            cArray[n] = (char)((by & 0xF) << 12 | DecodeUtil.trailingByteValue(by2) << 6 | DecodeUtil.trailingByteValue(by3));
        }

        static void handleFourBytes(byte by, byte by2, byte by3, byte by4, char[] cArray, int n) throws IllegalArgumentException {
            if (DecodeUtil.isNotTrailingByte(by2) || (by << 28) + (by2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(by3) || DecodeUtil.isNotTrailingByte(by4)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            int n2 = (by & 7) << 18 | DecodeUtil.trailingByteValue(by2) << 12 | DecodeUtil.trailingByteValue(by3) << 6 | DecodeUtil.trailingByteValue(by4);
            cArray[n] = DecodeUtil.highSurrogate(n2);
            cArray[n + 1] = DecodeUtil.lowSurrogate(n2);
        }

        private static boolean isNotTrailingByte(byte by) {
            return by > -65;
        }

        private static int trailingByteValue(byte by) {
            return by & 0x3F;
        }

        private static char highSurrogate(int n) {
            return (char)(55232 + (n >>> 10));
        }

        private static char lowSurrogate(int n) {
            return (char)(56320 + (n & 0x3FF));
        }
    }
}

