/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.ColStat;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.FeatherType;

public abstract class AbstractColumnWriter
implements FeatherColumnWriter {
    private final String name_;
    private final FeatherType featherType_;
    private final long nrow_;
    private final boolean isNullable_;
    private final String userMeta_;

    protected AbstractColumnWriter(String string, FeatherType featherType, long l, boolean bl, String string2) {
        this.name_ = string;
        this.featherType_ = featherType;
        this.nrow_ = l;
        this.isNullable_ = bl;
        this.userMeta_ = string2;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public FeatherType getFeatherType() {
        return this.featherType_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public boolean isNullable() {
        return this.isNullable_;
    }

    @Override
    public String getUserMetadata() {
        return this.userMeta_;
    }

    @Override
    public ColStat writeColumnBytes(OutputStream outputStream) throws IOException {
        long l;
        long l2 = 0L;
        if (this.isNullable_) {
            long l3;
            int n = 0;
            int n2 = 0;
            for (l3 = 0L; l3 < this.nrow_; ++l3) {
                if (this.isNull(l3)) {
                    ++l2;
                } else {
                    n |= 1 << n2;
                }
                if (++n2 != 8) continue;
                outputStream.write(n);
                n2 = 0;
                n = 0;
            }
            if (n2 > 0) {
                outputStream.write(n);
            }
            l3 = (this.nrow_ + 7L) / 8L;
            l = l3 + (long)BufUtils.align8(outputStream, l3);
        } else {
            l = 0L;
        }
        long l4 = this.writeDataBytes(outputStream);
        l4 += (long)BufUtils.align8(outputStream, l4);
        boolean bl = l2 > 0L;
        final long l5 = l + l4;
        final long l6 = l;
        final long l7 = l2;
        return new ColStat(){

            @Override
            public long getRowCount() {
                return AbstractColumnWriter.this.nrow_;
            }

            @Override
            public long getByteCount() {
                return l5;
            }

            @Override
            public long getDataOffset() {
                return l6;
            }

            @Override
            public long getNullCount() {
                return l7;
            }
        };
    }

    public abstract boolean isNull(long var1);

    public abstract long writeDataBytes(OutputStream var1) throws IOException;
}

