/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.auth.BadChallengeException;

public class Challenge {
    private final String schemeName_;
    private final String realm_;
    private final Map<String, String> params_;
    private final String token68_;
    private static final String TOKEN = "[-!#$%&'*+.^_`|~0-9A-Za-z]+";
    private static final String TOKEN68 = "[-._~+/0-9A-Za-z]+=*";
    private static final String OWS = "[ \\t]*";
    private static final String BWS = "[ \\t]*";
    private static final String QUOTED_STRING = "\"(?:[^\"]|\\\\.)*\"";
    private static final String AUTH_PARAM = "[-!#$%&'*+.^_`|~0-9A-Za-z]+[ \\t]*=[ \\t]*(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\")";
    private static final String CHALLENGE = "[ \\t]*([-!#$%&'*+.^_`|~0-9A-Za-z]+)(| +[-._~+/0-9A-Za-z]+=*| +(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+[ \\t]*=[ \\t]*(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\")(?:[ \\t]*,[ \\t]*[-!#$%&'*+.^_`|~0-9A-Za-z]+[ \\t]*=[ \\t]*(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\"))*))[ \\t]*(?:,|$)";
    private static final String PPAIR = "([-!#$%&'*+.^_`|~0-9A-Za-z]+)[ \\t]*=[ \\t]*([-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\")[ \\t]*(?:,|$)";
    private static final Pattern CHALLENGE_REGEX = Pattern.compile("[ \\t]*([-!#$%&'*+.^_`|~0-9A-Za-z]+)(| +[-._~+/0-9A-Za-z]+=*| +(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+[ \\t]*=[ \\t]*(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\")(?:[ \\t]*,[ \\t]*[-!#$%&'*+.^_`|~0-9A-Za-z]+[ \\t]*=[ \\t]*(?:[-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\"))*))[ \\t]*(?:,|$)");
    private static final Pattern TOKEN68_REGEX = Pattern.compile("[-._~+/0-9A-Za-z]+=*");
    private static final Pattern PPAIR_REGEX = Pattern.compile("([-!#$%&'*+.^_`|~0-9A-Za-z]+)[ \\t]*=[ \\t]*([-!#$%&'*+.^_`|~0-9A-Za-z]+|\"(?:[^\"]|\\\\.)*\")[ \\t]*(?:,|$)");

    public Challenge(String schemeName, String realm, Map<String, String> params) {
        this.schemeName_ = schemeName;
        this.realm_ = realm;
        LinkedHashMap<String, String> pmap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            pmap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this.params_ = Collections.unmodifiableMap(pmap);
        this.token68_ = null;
    }

    public Challenge(String schemeName, String token68) {
        this.schemeName_ = schemeName;
        this.realm_ = null;
        this.params_ = Collections.emptyMap();
        this.token68_ = token68;
    }

    public String getSchemeName() {
        return this.schemeName_;
    }

    public String getRealm() {
        return this.realm_;
    }

    public String getToken68() {
        return this.token68_;
    }

    public Map<String, String> getParams() {
        return this.params_;
    }

    public String getRequiredRealm() throws BadChallengeException {
        if (this.realm_ != null && this.realm_.trim().length() > 0) {
            return this.realm_;
        }
        throw new BadChallengeException("No realm specified in challenge");
    }

    public String getRequiredParameter(String key) throws BadChallengeException {
        for (String k : this.params_.keySet()) {
            String value;
            if (!key.equalsIgnoreCase(k) || (value = this.params_.get(k)) == null || value.trim().length() <= 0) continue;
            return value;
        }
        throw new BadChallengeException("No parameter \"" + key + "\" specified in challenge");
    }

    public URL getRequiredParameterUrl(String key) throws BadChallengeException {
        String value = this.getRequiredParameter(key);
        try {
            return new URI(value).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new BadChallengeException("Parameter \"" + key + "\" is not a URL");
        }
    }

    public int hashCode() {
        int code = 5523221;
        code = 23 * code + this.schemeName_.toLowerCase().hashCode();
        code = 23 * code + Objects.hashCode(this.realm_);
        code = 23 * code + this.params_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof Challenge) {
            Challenge other = (Challenge)o;
            return this.schemeName_.equalsIgnoreCase(other.schemeName_) && Objects.equals(this.realm_, other.realm_) && this.params_.equals(other.params_);
        }
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.schemeName_);
        if (this.realm_ != null) {
            sbuf.append(", ").append("realm=\"").append(this.realm_).append("\"");
        }
        for (Map.Entry<String, String> entry : this.params_.entrySet()) {
            sbuf.append(", ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sbuf.toString();
    }

    public static List<Challenge> parseChallenges(String challengeTxt) {
        ArrayList<Challenge> list = new ArrayList<Challenge>();
        Matcher matcher = CHALLENGE_REGEX.matcher(challengeTxt);
        while (matcher.find()) {
            list.add(Challenge.createChallenge(matcher.group(1).trim(), matcher.group(2).trim()));
        }
        return list;
    }

    private static Challenge createChallenge(String schemeName, String extraTxt) {
        if (TOKEN68_REGEX.matcher(extraTxt).matches()) {
            return new Challenge(schemeName, extraTxt);
        }
        Matcher matcher = PPAIR_REGEX.matcher(extraTxt);
        String realm = null;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = Challenge.decodeValue(matcher.group(2));
            if ("realm".equalsIgnoreCase(key)) {
                realm = value;
                continue;
            }
            params.put(key, value);
        }
        return new Challenge(schemeName, realm, params);
    }

    private static String decodeValue(String value) {
        if (value.length() > 0 && value.startsWith("\"")) {
            StringBuffer sbuf = new StringBuffer();
            for (int i = 1; i < value.length() - 1; ++i) {
                char c = value.charAt(i);
                sbuf.append(c == '\\' ? value.charAt(++i) : c);
            }
            return sbuf.toString();
        }
        return value;
    }

    public static void main(String[] args) {
        int i = 0;
        for (Challenge ch : Challenge.parseChallenges(args[0])) {
            System.out.println("  " + ++i + ": " + ch);
        }
    }
}

