/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import uk.ac.bristol.star.feather.Buf;
import uk.ac.bristol.star.feather.BufMapper;
import uk.ac.bristol.star.feather.Decoder;
import uk.ac.bristol.star.feather.Reader;

public class FeatherColumn {
    private final String name_;
    private final long nrow_;
    private final BufMapper mapper_;
    private final Decoder<?> decoder_;
    private final long nNull_;
    private final String userMeta_;

    public FeatherColumn(String string, long l, BufMapper bufMapper, Decoder<?> decoder, long l2, String string2) {
        this.name_ = string;
        this.nrow_ = l;
        this.mapper_ = bufMapper;
        this.decoder_ = decoder;
        this.nNull_ = l2;
        this.userMeta_ = string2;
    }

    public String getName() {
        return this.name_;
    }

    public Decoder<?> getDecoder() {
        return this.decoder_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public String getUserMeta() {
        return this.userMeta_;
    }

    public long getNullCount() {
        return this.nNull_;
    }

    public Reader<?> createReader() throws IOException {
        if (this.nNull_ == 0L) {
            return this.decoder_.createReader(this.mapper_.mapBuffer(), this.nrow_);
        }
        long l = (this.nrow_ + 63L) / 64L * 8L;
        Buf buf = this.mapper_.mapBuffer(0L, l);
        Buf buf2 = this.mapper_.mapBuffer(l, this.mapper_.getLength() - l);
        return FeatherColumn.createMaskReader(this.decoder_.createReader(buf2, this.nrow_), buf);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.name_).append("(").append(this.decoder_);
        if (this.nNull_ > 0L) {
            stringBuffer.append(",nulls=").append(this.nNull_);
        }
        if (this.userMeta_ != null && this.userMeta_.trim().length() > 0) {
            stringBuffer.append(":").append('\"').append(this.userMeta_).append('\"');
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static <T> Reader<T> createMaskReader(final Reader<T> reader, final Buf buf) {
        return new Reader<T>(){

            private boolean isMask(long l) {
                return buf.isBitSet(l);
            }

            @Override
            public boolean isNull(long l) {
                return !this.isMask(l);
            }

            @Override
            public T getObject(long l) {
                return this.isMask(l) ? (Object)reader.getObject(l) : null;
            }

            @Override
            public byte getByte(long l) {
                return this.isMask(l) ? Byte.valueOf(reader.getByte(l)) : null;
            }

            @Override
            public short getShort(long l) {
                return this.isMask(l) ? Short.valueOf(reader.getShort(l)) : null;
            }

            @Override
            public int getInt(long l) {
                return this.isMask(l) ? Integer.valueOf(reader.getInt(l)) : null;
            }

            @Override
            public long getLong(long l) {
                return this.isMask(l) ? Long.valueOf(reader.getLong(l)) : null;
            }

            @Override
            public float getFloat(long l) {
                return this.isMask(l) ? reader.getFloat(l) : Float.NaN;
            }

            @Override
            public double getDouble(long l) {
                return this.isMask(l) ? reader.getDouble(l) : Double.NaN;
            }

            @Override
            public Class<T> getValueClass() {
                return reader.getValueClass();
            }
        };
    }
}

