/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import uk.ac.starlink.util.gui.ArrayTableColumn;
import uk.ac.starlink.util.gui.ArrayTableModel;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;

public class ResourceTableModel
extends ArrayTableModel<RegResource> {
    public ResourceTableModel() {
        this(false);
    }

    public ResourceTableModel(boolean includeAcref) {
        super((Object[])new RegResource[0]);
        ArrayList<StringColumn> colList = new ArrayList<StringColumn>();
        colList.add(new StringColumn("Short Name"){

            public String getValue(RegResource res) {
                return res.getShortName();
            }
        });
        colList.add(new StringColumn("Title"){

            public String getValue(RegResource res) {
                return res.getTitle();
            }
        });
        colList.add(new StringColumn("Subjects"){

            public String getValue(RegResource res) {
                return ResourceTableModel.arrayToString(res.getSubjects());
            }
        });
        colList.add(new StringColumn("Identifier"){

            public String getValue(RegResource res) {
                return res.getIdentifier();
            }
        });
        colList.add(new StringColumn("Publisher"){

            public String getValue(RegResource res) {
                return res.getPublisher();
            }
        });
        colList.add(new StringColumn("Contact"){

            public String getValue(RegResource res) {
                return res.getContact();
            }
        });
        colList.add(new StringColumn("Reference URL"){

            public String getValue(RegResource res) {
                return res.getReferenceUrl();
            }
        });
        if (includeAcref) {
            colList.add(new StringColumn("soleAccessURL"){

                public String getValue(RegResource res) {
                    RegCapabilityInterface[] caps = res.getCapabilities();
                    return caps != null && caps.length == 1 ? caps[0].getAccessUrl() : null;
                }
            });
        }
        this.setColumns(colList);
    }

    public void setResources(RegResource[] resources) {
        super.setItems((Object[])resources);
    }

    public RegResource[] getResources() {
        return (RegResource[])super.getItems();
    }

    private static String arrayToString(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int iv = 0; iv < values.length; ++iv) {
            String val = values[iv];
            if (val == null || val.trim().length() <= 0) continue;
            if (sbuf.length() > 0) {
                sbuf.append(", ");
            }
            sbuf.append(val.trim());
        }
        return sbuf.toString();
    }

    private static abstract class StringColumn
    extends ArrayTableColumn<RegResource, String> {
        StringColumn(String name) {
            super(name, String.class);
        }
    }
}

