/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.IOFunction;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.MetaNameFixer;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetTapMetaReader;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapSchemaInterrogator;
import uk.ac.starlink.vo.TapSchemaTapMetaReader;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.VizierTapMetaReader;
import uk.ac.starlink.vo.Vosi11TapMetaReader;

public abstract class TapMetaPolicy {
    private final String name_;
    private final String description_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    public static final TapMetaPolicy AUTO = new TapMetaPolicy("Auto", "Chooses a suitable place to get table metadata depending on the service"){

        @Override
        public TapMetaReader createMetaReader(TapService service, ContentCoding coding) {
            return TapMetaPolicy.createAutoMetaReader(service, coding, 20000);
        }
    };
    public static final TapMetaPolicy VOSI10;
    public static final TapMetaPolicy TAPSCHEMA_C;
    public static final TapMetaPolicy TAPSCHEMA_CF;
    public static final TapMetaPolicy TAPSCHEMA;
    public static final TapMetaPolicy VIZIER;
    public static final TapMetaPolicy VOSI11_MAX;
    public static final TapMetaPolicy VOSI11_MIN;
    public static final TapMetaPolicy VOSI11_NULL;
    private static final TapMetaPolicy[] KNOWN_VALUES;

    protected TapMetaPolicy(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public abstract TapMetaReader createMetaReader(TapService var1, ContentCoding var2);

    public static TapMetaPolicy[] getStandardInstances() {
        return (TapMetaPolicy[])KNOWN_VALUES.clone();
    }

    public static TapMetaPolicy getDefaultInstance() {
        return AUTO;
    }

    static void sortSchemas(SchemaMeta[] smetas) {
        Arrays.sort(smetas, new Comparator<SchemaMeta>(){

            @Override
            public int compare(SchemaMeta s1, SchemaMeta s2) {
                return this.getSchemaName(s1).compareTo(this.getSchemaName(s2));
            }

            private String getSchemaName(SchemaMeta smeta) {
                String name = smeta.getName();
                return name == null ? "" : name;
            }
        });
    }

    static void sortTables(TableMeta[] tmetas) {
        Arrays.sort(tmetas, new Comparator<TableMeta>(){

            @Override
            public int compare(TableMeta t1, TableMeta t2) {
                return this.getTableName(t1).compareTo(this.getTableName(t2));
            }

            private String getTableName(TableMeta tmeta) {
                String name = tmeta.getName();
                return name == null ? "" : name;
            }
        });
    }

    private static TapMetaPolicy createVosi11Policy(String name, final Vosi11TapMetaReader.DetailMode dmode) {
        String descrip = new StringBuffer().append("Reads metadata from the VOSI-1.1 /tables endpoint;\n").append(dmode.getDescription()).toString();
        return new TapMetaPolicy(name, descrip){

            @Override
            public TapMetaReader createMetaReader(TapService service, ContentCoding coding) {
                URL tablesUrl = service.getTablesEndpoint();
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                return new Vosi11TapMetaReader(tablesUrl, fixer, coding, dmode);
            }
        };
    }

    private static TapMetaPolicy createTapSchemaPolicy(String name, final boolean popTables, final boolean preloadKeys) {
        StringBuffer sbuf = new StringBuffer().append("Reads metadata by making synchronous queries ").append("on the TAP_SCHEMA tables; ");
        if (popTables) {
            assert (!preloadKeys);
            sbuf.append("metadata for all tables is read at once");
        } else if (preloadKeys) {
            sbuf.append("foreign keys are all read at once, ").append("columns are read as required");
        } else {
            sbuf.append("columns and foreign keys are read as required");
        }
        return new TapMetaPolicy(name, sbuf.toString()){

            @Override
            public TapMetaReader createMetaReader(TapService service, ContentCoding coding) {
                int maxrec = 99999;
                boolean popSchemas = true;
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                return new TapSchemaTapMetaReader(service, maxrec, coding, popSchemas, popTables, fixer, preloadKeys);
            }
        };
    }

    private static TapMetaReader createAutoMetaReader(TapService service, ContentCoding coding, int maxrow) {
        MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
        long ncol = TapMetaPolicy.readRowCount(service, TapSchemaInterrogator.COLUMN_QUERIER.getTableName());
        boolean manyCols = ncol >= 0L && ncol > (long)maxrow;
        String prefMsg = manyCols ? "Many columns in TAP service (" + ncol + " > " + maxrow + "); prefer reading tables up front and columns as required" : "Not many columns in TAP service (" + ncol + " <= " + maxrow + "); prefer reading table and column metadata up front";
        logger_.info(prefMsg);
        Vosi11TapMetaReader.DetailMode detailMode = manyCols ? Vosi11TapMetaReader.DetailMode.MIN : Vosi11TapMetaReader.DetailMode.MAX;
        Vosi11TapMetaReader preferredReader = new Vosi11TapMetaReader(service.getTablesEndpoint(), fixer, coding, detailMode);
        Supplier<TapMetaReader> fallbackReaderSupplier = () -> {
            boolean preloadFkeys;
            String linkTableName = TapSchemaInterrogator.LINK_QUERIER.getTableName();
            long nlink = TapMetaPolicy.readRowCount(service, linkTableName);
            boolean bl = preloadFkeys = nlink < 0L || nlink <= (long)maxrow;
            if (nlink >= 0L) {
                String msg = new StringBuffer().append(preloadFkeys ? "Not many" : "Many").append(" rows in ").append(linkTableName).append(" (").append(nlink).append(preloadFkeys ? " <= " : " > ").append(maxrow).append(");").append(preloadFkeys ? " preload all foreign keys" : " no preload").toString();
                logger_.info(msg);
            }
            int maxrec = (int)Math.min(Integer.MAX_VALUE, Math.max(ncol + 1L, nlink + 1L));
            boolean popSchema = true;
            boolean popTable = !manyCols;
            return new TapSchemaTapMetaReader(service, maxrec, coding, popSchema, popTable, fixer, preloadFkeys);
        };
        return new FallbackTapMetaReader(preferredReader, fallbackReaderSupplier);
    }

    private static long readRowCount(TapService service, String tableName) {
        Number nrow;
        String adql = "SELECT COUNT(*) AS nrow FROM " + tableName;
        try {
            nrow = TapQuery.scalarQuery(service, adql, Number.class);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Row count for " + tableName + " failed: " + e, e);
            return -1L;
        }
        if (nrow == null) {
            logger_.log(Level.WARNING, "No row count result for " + tableName);
            return -1L;
        }
        return nrow.longValue();
    }

    static {
        TAPSCHEMA_C = TapMetaPolicy.createTapSchemaPolicy("TAP_SCHEMA-C", false, true);
        KNOWN_VALUES = new TapMetaPolicy[]{AUTO, TAPSCHEMA_C, TAPSCHEMA_CF = TapMetaPolicy.createTapSchemaPolicy("TAP_SCHEMA-CF", false, false), TAPSCHEMA = TapMetaPolicy.createTapSchemaPolicy("TAP_SCHEMA", true, false), VOSI11_NULL = TapMetaPolicy.createVosi11Policy("TableSet-VOSI1.1", Vosi11TapMetaReader.DetailMode.NULL), VOSI11_MAX = TapMetaPolicy.createVosi11Policy("TableSet-VOSI1.1-1step", Vosi11TapMetaReader.DetailMode.MAX), VOSI11_MIN = TapMetaPolicy.createVosi11Policy("TableSet-VOSI1.1-2step", Vosi11TapMetaReader.DetailMode.MIN), VOSI10 = new TapMetaPolicy("TableSet-VOSI1.0", "Reads all metadata in one go from the VOSI-1.0 /tables endpoint"){

            @Override
            public TapMetaReader createMetaReader(TapService service, ContentCoding coding) {
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                URL tablesUrl = service.getTablesEndpoint();
                return new TableSetTapMetaReader(tablesUrl, fixer, coding);
            }
        }, VIZIER = new TapMetaPolicy("VizieR", "Uses TAPVizieR's non-standard two-stage VOSI tables endpoint"){

            @Override
            public TapMetaReader createMetaReader(TapService service, ContentCoding coding) {
                URL tablesetUrl = service.getTablesEndpoint();
                MetaNameFixer fixer = MetaNameFixer.createDefaultFixer();
                return new VizierTapMetaReader(tablesetUrl, fixer, coding);
            }
        }};
    }

    private static class FallbackTapMetaReader
    implements TapMetaReader {
        private TapMetaReader reader_;
        private Boolean isWorking_;
        final Supplier<TapMetaReader> fallbackReaderSupplier_;

        FallbackTapMetaReader(TapMetaReader preferredReader, Supplier<TapMetaReader> fallbackReaderSupplier) {
            this.reader_ = preferredReader;
            this.fallbackReaderSupplier_ = fallbackReaderSupplier;
        }

        @Override
        public String getMeans() {
            return this.reader_.getMeans();
        }

        @Override
        public String getSource() {
            return this.reader_.getSource();
        }

        @Override
        public SchemaMeta[] readSchemas() throws IOException {
            return (SchemaMeta[])this.fallbackRead((IOFunction<TapMetaReader, T[]>)((IOFunction)rdr -> rdr.readSchemas()));
        }

        @Override
        public TableMeta[] readTables(SchemaMeta schema) throws IOException {
            return (TableMeta[])this.fallbackRead((IOFunction<TapMetaReader, T[]>)((IOFunction)rdr -> rdr.readTables(schema)));
        }

        @Override
        public ColumnMeta[] readColumns(TableMeta table) throws IOException {
            return (ColumnMeta[])this.fallbackRead((IOFunction<TapMetaReader, T[]>)((IOFunction)rdr -> rdr.readColumns(table)));
        }

        @Override
        public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
            return (ForeignMeta[])this.fallbackRead((IOFunction<TapMetaReader, T[]>)((IOFunction)rdr -> rdr.readForeignKeys(table)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T[] fallbackRead(IOFunction<TapMetaReader, T[]> readFunc) throws IOException {
            TapMetaReader rdr;
            String msg;
            FallbackTapMetaReader fallbackTapMetaReader = this;
            synchronized (fallbackTapMetaReader) {
                if (this.isWorking_ == null) {
                    try {
                        Object[] result = (Object[])readFunc.apply((Object)this.reader_);
                        this.isWorking_ = Boolean.TRUE;
                        Object msg2 = null;
                        return result;
                    }
                    catch (IOException e) {
                        String means1 = this.reader_.getMeans();
                        this.reader_ = this.fallbackReaderSupplier_.get();
                        String means2 = this.reader_.getMeans();
                        msg = "TAP metadata read failure from " + means1 + "; fallback to " + means2;
                        this.isWorking_ = Boolean.FALSE;
                    }
                } else {
                    msg = null;
                }
                rdr = this.reader_;
            }
            if (msg != null) {
                logger_.warning(msg);
            }
            return (Object[])readFunc.apply((Object)rdr);
        }
    }
}

