/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapMetaOrder;

public class TapMetaTreeModel
implements TreeModel {
    private final List<TreeModelListener> listeners_ = new ArrayList<TreeModelListener>();
    private SchemaMeta[] schemas_;
    private TapMetaOrder order_;

    public TapMetaTreeModel(SchemaMeta[] schemas, TapMetaOrder order) {
        this.order_ = order;
        this.setSchemas(schemas);
    }

    public void setSchemas(SchemaMeta[] schemas) {
        this.schemas_ = schemas;
        this.order_.sortSchemas(this.schemas_);
        TreeModelEvent evt = new TreeModelEvent((Object)this, new Object[]{schemas});
        for (TreeModelListener lnr : this.listeners_) {
            lnr.treeStructureChanged(evt);
        }
    }

    public TapMetaOrder getOrder() {
        return this.order_;
    }

    public void setOrder(TapMetaOrder order) {
        this.order_ = order;
        this.setSchemas(this.schemas_);
    }

    public SchemaMeta[] getSchemas() {
        return this.schemas_;
    }

    public TreePath getPathForTableName(String tname) {
        if (this.schemas_ != null && tname != null) {
            for (SchemaMeta schema : this.schemas_) {
                for (TableMeta table : schema.getTables()) {
                    String cmpName = table.getName();
                    if (cmpName != null && cmpName.startsWith("\"")) {
                        cmpName = cmpName.replace("\"", "");
                    }
                    if (!tname.equalsIgnoreCase(cmpName)) continue;
                    return new TreePath(new Object[]{this.getRoot(), schema, table});
                }
            }
        }
        return null;
    }

    @Override
    public Object getRoot() {
        return this.schemas_;
    }

    @Override
    public boolean isLeaf(Object node) {
        return TapMetaTreeModel.asTapNode(node).isLeaf();
    }

    @Override
    public int getChildCount(Object parent) {
        Object[] children = TapMetaTreeModel.asTapNode((Object)parent).children_;
        return children == null ? 0 : children.length;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return TapMetaTreeModel.asTapNode((Object)parent).children_[index];
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Object[] children;
        if (parent != null && child != null && (children = TapMetaTreeModel.asTapNode((Object)parent).children_) != null) {
            int nc = children.length;
            for (int ic = 0; ic < nc; ++ic) {
                if (children[ic] != child) continue;
                return ic;
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        assert (false) : "Tree is not editable from GUI";
    }

    @Override
    public void addTreeModelListener(TreeModelListener lnr) {
        this.listeners_.add(lnr);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener lnr) {
        this.listeners_.remove(lnr);
    }

    public static TableMeta getTable(TreePath path) {
        if (path != null) {
            for (Object element : path.getPath()) {
                if (!(element instanceof TableMeta)) continue;
                return (TableMeta)element;
            }
        }
        return null;
    }

    public static SchemaMeta getSchema(TreePath path) {
        if (path != null) {
            for (Object element : path.getPath()) {
                if (!(element instanceof SchemaMeta)) continue;
                return (SchemaMeta)element;
            }
        }
        return null;
    }

    private static TapNode asTapNode(Object node) {
        if (node instanceof SchemaMeta[]) {
            Object[] schemas = (SchemaMeta[])node;
            return new TapNode(schemas);
        }
        if (node instanceof SchemaMeta) {
            SchemaMeta schema = (SchemaMeta)node;
            return new TapNode(schema.getTables());
        }
        assert (node instanceof TableMeta);
        return new TapNode(null);
    }

    private static class TapNode {
        final Object[] children_;

        TapNode(Object[] children) {
            this.children_ = children;
        }

        boolean isLeaf() {
            return this.children_ == null;
        }
    }
}

