/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.AuthStatus;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.DaliExample;
import uk.ac.starlink.vo.DaliExampleReader;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.LinkedBlockingStack;
import uk.ac.starlink.vo.RegRole;
import uk.ac.starlink.vo.ResultHandler;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapabilitiesDoc;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapMetaPolicy;
import uk.ac.starlink.vo.TapMetaReader;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapServices;
import uk.ac.starlink.vo.TapTableLoadDialog;
import uk.ac.starlink.vo.Tree;

public class TapServiceKit {
    private final TapService service_;
    private final String ivoid_;
    private final TapMetaPolicy metaPolicy_;
    private final ContentCoding coding_;
    private final int queueLimit_;
    private final Map<Populator<?>, Collection<Runnable>> runningMap_;
    private ExecutorService metaExecutor_;
    private volatile FutureTask<TapMetaReader> rdrFuture_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public TapServiceKit(TapService service, String ivoid, TapMetaPolicy metaPolicy, ContentCoding coding, int queueLimit) {
        this.service_ = service;
        this.ivoid_ = ivoid;
        this.metaPolicy_ = metaPolicy;
        this.coding_ = coding;
        this.queueLimit_ = queueLimit;
        this.runningMap_ = new HashMap();
    }

    public TapService getTapService() {
        return this.service_;
    }

    public String getIvoid() {
        return this.ivoid_;
    }

    public boolean onTables(final SchemaMeta smeta, Runnable callback) {
        return this.onData(callback, new Populator<TableMeta>(TableMeta.class, "tables", (Object)smeta){

            @Override
            public boolean hasData() {
                return smeta.getTables() != null;
            }

            public TableMeta[] readData(TapMetaReader rdr) throws IOException {
                return rdr.readTables(smeta);
            }

            public void updateData(TableMeta[] tmetas) {
                smeta.setTables(tmetas);
            }
        });
    }

    public boolean onColumns(final TableMeta tmeta, Runnable callback) {
        return this.onData(callback, new Populator<ColumnMeta>(ColumnMeta.class, "columns", (Object)tmeta){

            @Override
            public boolean hasData() {
                return tmeta.getColumns() != null;
            }

            public ColumnMeta[] readData(TapMetaReader rdr) throws IOException {
                return rdr.readColumns(tmeta);
            }

            public void updateData(ColumnMeta[] cmetas) {
                tmeta.setColumns(cmetas);
            }
        });
    }

    public boolean onForeignKeys(final TableMeta tmeta, Runnable callback) {
        return this.onData(callback, new Populator<ForeignMeta>(ForeignMeta.class, "foreign keys", (Object)tmeta){

            @Override
            public boolean hasData() {
                return tmeta.getForeignKeys() != null;
            }

            public ForeignMeta[] readData(TapMetaReader rdr) throws IOException {
                return rdr.readForeignKeys(tmeta);
            }

            public void updateData(ForeignMeta[] fmetas) {
                tmeta.setForeignKeys(fmetas);
            }
        });
    }

    public void acquireSchemas(ResultHandler<SchemaMeta[]> handler) {
        this.acquireData(handler, () -> {
            TapMetaReader rdr = this.acquireMetaReader();
            try {
                return rdr.readSchemas();
            }
            catch (IOException e) {
                throw new IOException(rdr.getSource() + " error: " + e, e);
            }
        });
    }

    public void acquireCapability(ResultHandler<TapCapability> handler) {
        this.acquireData(handler, () -> {
            URL curl = this.service_.getCapabilitiesEndpoint();
            if (curl == null) {
                throw new IOException("No capabilities endpoint");
            }
            logger_.info("Reading capability metadata from " + curl);
            try {
                return TapCapabilitiesDoc.readCapabilities(curl).getTapCapability();
            }
            catch (SAXException e) {
                throw new IOException("Capability parse error: " + e, e);
            }
        });
    }

    public void acquireResource(ResultHandler<Map<String, String>> handler) {
        this.acquireData(handler, () -> TapServiceKit.readResourceInfo(this.getRegTapService(), this.ivoid_));
    }

    public void acquireRoles(ResultHandler<RegRole[]> handler) {
        this.acquireData(handler, () -> RegRole.readRoles(this.getRegTapService(), this.ivoid_, this.coding_));
    }

    public void acquireExamples(ResultHandler<List<Tree<DaliExample>>> handler) {
        URL examplesUrl = this.service_.getExamplesEndpoint();
        if (examplesUrl != null) {
            this.acquireData(handler, () -> new DaliExampleReader().readExamples(examplesUrl));
        } else {
            logger_.warning("No examples endpoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireAuthStatus(final ResultHandler<AuthStatus> handler, boolean forceLogin) {
        Map<Populator<?>, Collection<Runnable>> map = this.runningMap_;
        synchronized (map) {
            this.runningMap_.clear();
        }
        boolean isHead = true;
        final URL authcheckUrl = this.service_.getCapabilitiesEndpoint();
        ResultHandler<AuthStatus> loggingHandler = new ResultHandler<AuthStatus>(){

            @Override
            public boolean isActive() {
                return handler.isActive();
            }

            @Override
            public void showWaiting() {
                handler.showWaiting();
            }

            @Override
            public void showError(IOException error) {
                logger_.log(Level.WARNING, "Failed to acquire authentication status at " + authcheckUrl + ": " + error, error);
                handler.showError(error);
            }

            @Override
            public void showResult(AuthStatus status) {
                logger_.info("Authentication status: " + status + " (" + authcheckUrl + ")");
                handler.showResult(status);
            }
        };
        this.acquireData(loggingHandler, () -> AuthManager.getInstance().authcheck(authcheckUrl, true, forceLogin));
    }

    public TapService getRegTapService() {
        return TapServices.getRegTapService();
    }

    public void shutdown() {
        if (this.metaExecutor_ != null) {
            this.metaExecutor_.shutdownNow();
            this.metaExecutor_ = null;
        }
    }

    public TapMetaReader getMetaReader() {
        FutureTask<TapMetaReader> rdrFuture = this.rdrFuture_;
        if (rdrFuture != null && rdrFuture.isDone()) {
            try {
                return rdrFuture.get(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TapMetaReader acquireMetaReader() {
        TapServiceKit tapServiceKit = this;
        synchronized (tapServiceKit) {
            if (this.rdrFuture_ == null) {
                this.rdrFuture_ = new FutureTask<TapMetaReader>(() -> this.metaPolicy_.createMetaReader(this.service_, this.coding_));
                this.rdrFuture_.run();
            }
        }
        try {
            return this.rdrFuture_.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ErrorMetaReader("interrupted", e);
        }
        catch (ExecutionException e) {
            return new ErrorMetaReader(e.getCause().getMessage(), e);
        }
    }

    private boolean onData(final Runnable callback, final Populator<?> populator) {
        if (populator.hasData()) {
            callback.run();
            return true;
        }
        try {
            this.getMetaExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    if (populator.populateCompleted_) {
                        SwingUtilities.invokeLater(callback);
                    } else {
                        TapServiceKit.this.populateAndCallback(populator, callback);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger_.log(Level.INFO, "Will not read TAP metadata this time (" + populator.getDataDescription() + ")", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAndCallback(final Populator<?> populator, Runnable callback) {
        Collection<Runnable> callbacks;
        Map<Populator<?>, Collection<Runnable>> map = this.runningMap_;
        synchronized (map) {
            if (this.runningMap_.containsKey(populator)) {
                this.runningMap_.get(populator).add(callback);
                return;
            }
            ArrayList<Runnable> callbacks2 = new ArrayList<Runnable>();
            callbacks2.add(callback);
            this.runningMap_.put(populator, callbacks2);
        }
        populator.populate(this.acquireMetaReader());
        populator.populateCompleted_ = true;
        Map<Populator<?>, Collection<Runnable>> map2 = this.runningMap_;
        synchronized (map2) {
            callbacks = this.runningMap_.remove(populator);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (populator.hasData());
                for (Runnable cb : callbacks) {
                    cb.run();
                }
            }
        });
    }

    private <T> void acquireData(final ResultHandler<T> handler, final IOSupplier<T> supplier) {
        if (!handler.isActive()) {
            return;
        }
        handler.showWaiting();
        this.getMetaExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Object data;
                if (!handler.isActive()) {
                    return;
                }
                try {
                    data = supplier.get();
                }
                catch (Throwable error) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (handler.isActive()) {
                                handler.showError(TapTableLoadDialog.asIOException((Throwable)error));
                            }
                        }
                    });
                    return;
                }
                final Object data0 = data;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (handler.isActive()) {
                            handler.showResult(data0);
                        }
                    }
                });
            }
        });
    }

    private static Map<String, String> readResourceInfo(TapService regtapService, String ivoid) throws IOException {
        String[] items = new String[]{"short_name", "res_title", "res_description", "reference_url"};
        StringBuffer adql = new StringBuffer().append("SELECT");
        for (int i = 0; i < items.length; ++i) {
            adql.append(i == 0 ? " " : ", ").append(items[i]);
        }
        adql.append(" FROM rr.resource").append(" WHERE ivoid='").append(ivoid).append("'");
        TapQuery tq = new TapQuery(regtapService, adql.toString(), null);
        StarTable result = tq.executeSync(StoragePolicy.PREFER_MEMORY, ContentCoding.NONE);
        result = Tables.randomTable((StarTable)result);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        int ncol = result.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            Object value = result.getCell(0L, icol);
            if (!(value instanceof String)) continue;
            resultMap.put(items[icol], (String)value);
        }
        return resultMap;
    }

    private ExecutorService getMetaExecutor() {
        if (this.metaExecutor_ == null) {
            this.metaExecutor_ = TapServiceKit.createExecutorService(this.queueLimit_);
        }
        return this.metaExecutor_;
    }

    private static ExecutorService createExecutorService(int queueLimit) {
        BoundedBlockingStack<Runnable> queue = new BoundedBlockingStack<Runnable>(queueLimit);
        RejectedExecutionHandler rejectHandler = new RejectedExecutionHandler(){
            private final RejectedExecutionHandler dfltHandler = new ThreadPoolExecutor.AbortPolicy();

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                BlockingQueue<Runnable> q = e.getQueue();
                if (q instanceof BoundedBlockingStack) {
                    if (!e.isShutdown()) {
                        ((BoundedBlockingStack)q).removeTail();
                        logger_.log(Level.INFO, "Discard metadata request");
                        e.execute(r);
                    }
                } else {
                    assert (false);
                    this.dfltHandler.rejectedExecution(r, e);
                }
            }
        };
        int corePoolSize = 1;
        int maxPoolSize = 1;
        ThreadFactory thFact = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, "TAP metadata query");
                th.setDaemon(true);
                return th;
            }
        };
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 30L, TimeUnit.SECONDS, queue, thFact, rejectHandler);
    }

    private static class BoundedBlockingStack<E>
    extends LinkedBlockingStack<E> {
        private final int capacity_;
        private final Lock lock_;

        BoundedBlockingStack(int capacity) {
            this.capacity_ = capacity;
            this.lock_ = this.getLock();
        }

        @Override
        public boolean add(E o) {
            this.lock_.lock();
            try {
                if (this.remainingCapacity() > 0) {
                    boolean bl = super.add(o);
                    return bl;
                }
                throw new IllegalStateException("Queue full");
            }
            finally {
                this.lock_.unlock();
            }
        }

        @Override
        public boolean offer(E o) {
            this.lock_.lock();
            try {
                boolean bl = this.remainingCapacity() > 0 && super.offer(o);
                return bl;
            }
            finally {
                this.lock_.unlock();
            }
        }

        @Override
        public int remainingCapacity() {
            return Math.max(0, this.capacity_ - this.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E removeTail() {
            this.lock_.lock();
            try {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object item = it.next();
                    if (it.hasNext()) continue;
                    it.remove();
                    Object e = item;
                    return e;
                }
                E e = null;
                return e;
            }
            finally {
                this.lock_.unlock();
            }
        }
    }

    private static class ErrorMetaReader
    implements TapMetaReader {
        final Exception error_;
        final String msg_;

        ErrorMetaReader(String msg, Exception error) {
            this.error_ = error;
            this.msg_ = msg;
        }

        @Override
        public String getSource() {
            return "No source (" + this.error_ + ")";
        }

        @Override
        public String getMeans() {
            return "No method (" + this.error_ + ")";
        }

        @Override
        public SchemaMeta[] readSchemas() throws IOException {
            throw this.rethrown();
        }

        @Override
        public TableMeta[] readTables(SchemaMeta schema) throws IOException {
            throw this.rethrown();
        }

        @Override
        public ColumnMeta[] readColumns(TableMeta table) throws IOException {
            throw this.rethrown();
        }

        @Override
        public ForeignMeta[] readForeignKeys(TableMeta table) throws IOException {
            throw this.rethrown();
        }

        private IOException rethrown() {
            return (IOException)new IOException("No metadata reader: " + this.msg_).initCause(this.error_);
        }
    }

    private static abstract class Populator<T> {
        private final Class<T> clazz_;
        private final String metasType_;
        private final Object id_;
        volatile boolean populateCompleted_;

        Populator(Class<T> clazz, String metasType, Object id) {
            this.clazz_ = clazz;
            this.metasType_ = metasType;
            this.id_ = id;
        }

        abstract boolean hasData();

        abstract T[] readData(TapMetaReader var1) throws IOException;

        abstract void updateData(T[] var1);

        void populate(TapMetaReader rdr) {
            final Object[] data = this.getData(rdr);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.updateData(data);
                }
            });
        }

        private T[] getData(TapMetaReader rdr) {
            try {
                return this.readData(rdr);
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Failed to read TAP metadata " + this.getDataDescription(), e);
                Object[] emptyArray = (Object[])Array.newInstance(this.clazz_, 0);
                return emptyArray;
            }
        }

        public String getDataDescription() {
            return this.metasType_ + " for " + this.id_;
        }

        public int hashCode() {
            return this.id_.hashCode();
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass()) && this.id_.equals(((Populator)o).id_);
        }
    }
}

