/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class Tree<T> {
    private Tree() {
    }

    public abstract boolean isLeaf();

    public abstract Leaf<T> asLeaf();

    public abstract Branch<T> asBranch();

    public abstract <R> Tree<R> map(Function<T, R> var1);

    public static class Branch<T>
    extends Tree<T> {
        private final String label_;
        private final List<Tree<T>> children_;

        public Branch(List<Tree<T>> children, String label) {
            this.label_ = label;
            this.children_ = children;
        }

        public List<Tree<T>> getChildren() {
            return this.children_;
        }

        public String getLabel() {
            return this.label_;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public Leaf<T> asLeaf() {
            return null;
        }

        @Override
        public Branch<T> asBranch() {
            return this;
        }

        @Override
        public <R> Branch<R> map(Function<T, R> mapping) {
            return new Branch<T>(this.children_.stream().map((? super T t) -> t.map(mapping)).collect(Collectors.toList()), this.label_);
        }
    }

    public static class Leaf<T>
    extends Tree<T> {
        private final T item_;

        public Leaf(T item) {
            this.item_ = item;
        }

        public T getItem() {
            return this.item_;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Leaf<T> asLeaf() {
            return this;
        }

        @Override
        public Branch<T> asBranch() {
            return null;
        }

        @Override
        public <R> Leaf<R> map(Function<T, R> mapping) {
            return new Leaf<R>(mapping.apply(this.item_));
        }
    }
}

