/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsJobPanel;
import uk.ac.starlink.vo.UwsStage;

public class UwsJobListPanel
extends JPanel {
    private final DefaultListModel<UwsJob> listModel_ = new DefaultListModel();
    private final JList<UwsJob> jlist_;
    private final UwsJobPanel detail_;
    private final JTextField urlField_;
    private final Action deleteAction_;
    private final Action abortAction_;
    private final JToggleButton.ToggleButtonModel delOnExitModel_;
    private final Map<UwsJob, UwsJob.JobWatcher> jobWatcherMap_ = new HashMap<UwsJob, UwsJob.JobWatcher>();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public UwsJobListPanel() {
        super(new BorderLayout());
        this.jlist_ = new JList<UwsJob>(this.listModel_);
        this.jlist_.setSelectionMode(0);
        this.jlist_.setCellRenderer(new UwsJobCellRenderer());
        this.detail_ = new UwsJobPanel(false);
        this.urlField_ = new JTextField();
        this.urlField_.setEditable(false);
        this.jlist_.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                UwsJob job = (UwsJob)UwsJobListPanel.this.jlist_.getSelectedValue();
                UwsJobListPanel.this.detail_.setJob(job);
                UwsJobListPanel.this.urlField_.setText(job == null ? null : job.getJobUrl().toString());
                UwsJobListPanel.this.updateActions();
            }
        });
        this.deleteAction_ = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final UwsJob job = UwsJobListPanel.this.detail_.getJob();
                if (job != null) {
                    UwsJobListPanel.this.removeJob(job);
                    new Thread(){

                        @Override
                        public void run() {
                            job.attemptDelete();
                        }
                    }.start();
                } else assert (false);
            }
        };
        this.abortAction_ = new AbstractAction("Abort"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final UwsJob job = UwsJobListPanel.this.detail_.getJob();
                if (job != null) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                job.postPhase("ABORT");
                            }
                            catch (IOException e) {
                                logger_.warning("ABORT failed for job " + job);
                            }
                        }
                    }.start();
                } else assert (false);
            }
        };
        this.delOnExitModel_ = new JToggleButton.ToggleButtonModel();
        this.delOnExitModel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean delOnExit = UwsJobListPanel.this.delOnExitModel_.isSelected();
                UwsJob job = UwsJobListPanel.this.detail_.getJob();
                if (job != null && job.getDeleteOnExit() != delOnExit) {
                    job.setDeleteOnExit(delOnExit);
                }
            }
        });
        JCheckBox delOnExitButton = new JCheckBox("Delete On Exit");
        delOnExitButton.setModel(this.delOnExitModel_);
        Box controlLine = Box.createHorizontalBox();
        controlLine.add(Box.createHorizontalGlue());
        controlLine.add(new JButton(this.abortAction_));
        controlLine.add(Box.createHorizontalStrut(10));
        controlLine.add(new JButton(this.deleteAction_));
        controlLine.add(Box.createHorizontalStrut(20));
        controlLine.add(delOnExitButton);
        controlLine.add(Box.createHorizontalGlue());
        this.updateActions();
        JPanel listContainer = new JPanel(new BorderLayout());
        listContainer.add((Component)new JScrollPane(this.jlist_), "Center");
        listContainer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Job List"));
        Box urlLine = Box.createHorizontalBox();
        urlLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        urlLine.add(new JLabel("URL: "));
        urlLine.add(this.urlField_);
        controlLine.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JPanel detailContainer = new JPanel(new BorderLayout());
        detailContainer.add((Component)new JScrollPane(this.detail_), "Center");
        detailContainer.add((Component)urlLine, "North");
        detailContainer.add((Component)controlLine, "South");
        detailContainer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Job Details"));
        JSplitPane splitter = new JSplitPane(0, listContainer, detailContainer);
        this.add((Component)splitter, "Center");
    }

    public void addJob(UwsJob job, boolean select) {
        this.listModel_.addElement(job);
        if (select) {
            this.jlist_.setSelectedValue(job, true);
        }
        UwsJob.JobWatcher watcher = new UwsJob.JobWatcher(){

            @Override
            public void jobUpdated(UwsJob uj, UwsJobInfo info) {
                UwsJobListPanel.this.scheduleUpdateJobInfo(uj, info);
            }
        };
        this.jobWatcherMap_.put(job, watcher);
        job.addJobWatcher(watcher);
    }

    public void removeJob(UwsJob job) {
        if (this.listModel_.removeElement(job)) {
            UwsJob.JobWatcher watcher = this.jobWatcherMap_.remove(job);
            job.removeJobWatcher(watcher);
        }
        if (this.detail_.getJob() == job) {
            this.detail_.setJob(null);
        }
    }

    public UwsJob[] getJobs() {
        ArrayList<UwsJob> jobList = new ArrayList<UwsJob>();
        for (int i = 0; i < this.listModel_.getSize(); ++i) {
            jobList.add(this.listModel_.getElementAt(i));
        }
        return jobList.toArray(new UwsJob[0]);
    }

    public void reload() {
        final UwsJob job = this.detail_.getJob();
        if (job != null) {
            Thread phaser = new Thread("UWS Phase reader"){

                @Override
                public void run() {
                    UwsJobInfo info;
                    try {
                        info = job.readInfo();
                    }
                    catch (IOException e) {
                        logger_.warning("Phase read fail for UWS job " + job.getJobUrl() + ": " + e);
                        return;
                    }
                    UwsJobListPanel.this.scheduleUpdateJobInfo(job, info);
                }
            };
            phaser.setDaemon(true);
            phaser.start();
        }
    }

    private void scheduleUpdateJobInfo(final UwsJob job, final UwsJobInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int ijob;
                if (UwsJobListPanel.this.detail_.getJob() == job) {
                    UwsJobListPanel.this.detail_.setJobInfo(info);
                    UwsJobListPanel.this.updateActions();
                }
                if ((ijob = UwsJobListPanel.this.listModel_.indexOf(job)) >= 0) {
                    ListDataEvent evt = new ListDataEvent(UwsJobListPanel.this, 0, ijob, ijob);
                    for (ListDataListener l : UwsJobListPanel.this.listModel_.getListDataListeners()) {
                        l.contentsChanged(evt);
                    }
                }
            }
        });
    }

    private void updateActions() {
        UwsJob job = this.detail_.getJob();
        if (job == null) {
            this.deleteAction_.setEnabled(false);
            this.abortAction_.setEnabled(false);
            this.delOnExitModel_.setEnabled(false);
            this.delOnExitModel_.setSelected(false);
        } else {
            UwsJobInfo info = job.getLastInfo();
            boolean isFinished = info != null && UwsStage.forPhase(info.getPhase()) == UwsStage.FINISHED;
            this.deleteAction_.setEnabled(true);
            this.abortAction_.setEnabled(!isFinished);
            this.delOnExitModel_.setEnabled(true);
            this.delOnExitModel_.setSelected(job.getDeleteOnExit());
        }
    }

    private static class UwsJobCellRenderer
    extends DefaultListCellRenderer {
        private Color basicColor_;
        private Color finishedColor_;

        private UwsJobCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jlist, Object value, int ix, boolean isSel, boolean hasFocus) {
            if (this.basicColor_ == null) {
                this.basicColor_ = this.getForeground();
                this.finishedColor_ = Color.GRAY;
            }
            super.getListCellRendererComponent(jlist, value, ix, isSel, hasFocus);
            if (value instanceof UwsJob) {
                UwsJob uwsJob = (UwsJob)value;
                UwsJobInfo info = uwsJob == null ? null : uwsJob.getLastInfo();
                String phase = info == null ? null : info.getPhase();
                UwsStage stage = UwsStage.forPhase(phase);
                this.setText(phase + ":  " + uwsJob.getJobUrl());
                this.setForeground(stage == UwsStage.FINISHED ? this.finishedColor_ : this.basicColor_);
            }
            return this;
        }
    }
}

