/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo.datalink;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.datalink.ServiceDescriptor;
import uk.ac.starlink.votable.datalink.ServiceParam;

public class ServiceInvoker {
    private final ServiceDescriptor descriptor_;
    private final URL urlBase_;
    private final Map<ServiceParam, RowValuer> rowParams_;
    private final Map<ServiceParam, String> fixedParams_;
    private final List<ServiceParam> userParams_;

    public ServiceInvoker(ServiceDescriptor descriptor, StarTable resultTable) throws MalformedURLException, IOException {
        this.descriptor_ = descriptor;
        this.urlBase_ = URLUtils.newURL((String)descriptor.getAccessUrl());
        this.rowParams_ = new LinkedHashMap<ServiceParam, RowValuer>();
        this.fixedParams_ = new LinkedHashMap<ServiceParam, String>();
        this.userParams_ = new ArrayList<ServiceParam>();
        for (ServiceParam p : descriptor.getInputParams()) {
            String ref = p.getRef();
            String value = p.getValue();
            if (ref != null) {
                this.rowParams_.put(p, ServiceInvoker.createRowValuer(resultTable, ref));
                continue;
            }
            if (value != null && value.length() > 0) {
                this.fixedParams_.put(p, value);
                continue;
            }
            this.userParams_.add(p);
        }
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.descriptor_;
    }

    public ServiceParam[] getRowParams() {
        return this.rowParams_.keySet().toArray(new ServiceParam[0]);
    }

    public ServiceParam[] getFixedParams() {
        return this.fixedParams_.keySet().toArray(new ServiceParam[0]);
    }

    public ServiceParam[] getUserParams() {
        return this.userParams_.toArray(new ServiceParam[0]);
    }

    public Map<ServiceParam, String> getFixedParamMap() {
        return this.fixedParams_;
    }

    public Map<ServiceParam, String> getRowParamMap(Object[] row) {
        LinkedHashMap<ServiceParam, String> vmap = new LinkedHashMap<ServiceParam, String>();
        for (Map.Entry<ServiceParam, RowValuer> entry : this.rowParams_.entrySet()) {
            ServiceParam param = entry.getKey();
            String value = entry.getValue().getValueString(row);
            vmap.put(param, value);
        }
        return vmap;
    }

    public URL completeUrl(Map<ServiceParam, String> paramMap) {
        CgiQuery query = new CgiQuery(this.urlBase_.toString());
        for (Map.Entry<ServiceParam, String> entry : paramMap.entrySet()) {
            query.addArgument(entry.getKey().getName(), entry.getValue());
        }
        return query.toURL();
    }

    public URL getUrl(Object[] row, Map<ServiceParam, String> userParamMap) {
        LinkedHashMap<ServiceParam, String> paramMap = new LinkedHashMap<ServiceParam, String>();
        paramMap.putAll(this.getFixedParamMap());
        paramMap.putAll(this.getRowParamMap(row));
        paramMap.putAll(userParamMap);
        return this.completeUrl(paramMap);
    }

    private static RowValuer createRowValuer(StarTable table, String colRef) throws IOException {
        int ncol = table.getColumnCount();
        for (int ic = 0; ic < ncol; ++ic) {
            final ColumnInfo info = table.getColumnInfo(ic);
            if (!colRef.equals(info.getAuxDatumValue(VOStarTable.ID_INFO, String.class))) continue;
            final int icol = ic;
            return new RowValuer(){

                @Override
                public String getValueString(Object[] row) {
                    Object v = row[icol];
                    return v == null ? null : info.formatValue(v, 256);
                }
            };
        }
        throw new IOException("No FIELD found with ID=\"" + colRef + "\"");
    }

    private static interface RowValuer {
        public String getValueString(Object[] var1);
    }
}

